/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.deepicy.utils;

import icy.main.Icy;
import icy.sequence.Sequence;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import io.bioimage.modelrunner.gui.adapter.RunnerAdapter;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.bioimageanalysis.icy.deepicy.engines.Runner;
import org.bioimageanalysis.icy.deepicy.tensor.SequenceRaiManager;
import plugins.tinevez.imglib2icy.ImgLib2IcyFunctions;

public class IcyGui
implements GuiAdapter {
    public String getSoftwareName() {
        return "deepIcy";
    }

    public String getSoftwareDescription() {
        return "The Icy Plugin for AI";
    }

    public Color getTitleColor() {
        return Color.white;
    }

    public Color getSubtitleColor() {
        return Color.white;
    }

    public Color getHeaderColor() {
        return Color.gray;
    }

    public String getIconPath() {
        return "deepicy_imgs/icy_logo.png";
    }

    public String getModelsDir() {
        return new File("models").getAbsolutePath();
    }

    public String getEnginesDir() {
        return new File("engines").getAbsolutePath();
    }

    public RunnerAdapter createRunner(ModelDescriptor descriptor) throws IOException, LoadEngineException {
        return Runner.create(descriptor);
    }

    public RunnerAdapter createRunner(ModelDescriptor descriptor, String enginesPath) throws IOException, LoadEngineException {
        return Runner.create(descriptor, enginesPath);
    }

    public List<String> getInputImageNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(Icy.getMainInterface().getActiveSequence().getName());
        return names;
    }

    public <T extends RealType<T> & NativeType<T>> void displayRai(RandomAccessibleInterval<T> rai, String axesOrder, String imTitle) {
        Sequence im = SequenceRaiManager.convert(rai, axesOrder);
        im.setName(imTitle);
        SwingUtilities.invokeLater(() -> Icy.getMainInterface().addSequence(im));
    }

    public <T extends RealType<T> & NativeType<T>> List<Tensor<T>> getInputTensors(ModelDescriptor descriptor) {
        Sequence imp = Icy.getMainInterface().getActiveSequence();
        List<Tensor<T>> list = Arrays.asList(IcyGui.buildTensor(imp, (TensorSpec)descriptor.getInputTensors().get(0)));
        return list;
    }

    public <T extends RealType<T> & NativeType<T>> List<Tensor<T>> convertToInputTensors(Map<String, Object> inputs, ModelDescriptor descriptor) {
        ArrayList<Tensor<T>> inputTensors = new ArrayList<Tensor<T>>();
        for (TensorSpec tt : descriptor.getInputTensors()) {
            Object im = inputs.get(tt.getName());
            if (im == null) {
                throw new IllegalArgumentException("Missing input tensor: " + tt.getName());
            }
            if (!(im instanceof Sequence)) {
                throw new IllegalArgumentException("Input object should be a Sequence: " + tt.getName());
            }
            Sequence imp = (Sequence)im;
            inputTensors.add(IcyGui.buildTensor(imp, tt));
        }
        return inputTensors;
    }

    private static <T extends RealType<T> & NativeType<T>> Tensor<T> buildTensor(Sequence imp, TensorSpec tensorSpec) {
        RandomAccessibleInterval rai = Views.dropSingletonDimensions((RandomAccessibleInterval)ImgLib2IcyFunctions.wrap((Sequence)imp));
        String axesOrder = "xy";
        if (imp.getDimension5D().getSizeC() != 1.0) {
            axesOrder = axesOrder + "c";
        }
        if (imp.getDimension5D().sizeZ != 1) {
            axesOrder = axesOrder + "z";
        }
        if (imp.getDimension5D().sizeT != 1) {
            axesOrder = axesOrder + "b";
        }
        RandomAccessibleInterval nRai = SequenceRaiManager.permute(rai, axesOrder, tensorSpec.getAxesOrder());
        return Tensor.build((String)tensorSpec.getName(), (String)tensorSpec.getAxesOrder(), nRai);
    }
}

