/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.description.deepimagej.DeepImageJProcessing;
import java.util.HashMap;
import java.util.Map;

public class TransformSpec {
    private boolean isDIJ = false;
    private static String KWARGS_KEY = "kwargs";
    private static String TRANSFORMATION_NAME_KEY = "name";
    private Map<String, Object> specMap;

    public static TransformSpec build(Map<String, Object> transformSpecMap) {
        TransformSpec transform = new TransformSpec();
        transform.specMap = transformSpecMap;
        return transform;
    }

    public Map<String, Object> getSpecMap() {
        return this.specMap == null ? null : this.specMap;
    }

    public String getName() {
        if (this.specMap == null) {
            return null;
        }
        if (this.specMap.get("name") != null) {
            return (String)this.specMap.get("name");
        }
        return (String)this.specMap.get("id");
    }

    public Map<String, Object> getKwargs() {
        return this.specMap == null ? null : (Map)this.specMap.get("kwargs");
    }

    public boolean isDIJ() {
        return this.isDIJ;
    }

    public static TransformSpec createTransformForDIJ(DeepImageJProcessing dij) {
        HashMap<String, Object> transformSpecs = new HashMap<String, Object>();
        transformSpecs.put("name", dij.getMacros().toString());
        TransformSpec transform = new TransformSpec();
        transform.specMap = transformSpecs;
        transform.isDIJ = true;
        return transform;
    }

    public static String getKwargsKey() {
        return KWARGS_KEY;
    }

    public static String getTransformationNameKey() {
        return TRANSFORMATION_NAME_KEY;
    }

    public String toString() {
        return "TransformSpec {specMap=" + this.specMap + "}";
    }
}

