/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.transformations;

import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.transformations.AbstractTensorPixelTransformation;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class ClipTransformation
extends AbstractTensorPixelTransformation {
    private static String name = "clip";
    private Double min;
    private Double max;
    private double eps = Math.pow(10.0, -6.0);

    public ClipTransformation() {
        super(name);
        super.setDoubleUnitaryOperator(v -> v >= this.max ? this.max : (v < this.min ? this.min : v));
    }

    public void setEps(Object eps) {
        if (eps instanceof Integer) {
            this.eps = ((Integer)eps).intValue();
        } else if (eps instanceof Double) {
            this.eps = (Double)eps;
        } else if (eps instanceof String) {
            this.eps = Double.valueOf((String)eps);
        } else {
            throw new IllegalArgumentException("'eps' parameter has to be either and instance of " + Float.class + " or " + Double.class + ". The provided argument is an instance of: " + eps.getClass());
        }
    }

    public void setMin(Object min) {
        if (min instanceof Integer) {
            this.min = (double)((Integer)min);
        } else if (min instanceof Double) {
            this.min = (double)((Double)min);
        } else if (min instanceof String) {
            this.min = Double.valueOf((String)min);
        } else {
            throw new IllegalArgumentException("'min' parameter has to be either and instance of " + Integer.class + " or " + Double.class + ". The provided argument is an instance of: " + min.getClass());
        }
    }

    public void setMax(Object max) {
        if (max instanceof Integer) {
            this.max = (double)((Integer)max);
        } else if (max instanceof Double) {
            this.max = (double)((Double)max);
        } else if (max instanceof String) {
            this.max = Double.valueOf((String)max);
        } else {
            throw new IllegalArgumentException("'max' parameter has to be either and instance of " + Integer.class + " or " + Double.class + ". The provided argument is an instance of: " + max.getClass());
        }
    }

    public void checkRequiredArgs() {
        if (this.min == null) {
            throw new IllegalArgumentException(String.format(DEFAULT_MISSING_ARG_ERR, name, "min"));
        }
        if (this.max == null) {
            throw new IllegalArgumentException(String.format(DEFAULT_MISSING_ARG_ERR, name, "max"));
        }
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> Tensor<FloatType> apply(Tensor<R> input) {
        this.checkRequiredArgs();
        return super.apply(input);
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> void applyInPlace(Tensor<R> input) {
        this.checkRequiredArgs();
        super.applyInPlace(input);
    }
}

