/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.common.CollapsibleEvent;
import icy.painter.Overlay;
import icy.painter.OverlayEvent;
import icy.painter.PainterEvent;
import icy.painter.PainterListener;
import icy.painter.VtkPainter;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import icy.util.EventUtil;
import icy.util.ShapeUtil;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import vtk.vtkActor;
import vtk.vtkInformation;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;

public class Anchor2D
extends Overlay
implements VtkPainter,
Runnable {
    protected static final String ID_COLOR = "color";
    protected static final String ID_SELECTEDCOLOR = "selected_color";
    protected static final String ID_SELECTED = "selected";
    protected static final String ID_POS_X = "pos_x";
    protected static final String ID_POS_Y = "pos_y";
    protected static final String ID_RAY = "ray";
    protected static final String ID_VISIBLE = "visible";
    public static final int DEFAULT_RAY = 6;
    public static final Color DEFAULT_NORMAL_COLOR = Color.YELLOW;
    public static final Color DEFAULT_SELECTED_COLOR = Color.WHITE;
    public static final String PROPERTY_COLOR = "color";
    public static final String PROPERTY_SELECTEDCOLOR = "selected_color";
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_RAY = "ray";
    protected final Point2D.Double position;
    protected int z;
    protected int ray;
    protected Color color;
    protected Color selectedColor;
    protected boolean selected;
    protected boolean visible;
    protected final Ellipse2D ellipse;
    protected Point2D startDragMousePosition;
    protected Point2D startDragPainterPosition;
    vtkSphereSource vtkSource;
    protected vtkPolyDataMapper polyMapper;
    protected vtkActor actor;
    protected vtkInformation vtkInfo;
    protected boolean needRebuild;
    protected boolean needPropertiesUpdate;
    protected double[] scaling;
    protected WeakReference<VtkCanvas> canvas3d;
    protected final List<Anchor2DListener> anchor2Dlisteners;
    protected final List<Anchor2DPositionListener> anchor2DPositionlisteners;

    public Anchor2D(double x, double y, int ray, Color color, Color selectedColor) {
        super("Anchor", Overlay.OverlayPriority.SHAPE_NORMAL);
        this.position = new Point2D.Double(x, y);
        this.z = -1;
        this.ray = ray;
        this.color = color;
        this.selectedColor = selectedColor;
        this.selected = false;
        this.visible = true;
        this.ellipse = new Ellipse2D.Double();
        this.startDragMousePosition = null;
        this.startDragPainterPosition = null;
        this.vtkSource = null;
        this.polyMapper = null;
        this.actor = null;
        this.vtkInfo = null;
        this.scaling = new double[3];
        Arrays.fill(this.scaling, 1.0);
        this.needRebuild = true;
        this.needPropertiesUpdate = false;
        this.canvas3d = new WeakReference<Object>(null);
        this.anchor2Dlisteners = new ArrayList<Anchor2DListener>();
        this.anchor2DPositionlisteners = new ArrayList<Anchor2DPositionListener>();
    }

    public Anchor2D(double x, double y, int ray, Color color) {
        this(x, y, ray, color, DEFAULT_SELECTED_COLOR);
    }

    public Anchor2D(double x, double y, int ray) {
        this(x, y, ray, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
    }

    public Anchor2D(double x, double y, Color color, Color selectedColor) {
        this(x, y, 6, color, selectedColor);
    }

    public Anchor2D(double x, double y, Color color) {
        this(x, y, 6, color, DEFAULT_SELECTED_COLOR);
    }

    public Anchor2D(double x, double y) {
        this(x, y, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
    }

    public Anchor2D() {
        this(0.0, 0.0, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
    }

    @Deprecated
    public Anchor2D(Point2D position, int ray, Color color, Color selectedColor) {
        this(position.getX(), position.getY(), ray, color, selectedColor);
    }

    @Deprecated
    public Anchor2D(Point2D position, int ray, Color color) {
        this(position.getX(), position.getY(), ray, color, DEFAULT_SELECTED_COLOR);
    }

    @Deprecated
    public Anchor2D(Point2D position, int ray) {
        this(position.getX(), position.getY(), ray, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
    }

    @Deprecated
    public Anchor2D(Point2D position, Color color, Color selectedColor) {
        this(position.getX(), position.getY(), 6, color, selectedColor);
    }

    @Deprecated
    public Anchor2D(Point2D position, Color color) {
        this(position.getX(), position.getY(), 6, color, DEFAULT_SELECTED_COLOR);
    }

    @Deprecated
    public Anchor2D(Point2D position) {
        this(position.getX(), position.getY(), 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, double x, double y, int ray, Color color, Color selectedColor) {
        this(x, y, ray, color, selectedColor);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, Point2D position, int ray, Color color, Color selectedColor) {
        this(position.getX(), position.getY(), ray, color, selectedColor);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, Point2D position, int ray, Color color) {
        this(position.getX(), position.getY(), ray, color, DEFAULT_SELECTED_COLOR);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, double x, double y, int ray) {
        this(x, y, ray, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, Point2D position, Color color) {
        this(position.getX(), position.getY(), 6, color, DEFAULT_SELECTED_COLOR);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, Point2D position, int ray) {
        this(position.getX(), position.getY(), ray, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, double x, double y, Color color, Color selectedColor) {
        this(x, y, 6, color, selectedColor);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, Point2D position, Color color, Color selectedColor) {
        this(position.getX(), position.getY(), 6, color, selectedColor);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, double x, double y, Color color) {
        this(x, y, 6, color, DEFAULT_SELECTED_COLOR);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, double x, double y) {
        this(sequence, x, y, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence, Point2D position) {
        this(position.getX(), position.getY(), 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
        sequence.addOverlay(this);
    }

    @Deprecated
    public Anchor2D(Sequence sequence) {
        this(0.0, 0.0, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
        sequence.addOverlay(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.vtkSource != null) {
            this.vtkSource.Delete();
        }
        if (this.actor != null) {
            this.actor.SetPropertyKeys(null);
            this.actor.Delete();
        }
        if (this.vtkInfo != null) {
            this.vtkInfo.Remove(VtkCanvas.visibilityKey);
            this.vtkInfo.Delete();
        }
        if (this.polyMapper != null) {
            this.polyMapper.Delete();
        }
    }

    public double getX() {
        return this.position.x;
    }

    public void setX(double x) {
        this.setPosition(x, this.position.y);
    }

    public double getY() {
        return this.position.y;
    }

    public void setY(double y) {
        this.setPosition(this.position.x, y);
    }

    public Point2D getPositionInternal() {
        return this.position;
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.position.x, this.position.y);
    }

    public double getPositionX() {
        return this.position.x;
    }

    public double getPositionY() {
        return this.position.y;
    }

    public void moveTo(Point2D p) {
        this.setPosition(p.getX(), p.getY());
    }

    public void moveTo(double x, double y) {
        this.setPosition(x, y);
    }

    public void setPosition(Point2D p) {
        this.setPosition(p.getX(), p.getY());
    }

    public void setPosition(double x, double y) {
        if (this.position.x != x || this.position.y != y) {
            this.position.x = x;
            this.position.y = y;
            this.needRebuild = true;
            this.positionChanged();
            this.painterChanged();
        }
    }

    public void translate(double dx, double dy) {
        this.setPosition(this.position.x + dx, this.position.y + dy);
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int value) {
        int v = value == Integer.MIN_VALUE ? -1 : value;
        if (this.z != v) {
            this.z = v;
            this.needRebuild = true;
            this.painterChanged();
            this.positionChanged();
        }
    }

    public int getRay() {
        return this.ray;
    }

    public void setRay(int value) {
        if (this.ray != value) {
            this.ray = value;
            this.needRebuild = true;
            this.painterChanged();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        if (this.color != value) {
            this.color = value;
            this.needPropertiesUpdate = true;
            this.propertyChanged("color");
            this.painterChanged();
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color value) {
        if (this.selectedColor != value) {
            this.selectedColor = value;
            this.needPropertiesUpdate = true;
            this.propertyChanged("selected_color");
            this.painterChanged();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value) {
        if (this.selected != value) {
            this.selected = value;
            if (!value) {
                this.startDragMousePosition = null;
            }
            this.needPropertiesUpdate = true;
            this.propertyChanged("selected");
            this.painterChanged();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        if (this.visible != value) {
            this.visible = value;
            this.needPropertiesUpdate = true;
            this.painterChanged();
        }
    }

    protected void initVtkObjects() {
        this.vtkSource = new vtkSphereSource();
        this.vtkSource.SetRadius((double)this.getRay());
        this.vtkSource.SetThetaResolution(12);
        this.vtkSource.SetPhiResolution(12);
        this.polyMapper = new vtkPolyDataMapper();
        this.polyMapper.SetInputConnection(this.vtkSource.GetOutputPort());
        this.actor = new vtkActor();
        this.actor.SetMapper((vtkMapper)this.polyMapper);
        this.vtkInfo = new vtkInformation();
        this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
        this.actor.SetPropertyKeys(this.vtkInfo);
        Color col = this.getColor();
        this.actor.GetProperty().SetColor((double)col.getRed() / 255.0, (double)col.getGreen() / 255.0, (double)col.getBlue() / 255.0);
    }

    protected boolean rebuildVtkObjects() {
        VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
        if (canvas == null) {
            return false;
        }
        IcyVtkPanel vtkPanel = canvas.getVtkPanel();
        if (vtkPanel == null) {
            return false;
        }
        Sequence seq = canvas.getSequence();
        if (seq == null) {
            return false;
        }
        Point2D pos = this.getPosition();
        double curZ = this.getZ();
        if (curZ == -1.0) {
            curZ = (double)seq.getSizeZ() / 2.0;
        }
        vtkPanel.lock();
        try {
            this.vtkSource.SetCenter(pos.getX() * this.scaling[0], pos.getY() * this.scaling[1], (curZ + 0.5) * this.scaling[2]);
            this.polyMapper.Update();
        }
        finally {
            vtkPanel.unlock();
        }
        this.painterChanged();
        return true;
    }

    protected void updateVtkDisplayProperties() {
        IcyVtkPanel vtkPanel;
        if (this.actor == null) {
            return;
        }
        VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
        Color col = this.isSelected() ? this.getSelectedColor() : this.getColor();
        double r = (double)col.getRed() / 255.0;
        double g = (double)col.getGreen() / 255.0;
        double b = (double)col.getBlue() / 255.0;
        IcyVtkPanel icyVtkPanel = vtkPanel = cnv != null ? cnv.getVtkPanel() : null;
        if (vtkPanel != null) {
            vtkPanel.lock();
        }
        try {
            this.actor.GetProperty().SetColor(r, g, b);
            if (this.isVisible()) {
                this.actor.SetVisibility(1);
                this.vtkInfo.Set(VtkCanvas.visibilityKey, 1);
            } else {
                this.actor.SetVisibility(0);
                this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
            }
        }
        finally {
            if (vtkPanel != null) {
                vtkPanel.unlock();
            }
        }
        this.painterChanged();
    }

    protected void updateVtkRadius() {
        VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
        if (canvas == null) {
            return;
        }
        IcyVtkPanel vtkPanel = canvas.getVtkPanel();
        if (vtkPanel == null) {
            return;
        }
        if (this.vtkSource == null) {
            return;
        }
        double radius = this.getAdjRay(canvas) * this.scaling[0];
        if (this.vtkSource.GetRadius() != radius) {
            vtkPanel.lock();
            try {
                this.vtkSource.SetRadius(radius);
                this.vtkSource.Update();
            }
            finally {
                vtkPanel.unlock();
            }
            this.painterChanged();
        }
    }

    @Override
    public vtkProp[] getProps() {
        if (this.actor == null) {
            this.initVtkObjects();
        }
        return new vtkActor[]{this.actor};
    }

    public boolean isOver(IcyCanvas canvas, Point2D imagePoint) {
        this.updateEllipseForCanvas(canvas);
        if (canvas instanceof VtkCanvas) {
            return this.actor != null && this.actor == ((VtkCanvas)canvas).getPickedObject();
        }
        if (imagePoint == null) {
            return false;
        }
        if (this.ellipse.getBounds2D().contains(imagePoint)) {
            return this.ellipse.contains(imagePoint);
        }
        return false;
    }

    public boolean isOver(IcyCanvas canvas, double x, double y) {
        return this.isOver(canvas, new Point2D.Double(x, y));
    }

    protected double getAdjRay(IcyCanvas canvas) {
        return canvas.canvasToImageLogDeltaX(this.ray);
    }

    protected void updateEllipseForCanvas(IcyCanvas canvas) {
        if (canvas instanceof VtkCanvas) {
            double[] s;
            VtkCanvas cnv = (VtkCanvas)canvas;
            if (this.canvas3d.get() != cnv) {
                this.canvas3d = new WeakReference<VtkCanvas>(cnv);
            }
            if (!Arrays.equals(this.scaling, s = cnv.getVolumeScale())) {
                this.scaling = s;
                this.needRebuild = true;
            }
            if (this.needRebuild) {
                if (this.actor == null) {
                    this.initVtkObjects();
                }
                ThreadUtil.runSingle(this);
                this.needRebuild = false;
            }
            if (this.needPropertiesUpdate) {
                this.updateVtkDisplayProperties();
                this.needPropertiesUpdate = false;
            }
            this.updateVtkRadius();
        } else {
            double adjRay = this.getAdjRay(canvas);
            this.ellipse.setFrame(this.position.x - adjRay, this.position.y - adjRay, adjRay * 2.0, adjRay * 2.0);
        }
    }

    protected boolean updateDrag(InputEvent e, double x, double y) {
        if (this.startDragMousePosition == null) {
            return false;
        }
        double dx = x - this.startDragMousePosition.getX();
        double dy = y - this.startDragMousePosition.getY();
        if (EventUtil.isShiftDown(e)) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0.0;
            } else {
                dx = 0.0;
            }
        }
        this.setPosition(this.startDragPainterPosition.getX() + dx, this.startDragPainterPosition.getY() + dy);
        return true;
    }

    protected boolean updateDrag(InputEvent e, Point2D pt) {
        return this.updateDrag(e, pt.getX(), pt.getY());
    }

    protected void positionChanged() {
        this.updater.changed(new Anchor2DEvent(this));
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        OverlayEvent event;
        if (object instanceof Anchor2DEvent) {
            this.firePositionChangedEvent(((Anchor2DEvent)object).getSource());
            return;
        }
        if (object instanceof OverlayEvent && (event = (OverlayEvent)object).getType() == OverlayEvent.OverlayEventType.PAINTER_CHANGED) {
            PainterEvent pe = new PainterEvent(this, PainterEvent.PainterEventType.PAINTER_CHANGED);
            for (Anchor2DListener listener : new ArrayList<Anchor2DListener>(this.anchor2Dlisteners)) {
                listener.painterChanged(pe);
            }
        }
        super.onChanged(object);
    }

    protected void firePositionChangedEvent(Anchor2D source) {
        for (Anchor2DPositionListener anchor2DPositionListener : new ArrayList<Anchor2DPositionListener>(this.anchor2DPositionlisteners)) {
            anchor2DPositionListener.positionChanged(source);
        }
        for (Anchor2DListener anchor2DListener : new ArrayList<Anchor2DListener>(this.anchor2Dlisteners)) {
            anchor2DListener.positionChanged(source);
        }
    }

    public void addPositionListener(Anchor2DPositionListener listener) {
        this.anchor2DPositionlisteners.add(listener);
    }

    public void removePositionListener(Anchor2DPositionListener listener) {
        this.anchor2DPositionlisteners.remove(listener);
    }

    @Deprecated
    public void addAnchorListener(Anchor2DListener listener) {
        this.anchor2Dlisteners.add(listener);
    }

    @Deprecated
    public void removeAnchorListener(Anchor2DListener listener) {
        this.anchor2Dlisteners.remove(listener);
    }

    @Deprecated
    public void addListener(Anchor2DListener listener) {
        this.addAnchorListener(listener);
    }

    @Deprecated
    public void removeListener(Anchor2DListener listener) {
        this.removeAnchorListener(listener);
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas, boolean simplified) {
        this.updateEllipseForCanvas(canvas);
        if (canvas instanceof IcyCanvas2D) {
            boolean sameZPos;
            if (!this.isVisible()) {
                return;
            }
            int cnvZ = canvas.getPositionZ();
            int z = this.getZ();
            boolean bl = sameZPos = z == -1 || cnvZ == -1 || z == cnvZ;
            if (sameZPos && ShapeUtil.isVisible(g, this.ellipse)) {
                Graphics2D g2 = (Graphics2D)g.create();
                if (this.isSelected()) {
                    g2.setColor(this.getSelectedColor());
                } else {
                    g2.setColor(this.getColor());
                }
                if (simplified) {
                    int ray = (int)canvas.canvasToImageDeltaX(2);
                    g2.fillRect((int)this.getPositionX() - ray, (int)this.getPositionY() - ray, ray * 2, ray * 2);
                } else {
                    g2.fill(this.ellipse);
                    g2.setStroke(new BasicStroke((float)(this.getAdjRay(canvas) / 8.0)));
                    g2.setColor(Color.black);
                    g2.draw(this.ellipse);
                }
                g2.dispose();
            }
        } else {
            boolean cfr_ignored_0 = canvas instanceof VtkCanvas;
        }
    }

    @Override
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        this.paint(g, sequence, canvas, false);
    }

    @Override
    @Deprecated
    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (canvas instanceof VtkCanvas) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        this.updateDrag(e, imagePoint);
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (canvas instanceof VtkCanvas) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        this.updateDrag(e, imagePoint);
    }

    @Override
    @Deprecated
    public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (canvas instanceof VtkCanvas) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        if (EventUtil.isLeftMouseButton(e) && this.isSelected()) {
            this.startDragMousePosition = imagePoint;
            this.startDragPainterPosition = this.getPosition();
            e.consume();
        }
    }

    @Override
    @Deprecated
    public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        this.startDragMousePosition = null;
    }

    @Override
    @Deprecated
    public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (canvas instanceof VtkCanvas) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        if (EventUtil.isLeftMouseButton(e) && this.isSelected()) {
            if (this.startDragMousePosition == null) {
                this.startDragMousePosition = this.getPosition();
                this.startDragPainterPosition = this.getPosition();
            }
            this.updateDrag(e, imagePoint);
            e.consume();
        }
    }

    @Override
    @Deprecated
    public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (canvas instanceof VtkCanvas) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        if (e.isConsumed()) {
            this.setSelected(false);
        } else {
            boolean overlapped = this.isOver(canvas, imagePoint.getX(), imagePoint.getY());
            this.setSelected(overlapped);
            if (overlapped) {
                e.consume();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        this.updateDrag(e, imagePoint.x, imagePoint.y);
    }

    @Override
    public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        this.updateDrag(e, imagePoint.x, imagePoint.y);
    }

    @Override
    public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        if (EventUtil.isLeftMouseButton(e) && this.isSelected()) {
            this.startDragMousePosition = imagePoint.toPoint2D();
            this.startDragPainterPosition = this.getPosition();
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        this.startDragMousePosition = null;
    }

    @Override
    public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        if (EventUtil.isLeftMouseButton(e) && this.isSelected()) {
            if (this.startDragMousePosition == null) {
                this.startDragMousePosition = this.getPosition();
                this.startDragPainterPosition = this.getPosition();
            }
            this.updateDrag(e, imagePoint.x, imagePoint.y);
            e.consume();
        }
    }

    @Override
    public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible()) {
            return;
        }
        if (e.isConsumed()) {
            this.setSelected(false);
        } else {
            boolean overlapped = this.isOver(canvas, imagePoint != null ? imagePoint.toPoint2D() : null);
            this.setSelected(overlapped);
            if (overlapped) {
                e.consume();
            }
        }
    }

    @Override
    public void run() {
        this.rebuildVtkObjects();
    }

    public boolean loadPositionFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            this.setX(XMLUtil.getElementDoubleValue(node, ID_POS_X, 0.0));
            this.setY(XMLUtil.getElementDoubleValue(node, ID_POS_Y, 0.0));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    public boolean savePositionToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementDoubleValue(node, ID_POS_X, this.getX());
        XMLUtil.setElementDoubleValue(node, ID_POS_Y, this.getY());
        return true;
    }

    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            this.setColor(new Color(XMLUtil.getElementIntValue(node, "color", DEFAULT_NORMAL_COLOR.getRGB())));
            this.setSelectedColor(new Color(XMLUtil.getElementIntValue(node, "selected_color", DEFAULT_SELECTED_COLOR.getRGB())));
            this.setX(XMLUtil.getElementDoubleValue(node, ID_POS_X, 0.0));
            this.setY(XMLUtil.getElementDoubleValue(node, ID_POS_Y, 0.0));
            this.setRay(XMLUtil.getElementIntValue(node, "ray", 6));
            this.setVisible(XMLUtil.getElementBooleanValue(node, ID_VISIBLE, true));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementIntValue(node, "color", this.getColor().getRGB());
        XMLUtil.setElementIntValue(node, "selected_color", this.getSelectedColor().getRGB());
        XMLUtil.setElementDoubleValue(node, ID_POS_X, this.getX());
        XMLUtil.setElementDoubleValue(node, ID_POS_Y, this.getY());
        XMLUtil.setElementIntValue(node, "ray", this.getRay());
        XMLUtil.setElementBooleanValue(node, ID_VISIBLE, this.isVisible());
        return true;
    }

    public static class Anchor2DEvent
    implements CollapsibleEvent {
        private final Anchor2D source;

        public Anchor2DEvent(Anchor2D source) {
            this.source = source;
        }

        public Anchor2D getSource() {
            return this.source;
        }

        @Override
        public boolean collapse(CollapsibleEvent event) {
            return this.equals(event);
        }

        @Override
        public int hashCode() {
            return this.source.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Anchor2DEvent) {
                Anchor2DEvent event = (Anchor2DEvent)obj;
                return event.getSource() == this.source;
            }
            return super.equals(obj);
        }
    }

    @Deprecated
    public static interface Anchor2DListener
    extends PainterListener {
        public void positionChanged(Anchor2D var1);
    }

    public static interface Anchor2DPositionListener
    extends EventListener {
        public void positionChanged(Anchor2D var1);
    }
}

