/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.common.CollapsibleEvent;
import icy.math.Line3DIterator;
import icy.painter.Anchor3D;
import icy.painter.OverlayEvent;
import icy.painter.OverlayListener;
import icy.roi.ROI;
import icy.roi.ROI3D;
import icy.roi.ROIEvent;
import icy.roi.edit.Point3DAddedROIEdit;
import icy.roi.edit.Point3DMovedROIEdit;
import icy.roi.edit.Point3DRemovedROIEdit;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.geom.Line3D;
import icy.type.geom.Shape3D;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import icy.vtk.IcyVtkPanel;
import icy.vtk.VtkUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import vtk.vtkActor;
import vtk.vtkCellArray;
import vtk.vtkInformation;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProperty;
import vtk.vtkRenderer;

public class ROI3DShape
extends ROI3D
implements Shape3D {
    public static final String ID_POINTS = "points";
    public static final String ID_POINT = "point";
    protected final Shape3D shape;
    protected final List<Anchor3D> controlPoints;
    protected final Anchor3D.Anchor3DPositionListener anchor3DPositionListener;
    protected final OverlayListener anchor3DOverlayListener;
    protected boolean firstMove;

    protected static void drawLine3D(Graphics2D g, Sequence sequence, IcyCanvas canvas, Point3D p1, Point3D p2) {
        Line2D.Double line2d = new Line2D.Double();
        int cnvZ = canvas.getPositionZ();
        double zRange = Math.min(10.0, Math.max(3.0, (double)sequence.getSizeZ() / 8.0));
        if (p1.getZ() == p2.getZ()) {
            ROI3DShape.drawSegment3D(g, p1, p2, zRange, cnvZ, line2d);
        } else {
            Line3DIterator it = new Line3DIterator(new Line3D(p1, p2), 4.0 / canvas.getScaleX());
            Point3D pos = it.next();
            do {
                Point3D nextPos = it.next();
                ROI3DShape.drawSegment3D(g, pos, nextPos, zRange, cnvZ, line2d);
                pos = nextPos;
            } while (it.hasNext());
        }
    }

    protected static void drawSegment3D(Graphics2D g, Point3D p1, Point3D p2, double zRange, int canvasZ, Line2D line2d) {
        double meanZ = (p1.getZ() + p2.getZ()) / 2.0;
        double dz = Math.abs(meanZ - (double)canvasZ);
        if (dz > zRange) {
            return;
        }
        float ratio = 1.0f - (float)(dz / zRange);
        Composite prevComposite = g.getComposite();
        if (ratio != 1.0f) {
            GraphicsUtil.mixAlpha(g, ratio);
        }
        line2d.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        g.draw(line2d);
        g.setComposite(prevComposite);
    }

    public ROI3DShape(Shape3D shape) {
        this.shape = shape;
        this.controlPoints = new ArrayList<Anchor3D>();
        this.firstMove = true;
        this.anchor3DPositionListener = new Anchor3D.Anchor3DPositionListener(){

            @Override
            public void positionChanged(Anchor3D source) {
                ROI3DShape.this.controlPointPositionChanged(source);
            }
        };
        this.anchor3DOverlayListener = new OverlayListener(){

            @Override
            public void overlayChanged(OverlayEvent event) {
                ROI3DShape.this.controlPointOverlayChanged(event);
            }
        };
    }

    @Override
    public String getDefaultName() {
        return "Shape3D";
    }

    @Override
    protected ROI3DShapePainter createPainter() {
        return new ROI3DShapePainter();
    }

    protected Anchor3D createAnchor(Point3D pos) {
        return new Anchor3D(pos.getX(), pos.getY(), pos.getZ(), this.getColor(), this.getFocusedColor());
    }

    public Shape3D getShape() {
        return this.shape;
    }

    public boolean canAddPoint() {
        return true;
    }

    public boolean canRemovePoint() {
        return true;
    }

    protected void addPoint(Anchor3D pt) {
        this.addPoint(pt, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(Anchor3D pt, int index) {
        pt.setVisible(this.isSelected());
        pt.addPositionListener(this.anchor3DPositionListener);
        pt.addOverlayListener(this.anchor3DOverlayListener);
        if (index == -1) {
            this.controlPoints.add(pt);
        } else {
            this.controlPoints.add(index, pt);
        }
        Set<Anchor3D> set = ((ROI3DShapePainter)this.getOverlay()).actorsToAdd;
        synchronized (set) {
            ((ROI3DShapePainter)this.getOverlay()).actorsToAdd.add(pt);
        }
        set = ((ROI3DShapePainter)this.getOverlay()).actorsToRemove;
        synchronized (set) {
            ((ROI3DShapePainter)this.getOverlay()).actorsToRemove.remove(pt);
        }
        this.roiChanged(true);
    }

    public Anchor3D addNewPoint(Point3D pos, boolean insert) {
        if (!this.canAddPoint()) {
            return null;
        }
        Anchor3D pt = this.createAnchor(pos);
        if (insert) {
            this.addPoint(pt, this.getInsertPointPosition(pos));
        } else {
            this.addPoint(pt);
        }
        pt.setSelected(true);
        return pt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removePoint(IcyCanvas canvas, Anchor3D pt) {
        boolean empty;
        pt.removeOverlayListener(this.anchor3DOverlayListener);
        pt.removePositionListener(this.anchor3DPositionListener);
        Collection<Anchor3D> collection = this.controlPoints;
        synchronized (collection) {
            this.controlPoints.remove(pt);
            empty = this.controlPoints.isEmpty();
        }
        collection = ((ROI3DShapePainter)this.getOverlay()).actorsToRemove;
        synchronized (collection) {
            ((ROI3DShapePainter)this.getOverlay()).actorsToRemove.add(pt);
        }
        collection = ((ROI3DShapePainter)this.getOverlay()).actorsToAdd;
        synchronized (collection) {
            ((ROI3DShapePainter)this.getOverlay()).actorsToAdd.remove(pt);
        }
        if (empty) {
            this.remove();
        } else {
            this.roiChanged(true);
        }
        return true;
    }

    public boolean removePoint(Anchor3D pt) {
        return this.removePoint(null, pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllPoint() {
        List<Anchor3D> list = this.controlPoints;
        synchronized (list) {
            Set<Anchor3D> set = ((ROI3DShapePainter)this.getOverlay()).actorsToRemove;
            synchronized (set) {
                ((ROI3DShapePainter)this.getOverlay()).actorsToRemove.addAll(this.controlPoints);
            }
            set = ((ROI3DShapePainter)this.getOverlay()).actorsToAdd;
            synchronized (set) {
                ((ROI3DShapePainter)this.getOverlay()).actorsToAdd.removeAll(this.controlPoints);
            }
            for (Anchor3D pt : this.controlPoints) {
                pt.removeOverlayListener(this.anchor3DOverlayListener);
                pt.removePositionListener(this.anchor3DPositionListener);
            }
            this.controlPoints.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSelectedPoint(IcyCanvas canvas) {
        if (!this.canRemovePoint()) {
            return false;
        }
        Anchor3D selectedPoint = this.getSelectedPoint();
        if (selectedPoint == null) {
            return false;
        }
        List<Anchor3D> list = this.controlPoints;
        synchronized (list) {
            block8: {
                if (this.removePoint(canvas, selectedPoint)) break block8;
                return false;
            }
            if (this.controlPoints.size() > 0) {
                Point3D imagePoint = selectedPoint.getPosition();
                if (this.controlPoints.size() > 0) {
                    this.selectPointAt(canvas, imagePoint);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Anchor3D getSelectedPoint() {
        List<Anchor3D> list = this.controlPoints;
        synchronized (list) {
            for (Anchor3D pt : this.controlPoints) {
                if (!pt.isSelected()) continue;
                return pt;
            }
        }
        return null;
    }

    @Override
    public boolean hasSelectedPoint() {
        return this.getSelectedPoint() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean selectPointAt(IcyCanvas canvas, Point3D imagePoint) {
        List<Anchor3D> list = this.controlPoints;
        synchronized (list) {
            Anchor3D pt;
            Iterator<Anchor3D> iterator = this.controlPoints.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(pt = iterator.next()).isOver(canvas, imagePoint));
            pt.setSelected(true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unselectAllPoints() {
        this.beginUpdate();
        try {
            List<Anchor3D> list = this.controlPoints;
            synchronized (list) {
                for (Anchor3D pt : this.controlPoints) {
                    pt.setSelected(false);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    protected double getTotalDistance(List<Point3D> points, double factorX, double factorY, double factorZ) {
        return Point3D.getTotalDistance(points, factorX, factorY, factorZ, true);
    }

    @Override
    public double getLength(Sequence sequence) {
        return this.getTotalDistance(this.getPointsInternal(), sequence.getPixelSizeX(), sequence.getPixelSizeY(), sequence.getPixelSizeZ());
    }

    @Override
    public double computeSurfaceArea(Sequence sequence) throws InterruptedException {
        return 0.0;
    }

    @Override
    public double computeNumberOfContourPoints() throws InterruptedException {
        return this.getTotalDistance(this.getPointsInternal(), 1.0, 1.0, 1.0);
    }

    protected int getInsertPointPosition(Point3D pos) {
        int size;
        List<Point3D> points = this.getPointsInternal();
        int result = size = points.size();
        double minDistance = Double.MAX_VALUE;
        int i = size;
        while (i >= 0) {
            points.add(i, pos);
            double d = this.getTotalDistance(points, 1.0, 1.0, 1.0);
            if (d < minDistance) {
                minDistance = d;
                result = i;
            }
            points.remove(i);
            --i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Anchor3D> getControlPoints() {
        List<Anchor3D> list = this.controlPoints;
        synchronized (list) {
            return new ArrayList<Anchor3D>(this.controlPoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Point3D> getPoints() {
        ArrayList<Point3D> result = new ArrayList<Point3D>();
        List<Anchor3D> list = this.controlPoints;
        synchronized (list) {
            for (Anchor3D pt : this.controlPoints) {
                result.add(pt.getPosition());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Point3D> getPointsInternal() {
        ArrayList<Point3D> result = new ArrayList<Point3D>();
        List<Anchor3D> list = this.controlPoints;
        synchronized (list) {
            for (Anchor3D pt : this.controlPoints) {
                result.add(pt.getPositionInternal());
            }
        }
        return result;
    }

    @Override
    public boolean isOverEdge(IcyCanvas canvas, double x, double y, double z) {
        double strk = this.painter.getAdjustedStroke(canvas) * 3.0;
        Rectangle3D.Double rect = new Rectangle3D.Double(x - strk * 0.5, y - strk * 0.5, z - strk * 0.5, strk, strk, strk);
        Rectangle3D roiBounds = this.getBounds3D();
        if (roiBounds.isEmpty()) {
            return rect.intersectsLine(roiBounds.getMinX(), roiBounds.getMinY(), roiBounds.getMinZ(), roiBounds.getMaxX(), roiBounds.getMaxY(), roiBounds.getMaxZ());
        }
        return this.intersects(rect);
    }

    @Override
    public boolean contains(Point3D p) {
        return this.shape.contains(p);
    }

    @Override
    public boolean contains(Rectangle3D r) {
        return this.shape.contains(r);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.shape.contains(x, y, z);
    }

    @Override
    public boolean contains(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        return this.shape.contains(x, y, z, sizeX, sizeY, sizeZ);
    }

    @Override
    public boolean intersects(Rectangle3D r) {
        return this.shape.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        return this.shape.intersects(x, y, z, sizeX, sizeY, sizeZ);
    }

    @Override
    public Rectangle3D computeBounds3D() {
        Rectangle3D result = this.shape.getBounds();
        if (result.isEmpty()) {
            result.setSizeX(Math.max(result.getSizeX(), 0.001));
            result.setSizeY(Math.max(result.getSizeY(), 0.001));
            result.setSizeZ(Math.max(result.getSizeZ(), 0.001));
        }
        return result;
    }

    @Override
    public boolean canTranslate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(double dx, double dy, double dz) {
        this.beginUpdate();
        try {
            List<Anchor3D> list = this.controlPoints;
            synchronized (list) {
                for (Anchor3D pt : this.controlPoints) {
                    pt.translate(dx, dy, dz);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void controlPointPositionChanged(Anchor3D source) {
        this.roiChanged(true);
    }

    public void controlPointOverlayChanged(OverlayEvent event) {
        if (event.getType() == OverlayEvent.OverlayEventType.PAINTER_CHANGED) {
            if (this.hasSelectedPoint()) {
                this.setFocused(false);
            }
            this.getOverlay().painterChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChanged(CollapsibleEvent object) {
        ROIEvent event = (ROIEvent)object;
        switch (event.getType()) {
            case ROI_CHANGED: {
                this.updateShape();
                break;
            }
            case FOCUS_CHANGED: {
                ((ROI3DShapePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
            case SELECTION_CHANGED: {
                boolean s = this.isSelected();
                this.beginUpdate();
                try {
                    List<Anchor3D> list = this.controlPoints;
                    synchronized (list) {
                        for (Anchor3D pt : this.controlPoints) {
                            pt.setVisible(s);
                        }
                    }
                    if (!s) {
                        this.unselectAllPoints();
                    }
                }
                finally {
                    this.endUpdate();
                }
                ((ROI3DShapePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
            case PROPERTY_CHANGED: {
                String property = event.getPropertyName();
                if (!StringUtil.equals(property, "stroke") && !StringUtil.equals(property, "color") && !StringUtil.equals(property, "opacity")) break;
                ((ROI3DShapePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
        }
        super.onChanged(object);
    }

    @Override
    public double computeNumberOfPoints() throws InterruptedException {
        return 0.0;
    }

    protected void updateShape() {
        ((ROI3DShapePainter)this.painter).needRebuild = true;
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.firstMove = false;
            this.unselectAllPoints();
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    public class ROI3DShapePainter
    extends ROI3D.ROI3DPainter
    implements Runnable {
        protected vtkPolyData outline;
        protected vtkPolyDataMapper outlineMapper;
        protected vtkActor outlineActor;
        protected vtkInformation vtkInfo;
        protected vtkCellArray vCells;
        protected vtkPoints vPoints;
        protected vtkPolyData polyData;
        protected vtkPolyDataMapper polyMapper;
        protected vtkActor actor;
        protected boolean needRebuild;
        protected double[] scaling;
        protected WeakReference<VtkCanvas> canvas3d;
        protected Set<Anchor3D> actorsToAdd;
        protected Set<Anchor3D> actorsToRemove;

        public ROI3DShapePainter() {
            super(ROI3DShape.this);
            this.outline = null;
            this.outlineMapper = null;
            this.outlineActor = null;
            this.vtkInfo = null;
            this.vCells = null;
            this.vPoints = null;
            this.polyData = null;
            this.polyMapper = null;
            this.actor = null;
            this.scaling = new double[3];
            Arrays.fill(this.scaling, 1.0);
            this.actorsToAdd = new HashSet<Anchor3D>();
            this.actorsToRemove = new HashSet<Anchor3D>();
            this.needRebuild = true;
            this.canvas3d = new WeakReference<Object>(null);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.actor != null) {
                this.actor.Delete();
            }
            if (this.polyMapper != null) {
                this.polyMapper.Delete();
            }
            if (this.polyData != null) {
                this.polyData.Delete();
            }
            if (this.vPoints != null) {
                this.vPoints.Delete();
            }
            if (this.vCells != null) {
                this.vCells.Delete();
            }
            if (this.outlineActor != null) {
                this.outlineActor.SetPropertyKeys(null);
                this.outlineActor.Delete();
            }
            if (this.vtkInfo != null) {
                this.vtkInfo.Remove(VtkCanvas.visibilityKey);
                this.vtkInfo.Delete();
            }
            if (this.outlineMapper != null) {
                this.outlineMapper.Delete();
            }
            if (this.outline != null) {
                this.outline.GetPointData().GetScalars().Delete();
                this.outline.GetPointData().Delete();
                this.outline.Delete();
            }
        }

        protected void initVtkObjects() {
            this.outline = VtkUtil.getOutline(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
            this.outlineMapper = new vtkPolyDataMapper();
            this.outlineMapper.SetInputData(this.outline);
            this.outlineActor = new vtkActor();
            this.outlineActor.SetMapper((vtkMapper)this.outlineMapper);
            this.outlineActor.SetPickable(0);
            this.outlineActor.GetProperty().SetRepresentationToWireframe();
            this.vtkInfo = new vtkInformation();
            this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
            this.outlineActor.SetPropertyKeys(this.vtkInfo);
            this.polyData = new vtkPolyData();
            this.polyMapper = new vtkPolyDataMapper();
            this.polyMapper.SetInputData(this.polyData);
            this.actor = new vtkActor();
            this.actor.SetMapper((vtkMapper)this.polyMapper);
            Color col = this.getColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            this.outlineActor.GetProperty().SetColor(r, g, b);
            vtkProperty property = this.actor.GetProperty();
            property.SetPointSize((float)this.getStroke());
            property.SetColor(r, g, b);
        }

        protected void rebuildVtkObjects() {
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            double xs = this.scaling[0];
            double ys = this.scaling[1];
            double zs = this.scaling[2];
            int numPts = ROI3DShape.this.controlPoints.size();
            double[][] vertices = new double[numPts][3];
            int[] indexes = new int[numPts + 1];
            indexes[0] = numPts;
            if (!ROI3DShape.this.controlPoints.isEmpty()) {
                int i = 0;
                while (i < numPts) {
                    Point3D point = ROI3DShape.this.controlPoints.get(i).getPosition();
                    double[] vertex = vertices[i];
                    vertex[0] = point.getX() * xs;
                    vertex[1] = point.getY() * ys;
                    vertex[2] = point.getZ() * zs;
                    indexes[i + 1] = i;
                    ++i;
                }
            }
            vtkPoints previousPoints = this.vPoints;
            vtkCellArray previousCells = this.vCells;
            this.vPoints = VtkUtil.getPoints(vertices);
            this.vCells = VtkUtil.getCells(1, indexes);
            Rectangle3D bounds = ROI3DShape.this.getBounds3D();
            vtkPanel.lock();
            try {
                VtkUtil.setOutlineBounds(this.outline, bounds.getMinX() * xs, bounds.getMaxX() * xs, bounds.getMinY() * ys, bounds.getMaxY() * ys, bounds.getMinZ() * zs, bounds.getMaxZ() * zs, canvas);
                this.outlineMapper.Update();
                this.polyData.SetPoints(this.vPoints);
                this.polyData.SetLines(this.vCells);
                this.polyMapper.Update();
                if (previousPoints != null) {
                    previousPoints.Delete();
                }
                if (previousCells != null) {
                    previousCells.Delete();
                }
            }
            finally {
                vtkPanel.unlock();
            }
            this.updateVtkDisplayProperties();
        }

        protected void updateVtkDisplayProperties() {
            IcyVtkPanel vtkPanel;
            if (this.actor == null) {
                return;
            }
            VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
            vtkProperty vtkProperty2 = this.actor.GetProperty();
            Color col = this.getDisplayColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            float strk = (float)this.getStroke();
            IcyVtkPanel icyVtkPanel = vtkPanel = cnv != null ? cnv.getVtkPanel() : null;
            if (vtkPanel != null) {
                vtkPanel.lock();
            }
            try {
                this.outlineActor.GetProperty().SetColor(r, g, b);
                if (ROI3DShape.this.isSelected()) {
                    this.outlineActor.GetProperty().SetRepresentationToWireframe();
                    this.outlineActor.SetVisibility(1);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 1);
                } else {
                    this.outlineActor.GetProperty().SetRepresentationToPoints();
                    this.outlineActor.SetVisibility(0);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
                }
                vtkProperty2.SetColor(r, g, b);
                vtkProperty2.SetPointSize(strk);
                vtkProperty2.SetLineWidth(strk);
                this.setVtkObjectsColor(col);
            }
            finally {
                if (vtkPanel != null) {
                    vtkPanel.unlock();
                }
            }
            this.painterChanged();
        }

        protected void setVtkObjectsColor(Color color) {
            if (this.outline != null) {
                VtkUtil.setPolyDataColor(this.outline, color, (VtkCanvas)this.canvas3d.get());
            }
            if (this.polyData != null) {
                VtkUtil.setPolyDataColor(this.polyData, color, (VtkCanvas)this.canvas3d.get());
            }
        }

        @Override
        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (canvas instanceof VtkCanvas) {
                boolean focus = this.actor != null && this.actor == ((VtkCanvas)canvas).getPickedObject();
                ROI3DShape.this.setFocused(focus);
                return focus;
            }
            return super.updateFocus(e, imagePoint, canvas);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            block9: {
                if (ROI3DShape.this.isSelected() && !this.isReadOnly() && ROI3DShape.this.isActiveFor(canvas)) {
                    ROI3DShape.this.beginUpdate();
                    try {
                        controlPoints = ROI3DShape.this.getControlPoints();
                        for (Anchor3D pt : controlPoints) {
                            pt.keyPressed(e, imagePoint, canvas);
                        }
                        if (e.isConsumed()) break block9;
                        sequence = canvas.getSequence();
                        switch (e.getKeyCode()) {
                            case 8: 
                            case 127: {
                                selectedPoint = ROI3DShape.this.getSelectedPoint();
                                if (!ROI3DShape.this.removeSelectedPoint(canvas)) break;
                                e.consume();
                                if (sequence == null) break;
                                sequence.addUndoableEdit(new Point3DRemovedROIEdit((ROI3D)ROI3DShape.this, controlPoints, selectedPoint));
                            }
                            default: {
                                ** break;
                            }
lbl-1000:
                            // 1 sources

                            {
                                break;
                            }
                        }
                    }
                    finally {
                        ROI3DShape.this.endUpdate();
                    }
                }
            }
            super.keyPressed(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI3DShape.this.isSelected() && !this.isReadOnly() && ROI3DShape.this.isActiveFor(canvas) && imagePoint != null) {
                ROI3DShape.this.beginUpdate();
                try {
                    List<Anchor3D> list = ROI3DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                            pt.keyReleased(e, imagePoint, canvas);
                        }
                    }
                }
                finally {
                    ROI3DShape.this.endUpdate();
                }
            }
            super.keyReleased(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI3DShape.this.isActiveFor(canvas) && ROI3DShape.this.isSelected() && !this.isReadOnly()) {
                ROI3DShape.this.beginUpdate();
                try {
                    Anchor3D point;
                    boolean insertMode;
                    List<Anchor3D> list = ROI3DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                            pt.mousePressed(e, imagePoint, canvas);
                        }
                    }
                    if (!e.isConsumed() && imagePoint != null && EventUtil.isLeftMouseButton(e) && !ROI3DShape.this.isFocused() && ((insertMode = EventUtil.isControlDown(e)) || ROI3DShape.this.isCreating()) && (point = ROI3DShape.this.addNewPoint(imagePoint.toPoint3D(), insertMode)) != null) {
                        e.consume();
                        Sequence sequence = canvas.getSequence();
                        if (sequence != null) {
                            sequence.addUndoableEdit(new Point3DAddedROIEdit(ROI3DShape.this, point));
                        }
                    }
                }
                finally {
                    ROI3DShape.this.endUpdate();
                }
            }
            super.mousePressed(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            ROI3DShape.this.firstMove = false;
            if (ROI3DShape.this.isSelected() && !this.isReadOnly() && ROI3DShape.this.isActiveFor(canvas)) {
                Sequence sequence = canvas.getSequence();
                ROI3DShape.this.beginUpdate();
                try {
                    List<Anchor3D> list = ROI3DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                            pt.mouseReleased(e, imagePoint, canvas);
                        }
                    }
                }
                finally {
                    ROI3DShape.this.endUpdate();
                }
                if (sequence != null) {
                    sequence.getUndoManager().noMergeForNextEdit();
                }
            }
            super.mouseReleased(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI3DShape.this.isSelected() && !this.isReadOnly() && ROI3DShape.this.isActiveFor(canvas)) {
                ROI3DShape.this.beginUpdate();
                try {
                    List<Anchor3D> list = ROI3DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                            pt.mouseClick(e, imagePoint, canvas);
                        }
                    }
                }
                finally {
                    ROI3DShape.this.endUpdate();
                }
            }
            super.mouseClick(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI3DShape.this.isActiveFor(canvas) && ROI3DShape.this.isSelected() && !this.isReadOnly()) {
                Sequence sequence = canvas.getSequence();
                ROI3DShape.this.beginUpdate();
                try {
                    List<Anchor3D> list = ROI3DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                            Point3D savedPosition = sequence != null && (!ROI3DShape.this.isCreating() || !ROI3DShape.this.firstMove) ? pt.getPosition() : null;
                            pt.mouseDrag(e, imagePoint, canvas);
                            if (sequence == null || savedPosition == null || savedPosition.equals(pt.getPosition())) continue;
                            sequence.addUndoableEdit(new Point3DMovedROIEdit((ROI3D)ROI3DShape.this, pt, savedPosition));
                        }
                    }
                }
                finally {
                    ROI3DShape.this.endUpdate();
                }
            }
            super.mouseDrag(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI3DShape.this.isActiveFor(canvas) && ROI3DShape.this.isSelected() && !this.isReadOnly()) {
                ROI3DShape.this.beginUpdate();
                try {
                    List<Anchor3D> list = ROI3DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                            pt.mouseMove(e, imagePoint, canvas);
                        }
                    }
                }
                finally {
                    ROI3DShape.this.endUpdate();
                }
            }
            super.mouseMove(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (g == null) {
                    return;
                }
                Rectangle2D bounds = ROI3DShape.this.getBounds3D().toRectangle2D();
                double over = this.getAdjustedStroke(canvas) * 2.0;
                ShapeUtil.enlarge(bounds, over, over, true);
                boolean shapeVisible = this.isVisible(bounds, g, canvas);
                if (shapeVisible) {
                    boolean small = this.isSmall(bounds, g, canvas);
                    this.drawShape(g, sequence, canvas, small);
                    if (!this.isTiny(bounds, g, canvas) && ROI3DShape.this.isSelected() && !this.isReadOnly()) {
                        Iterator<Anchor3D> iterator = ROI3DShape.this.controlPoints;
                        synchronized (iterator) {
                            for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                                pt.paint(g, sequence, canvas, small);
                            }
                        }
                    }
                }
            }
            if (canvas instanceof VtkCanvas) {
                vtkProp prop;
                int n;
                vtkProp[] vtkPropArray;
                double[] s;
                VtkCanvas cnv = (VtkCanvas)canvas;
                if (this.canvas3d.get() != cnv) {
                    this.canvas3d = new WeakReference<VtkCanvas>(cnv);
                }
                if (this.actor == null) {
                    this.initVtkObjects();
                }
                if (!Arrays.equals(this.scaling, s = cnv.getVolumeScale())) {
                    this.scaling = s;
                    this.needRebuild = true;
                }
                if (this.needRebuild) {
                    ThreadUtil.runSingle(this);
                    this.needRebuild = false;
                }
                vtkRenderer renderer = cnv.getRenderer();
                Collection<Anchor3D> collection = this.actorsToRemove;
                synchronized (collection) {
                    for (Anchor3D anchor : this.actorsToRemove) {
                        vtkPropArray = anchor.getProps();
                        n = vtkPropArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            prop = vtkPropArray[n2];
                            VtkUtil.removeProp(renderer, prop);
                            ++n2;
                        }
                    }
                    this.actorsToRemove.clear();
                }
                collection = this.actorsToAdd;
                synchronized (collection) {
                    for (Anchor3D anchor : this.actorsToAdd) {
                        vtkPropArray = anchor.getProps();
                        n = vtkPropArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            prop = vtkPropArray[n3];
                            VtkUtil.addProp(renderer, prop);
                            ++n3;
                        }
                    }
                    this.actorsToAdd.clear();
                }
                collection = ROI3DShape.this.controlPoints;
                synchronized (collection) {
                    for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                        pt.paint(null, sequence, canvas);
                    }
                }
            }
        }

        protected void drawShape(Graphics2D g, Sequence sequence, IcyCanvas canvas, boolean simplified) {
            this.drawShape(g, sequence, canvas, simplified, true);
        }

        protected void drawShape(Graphics2D g, Sequence sequence, IcyCanvas canvas, boolean simplified, boolean connectLastPoint) {
            int i;
            List<Point3D> points = ROI3DShape.this.getPointsInternal();
            Graphics2D g2 = (Graphics2D)g.create();
            if (!simplified && !ROI3DShape.this.isSelected()) {
                g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke + 1.0), 0, 0));
                g2.setColor(Color.black);
                i = 1;
                while (i < points.size()) {
                    ROI3DShape.drawLine3D(g2, sequence, canvas, points.get(i - 1), points.get(i));
                    ++i;
                }
                if (connectLastPoint && points.size() > 2) {
                    ROI3DShape.drawLine3D(g2, sequence, canvas, points.get(points.size() - 1), points.get(0));
                }
            }
            g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, !simplified && ROI3DShape.this.isSelected() ? this.stroke + 1.0 : this.stroke), 0, 0));
            g2.setColor(this.getDisplayColor());
            i = 1;
            while (i < points.size()) {
                ROI3DShape.drawLine3D(g2, sequence, canvas, points.get(i - 1), points.get(i));
                ++i;
            }
            if (connectLastPoint && points.size() > 2) {
                ROI3DShape.drawLine3D(g2, sequence, canvas, points.get(points.size() - 1), points.get(0));
            }
            g2.dispose();
        }

        protected boolean isVisible(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            return GraphicsUtil.isVisible((Graphics)g, bounds);
        }

        protected boolean isSmall(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            if (ROI3DShape.this.isCreating()) {
                return false;
            }
            double scale = Math.max(Math.abs(canvas.getScaleX()), Math.abs(canvas.getScaleY()));
            double size = Math.max(scale * bounds.getWidth(), scale * bounds.getHeight());
            return size < 10.0;
        }

        protected boolean isTiny(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            if (ROI3DShape.this.isCreating()) {
                return false;
            }
            double scale = Math.max(Math.abs(canvas.getScaleX()), Math.abs(canvas.getScaleY()));
            double size = Math.max(scale * bounds.getWidth(), scale * bounds.getHeight());
            return size < 4.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setColor(Color value) {
            this.beginUpdate();
            try {
                super.setColor(value);
                Color focusedColor = this.getFocusedColor();
                List<Anchor3D> list = ROI3DShape.this.controlPoints;
                synchronized (list) {
                    for (Anchor3D anchor : ROI3DShape.this.controlPoints) {
                        anchor.setColor(value);
                        anchor.setSelectedColor(focusedColor);
                    }
                }
            }
            finally {
                this.endUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public vtkProp[] getProps() {
            if (this.actor == null) {
                this.initVtkObjects();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.actor);
            result.add(this.outlineActor);
            List<Anchor3D> list = ROI3DShape.this.controlPoints;
            synchronized (list) {
                for (Anchor3D pt : ROI3DShape.this.controlPoints) {
                    vtkProp[] vtkPropArray = pt.getProps();
                    int n = vtkPropArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        vtkProp prop = vtkPropArray[n2];
                        result.add(prop);
                        ++n2;
                    }
                }
            }
            return result.toArray(new vtkProp[result.size()]);
        }

        @Override
        public void run() {
            this.rebuildVtkObjects();
        }
    }
}

