/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.apposed.appose;

import com.sun.jna.Pointer;
import com.sun.jna.platform.linux.LibRT;
import com.sun.jna.platform.unix.LibCUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;

public class SharedMemory {
    private static final boolean USE_POSIX = System.getProperty("os.name").indexOf("Windows") < 0;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_NONBLOCK = 4;
    public static final int O_APPEND = 8;
    public static final int O_SHLOCK = 16;
    public static final int O_EXLOCK = 32;
    public static final int O_ASYNC = 64;
    public static final int O_SYNC = 128;
    public static final int O_FSYNC = 128;
    public static final int O_NOFOLLOW = 256;
    public static final int O_CREAT = 512;
    public static final int O_TRUNC = 1024;
    public static final int O_EXCL = 2048;
    public static final int O_ACCMODE = 3;
    public static final int O_NDELAY = 4;
    public static final int O_EVTONLY = 32768;
    public static final int O_NOCTTY = 131072;
    public static final int O_DIRECTORY = 0x100000;
    public static final int O_SYMLINK = 0x200000;
    public static final int O_DSYNC = 0x400000;
    public static final int O_CLOEXEC = 0x1000000;
    public static final int O_NOFOLLOW_ANY = 0x20000000;
    private static final int O_CREX = 2560;
    private static final int SHM_SAFE_NAME_LENGTH = 14;
    private static final String SHM_NAME_PREFIX = USE_POSIX ? "/psm_" : "wnsm_";
    private String name;
    private long size;
    private int fd = -1;
    private Pointer mmap;
    private MemoryView buf;
    private int flags = 2;
    private int mode = 384;
    private boolean prepend_leading_slash = USE_POSIX;

    private static String token_hex(long nbytes) {
        StringBuilder sb = new StringBuilder();
        int b = 0;
        while ((long)b < nbytes) {
            String s = Long.toHexString(Double.doubleToLongBits(Math.random()) & 0xFFL);
            assert (s.length() >= 1 && s.length() <= 2);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
            ++b;
        }
        return sb.toString();
    }

    private static long sizeFromFileDescriptor(int fd) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    private Pointer mmap(int i, long size) {
        String tagName = null;
        return this.mmap(i, size, tagName);
    }

    private Pointer mmap(int i, long size, String tagName) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    private void osClose(int fd) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    private void register(String name) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    private static void unregister(String name) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    private static String make_filename() {
        long nbytes = (14 - SHM_NAME_PREFIX.length()) / 2;
        assert (nbytes >= 2L);
        String name = SHM_NAME_PREFIX + SharedMemory.token_hex(nbytes);
        assert (name.length() <= 14);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedMemory(String name, boolean create, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("'size' must be a positive integer");
        }
        if (create) {
            this.flags = 2562;
            if (size == 0L) {
                throw new IllegalArgumentException("'size' must be a positive number different from zero");
            }
        }
        if (name == null && (this.flags & 0x800) != 0) {
            throw new IllegalArgumentException("'name' can only be null if create=true");
        }
        if (USE_POSIX) {
            if (name == null) {
                name = SharedMemory.make_filename();
                this.fd = LibRT.INSTANCE.shm_open(name, this.flags, this.mode);
                this.name = name;
            } else {
                name = this.prepend_leading_slash ? "/" + name : name;
                this.fd = LibRT.INSTANCE.shm_open(name, this.flags, this.mode);
                this.name = name;
            }
            try {
                if (create && size != 0L) {
                    LibCUtil.ftruncate((int)this.fd, (long)size);
                }
                size = SharedMemory.sizeFromFileDescriptor(this.fd);
                this.mmap = this.mmap(this.fd, size);
            }
            finally {
                this.unlink();
            }
            this.register(this.name);
        } else if (create) {
            String temp_name;
            while (true) {
                temp_name = name == null ? SharedMemory.make_filename() : name;
                WinNT.HANDLE h_map = Kernel32.INSTANCE.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, null, 4, (int)(size >> 32 & 0xFFFFFFFFFFFFFFFFL), (int)(size & 0xFFFFFFFFFFFFFFFFL), temp_name);
                try {
                    int last_error_code = Kernel32.INSTANCE.GetLastError();
                    if (last_error_code == 183) {
                        if (name == null) continue;
                        throw new RuntimeException("File already exists: " + name);
                    }
                    this.mmap = this.mmap(-1, size, temp_name);
                }
                finally {
                    Kernel32.INSTANCE.CloseHandle(h_map);
                    continue;
                }
                break;
            }
            this.name = temp_name;
        } else {
            Pointer p_buf;
            this.name = name;
            WinNT.HANDLE h_map = Kernel32.INSTANCE.OpenFileMapping(4, false, name);
            try {
                p_buf = Kernel32.INSTANCE.MapViewOfFile(h_map, 4, 0, 0, 0);
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(h_map);
            }
            try {
                if (this.getClass() == this.getClass()) {
                    throw new UnsupportedOperationException();
                }
            }
            finally {
                Kernel32.INSTANCE.UnmapViewOfFile(p_buf);
            }
            this.mmap = this.mmap(-1, size, name);
        }
        this.size = size;
        this.buf = new MemoryView(this.mmap);
    }

    public MemoryView buf() {
        return this.buf;
    }

    public String name() {
        String reported_name = this.name;
        if (USE_POSIX && this.prepend_leading_slash && this.name.startsWith("/")) {
            reported_name = this.name.substring(1);
        }
        return reported_name;
    }

    public long size() {
        return this.size;
    }

    public void close() {
        if (this.buf != null) {
            this.buf.release();
            this.buf = null;
        }
        if (this.mmap != null) {
            this.mmap = null;
        }
        if (USE_POSIX && this.fd >= 0) {
            this.osClose(this.fd);
            this.fd = -1;
        }
    }

    public void unlink() {
        if (USE_POSIX && this.name != null) {
            LibRT.INSTANCE.shm_unlink(this.name);
            SharedMemory.unregister(this.name);
        }
    }

    public static class MemoryView {
        public MemoryView(Pointer mmap) {
            throw new UnsupportedOperationException("Unimplemented");
        }

        public void release() {
            throw new UnsupportedOperationException("Unimplemented");
        }
    }
}

