/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.versionmanagement;

import com.google.gson.Gson;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.engine.EngineInfo;
import io.bioimage.modelrunner.system.PlatformDetection;
import io.bioimage.modelrunner.versionmanagement.DeepLearningVersion;
import io.bioimage.modelrunner.versionmanagement.SupportedVersions;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class AvailableEngines {
    private static HashMap<String, String> BIOIMAGEIO_TO_MODELRUNNER_KEYS_MAP = new HashMap();
    private static HashMap<String, String> MODELRUNNER_TO_BIOIMAGEIO_KEYS_MAP;
    private List<DeepLearningVersion> versions;

    public static HashMap<String, String> bioimageioToModelRunnerKeysMap() {
        return BIOIMAGEIO_TO_MODELRUNNER_KEYS_MAP;
    }

    public static HashMap<String, String> modelRunnerToBioimageioKeysMap() {
        return MODELRUNNER_TO_BIOIMAGEIO_KEYS_MAP;
    }

    public static List<DeepLearningVersion> getForCurrentOS() {
        String currentPlatform = new PlatformDetection().toString();
        boolean rosetta = PlatformDetection.isUsingRosseta();
        int javaVersion = PlatformDetection.getJavaVersion();
        List<DeepLearningVersion> list = AvailableEngines.getAll().stream().filter(v -> v.getOs().equals(currentPlatform) && javaVersion >= v.getMinJavaVersion() && (!rosetta || rosetta && v.getRosetta())).collect(Collectors.toList());
        list.stream().forEach(x -> x.setEnginesDir());
        return list;
    }

    public static List<DeepLearningVersion> removeRepeatedPythonVersions(List<DeepLearningVersion> versions) {
        ArrayList<DeepLearningVersion> nVersions = new ArrayList<DeepLearningVersion>();
        for (DeepLearningVersion vv : versions) {
            List coinc = nVersions.stream().filter(v -> vv.getFramework().equals(v.getFramework()) && vv.getOs().equals(v.getOs()) && vv.getPythonVersion().equals(v.getPythonVersion()) && vv.getCPU() == v.getCPU() && vv.getGPU() == v.getGPU()).collect(Collectors.toList());
            if (coinc.size() != 0 && ((DeepLearningVersion)coinc.get(0)).isJavaVersionBigger(vv)) continue;
            if (coinc.size() != 0) {
                nVersions.remove(coinc.get(0));
            }
            nVersions.add(vv);
        }
        return nVersions;
    }

    public static List<DeepLearningVersion> filterByFrameworkForOS(String framework) {
        String searchEngine = AvailableEngines.getSupportedFrameworkTag(framework);
        if (searchEngine == null) {
            return new ArrayList<DeepLearningVersion>();
        }
        String currentPlatform = new PlatformDetection().toString();
        int javaVersion = PlatformDetection.getJavaVersion();
        boolean rosetta = PlatformDetection.isUsingRosseta();
        List<DeepLearningVersion> filtered = AvailableEngines.getAll().stream().filter(v -> v.getOs().equals(currentPlatform) && javaVersion >= v.getMinJavaVersion() && (!rosetta || rosetta && v.getRosetta()) && searchEngine.equals(v.getFramework())).collect(Collectors.toList());
        return filtered;
    }

    public static List<String> getFrameworkPythonVersionsForOs(String framework) {
        String searchEngine = AvailableEngines.getSupportedFrameworkTag(framework);
        if (searchEngine == null) {
            return new ArrayList<String>();
        }
        String currentPlatform = new PlatformDetection().toString();
        boolean rosetta = PlatformDetection.isUsingRosseta();
        int javaVersion = PlatformDetection.getJavaVersion();
        List<String> availablePythonVersions = AvailableEngines.getAll().stream().filter(v -> v.getOs().equals(currentPlatform) && javaVersion >= v.getMinJavaVersion() && (!rosetta || rosetta && v.getRosetta()) && searchEngine.equals(v.getFramework())).map(DeepLearningVersion::getPythonVersion).collect(Collectors.toList());
        return availablePythonVersions;
    }

    public static List<DeepLearningVersion> getAll() {
        BufferedReader br = new BufferedReader(new InputStreamReader(AvailableEngines.class.getClassLoader().getResourceAsStream("availableDLVersions.json")));
        Gson g = new Gson();
        AvailableEngines availableVersions = (AvailableEngines)g.fromJson((Reader)br, AvailableEngines.class);
        return availableVersions.getVersions();
    }

    public List<DeepLearningVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<DeepLearningVersion> versions) {
        this.versions = versions;
    }

    public static boolean isEngineSupportedInOS(String framework, String version, Boolean cpu, Boolean gpu) {
        String searchEngine = AvailableEngines.getSupportedFrameworkTag(framework);
        if (searchEngine == null && framework != null) {
            return false;
        }
        String javaVersion = version != null ? SupportedVersions.getJavaVersionForPythonVersion(searchEngine, version) : null;
        DeepLearningVersion engine = AvailableEngines.filterByFrameworkForOS(searchEngine).stream().filter(v -> {
            if (searchEngine != null && !v.getFramework().equals(searchEngine)) {
                return false;
            }
            if (javaVersion != null && !v.getVersion().equals(javaVersion)) {
                return false;
            }
            if (!v.getOs().equals(new PlatformDetection().toString())) {
                return false;
            }
            if (PlatformDetection.getJavaVersion() < v.getMinJavaVersion()) {
                return false;
            }
            if (PlatformDetection.isUsingRosseta() && !v.getRosetta()) {
                return false;
            }
            if (cpu != null && v.getCPU() != cpu.booleanValue()) {
                return false;
            }
            return gpu == null || v.getGPU() == gpu.booleanValue();
        }).findFirst().orElse(null);
        return engine != null;
    }

    public static List<DeepLearningVersion> getEnginesForOsByParams(String framework, String version, Boolean cpu, Boolean gpu) {
        String searchEngine = AvailableEngines.getSupportedFrameworkTag(framework);
        if (searchEngine == null) {
            return new ArrayList<DeepLearningVersion>();
        }
        String javaVersion = version != null ? SupportedVersions.getJavaVersionForPythonVersion(searchEngine, version) : null;
        List<DeepLearningVersion> engine = AvailableEngines.filterByFrameworkForOS(searchEngine).stream().filter(v -> {
            if (searchEngine != null && !v.getFramework().equals(searchEngine)) {
                return false;
            }
            if (javaVersion != null && !v.getVersion().equals(javaVersion)) {
                return false;
            }
            if (!v.getOs().equals(new PlatformDetection().toString())) {
                return false;
            }
            if (PlatformDetection.getJavaVersion() < v.getMinJavaVersion()) {
                return false;
            }
            if (PlatformDetection.isUsingRosseta() && !v.getRosetta()) {
                return false;
            }
            if (cpu != null && v.getCPU() != cpu.booleanValue()) {
                return false;
            }
            return gpu == null || v.getGPU() == gpu.booleanValue();
        }).collect(Collectors.toList());
        return engine;
    }

    public static String getSupportedFrameworkTag(String framework) {
        if (framework == null) {
            return null;
        }
        boolean engineExists = AvailableEngines.bioimageioToModelRunnerKeysMap().keySet().stream().anyMatch(i -> i.equals(framework));
        boolean engineExists2 = AvailableEngines.bioimageioToModelRunnerKeysMap().entrySet().stream().anyMatch(i -> ((String)i.getValue()).equals(framework));
        if (!engineExists && !engineExists2) {
            return null;
        }
        String searchEngine = !engineExists2 ? AvailableEngines.bioimageioToModelRunnerKeysMap().get(framework).toLowerCase() : framework;
        return searchEngine;
    }

    static {
        BIOIMAGEIO_TO_MODELRUNNER_KEYS_MAP.put(EngineInfo.getBioimageioPytorchKey(), EngineInfo.getPytorchKey());
        BIOIMAGEIO_TO_MODELRUNNER_KEYS_MAP.put(EngineInfo.getBioimageioTfKey(), EngineInfo.getTensorflowKey());
        BIOIMAGEIO_TO_MODELRUNNER_KEYS_MAP.put(EngineInfo.getBioimageioOnnxKey(), EngineInfo.getOnnxKey());
        BIOIMAGEIO_TO_MODELRUNNER_KEYS_MAP.put(EngineInfo.getBioimageioKerasKey(), EngineInfo.getKerasKey());
        BIOIMAGEIO_TO_MODELRUNNER_KEYS_MAP.put(ModelWeight.getBioengineID(), ModelWeight.getBioengineID());
        MODELRUNNER_TO_BIOIMAGEIO_KEYS_MAP = new HashMap();
        MODELRUNNER_TO_BIOIMAGEIO_KEYS_MAP.put(EngineInfo.getPytorchKey(), EngineInfo.getBioimageioPytorchKey());
        MODELRUNNER_TO_BIOIMAGEIO_KEYS_MAP.put(EngineInfo.getTensorflowKey(), EngineInfo.getBioimageioTfKey());
        MODELRUNNER_TO_BIOIMAGEIO_KEYS_MAP.put(EngineInfo.getOnnxKey(), EngineInfo.getBioimageioOnnxKey());
        MODELRUNNER_TO_BIOIMAGEIO_KEYS_MAP.put(EngineInfo.getKerasKey(), EngineInfo.getBioimageioKerasKey());
        MODELRUNNER_TO_BIOIMAGEIO_KEYS_MAP.put(ModelWeight.getBioengineID(), ModelWeight.getBioengineID());
    }
}

