/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.searchprovider;

import icy.gui.plugin.PluginDetailPanel;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.search.SearchResult;
import icy.search.SearchResultConsumer;
import icy.search.SearchResultProducer;
import java.util.ArrayList;
import java.util.List;
import plugins.kernel.searchprovider.PluginSearchResult;

public class LocalPluginSearchResultProducer
extends SearchResultProducer {
    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    public String getName() {
        return "Installed plugins";
    }

    @Override
    public String getTooltipText() {
        return "Result(s) from installed plugins";
    }

    @Override
    public void doSearch(String text, SearchResultConsumer consumer) {
        List<SearchResultProducer.SearchWord> words = LocalPluginSearchResultProducer.getSearchWords(text);
        if (words.isEmpty()) {
            return;
        }
        ArrayList<LocalPluginResult> tmpResults = new ArrayList<LocalPluginResult>();
        boolean startWithOnly = LocalPluginSearchResultProducer.getShortSearch(words);
        for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins()) {
            if (this.hasWaitingSearch()) {
                return;
            }
            int prio = LocalPluginSearchResultProducer.searchInPlugin(pluginDescriptor, words, startWithOnly);
            if (prio <= 0) continue;
            tmpResults.add(new LocalPluginResult(this, pluginDescriptor, pluginDescriptor.getDescription(), words, prio));
        }
        this.results = new ArrayList(tmpResults);
        consumer.resultsChanged(this);
        for (SearchResult searchResult : tmpResults) {
            if (this.hasWaitingSearch()) {
                return;
            }
            ((LocalPluginResult)searchResult).getPlugin().loadDescriptor();
            consumer.resultChanged(this, searchResult);
        }
        for (SearchResult searchResult : tmpResults) {
            if (this.hasWaitingSearch()) {
                return;
            }
            ((LocalPluginResult)searchResult).getPlugin().loadImages();
            consumer.resultChanged(this, searchResult);
        }
    }

    public static int searchInPlugin(PluginDescriptor plugin, List<SearchResultProducer.SearchWord> words, boolean startWithOnly) {
        int result = 0;
        for (SearchResultProducer.SearchWord sw : words) {
            int r = LocalPluginSearchResultProducer.searchInPlugin(plugin, sw.word, startWithOnly);
            if (r == 0 && sw.mandatory) {
                return 0;
            }
            if (r > 0 && sw.reject) {
                return 0;
            }
            result += r;
        }
        return result;
    }

    public static int searchInPlugin(PluginDescriptor plugin, String word, boolean startWithOnly) {
        String description;
        if (plugin.getPluginClass() != null) {
            if (plugin.isAbstract() || plugin.isInterface()) {
                return 0;
            }
            if (plugin.isBundled() && !plugin.isActionable()) {
                return 0;
            }
        }
        String wordlc = word.toLowerCase();
        String name = plugin.getName().toLowerCase();
        int ind = name.indexOf(wordlc);
        if (ind >= 0) {
            if (ind == 0) {
                return 10;
            }
            if (name.charAt(ind - 1) == ' ') {
                return 9;
            }
            if (startWithOnly) {
                return 0;
            }
            return 8;
        }
        if (!startWithOnly && (ind = (description = plugin.getDescription().toLowerCase()).indexOf(wordlc)) >= 0) {
            if (ind == 0) {
                return 5;
            }
            if (description.charAt(ind - 1) == ' ') {
                return 4;
            }
            return 1;
        }
        return 0;
    }

    public static class LocalPluginResult
    extends PluginSearchResult {
        public LocalPluginResult(SearchResultProducer provider, PluginDescriptor plugin, String text, List<SearchResultProducer.SearchWord> words, int priority) {
            super(provider, plugin, text, words, priority);
        }

        @Override
        public String getTooltip() {
            if (this.plugin.isActionable()) {
                return "Left click: Run   -   Right click: Online documentation";
            }
            return "Left click: Show detail   -   Right click: Online documentation";
        }

        @Override
        public void execute() {
            if (this.plugin.isActionable()) {
                PluginLauncher.start(this.plugin);
            } else {
                new PluginDetailPanel(this.plugin);
            }
        }
    }
}

