/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.livebar;

import icy.file.FileUtil;
import icy.file.xml.XMLPersistent;
import icy.network.NetworkUtil;
import icy.plugin.PluginLoader;
import icy.util.XMLUtil;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import plugins.adufour.protocols.Protocols;

public class ProtocolDescriptor
implements XMLPersistent {
    private String filePath;
    private String fileDownloadURL;
    private String url;
    private String name;
    private String description;
    private String author;

    public ProtocolDescriptor(Node node) {
        this.loadFromXML(node);
    }

    public String getName() {
        return this.name;
    }

    public ImageIcon getIcon() {
        return PluginLoader.getPlugin(Protocols.class.getName()).getIcon();
    }

    public String getWeb() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public Image getImage() {
        return null;
    }

    public File getFile() {
        try {
            FileOutputStream stream = new FileOutputStream(this.filePath);
            stream.write(NetworkUtil.download(this.fileDownloadURL, null, false));
            stream.flush();
            stream.close();
            return new File(this.filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.name = XMLUtil.getValue(XMLUtil.getElement(node, "name"), "No name");
        this.author = XMLUtil.getValue(XMLUtil.getElement(node, "author"), "No author");
        this.url = XMLUtil.getValue(XMLUtil.getElement(node, "url"), "http://icy.bioimageanalysis.org");
        this.description = XMLUtil.getValue(XMLUtil.getElement(node, "shortDescription"), "No description");
        FileUtil.createDir(Protocols.downloadedProtocolFolder);
        this.filePath = Protocols.downloadedProtocolFolder + File.separator + this.name + " v" + XMLUtil.getValue(XMLUtil.getElement(node, "version"), "0") + ".xml";
        this.fileDownloadURL = XMLUtil.getValue(XMLUtil.getElement(node, "fileurl"), "");
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        return false;
    }
}

