/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description.deepimagej;

import io.bioimage.modelrunner.bioimageio.description.deepimagej.DeepImageJProcessing;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeepImageJExecutionConfig {
    private static String preKey = "preprocess";
    private static String postKey = "postprocess";
    private static String predictionKey = "prediction";
    private static String pyramidKey = "pyramidal_model";
    private static String tilingKey = "allow_tiling";
    private static String testInfoKey = "test_information";
    private boolean pyramidalModel = false;
    private boolean allowTiling = true;
    private String tensorFlowModelTag;
    private String tensorFlowSignatureDef;
    private DeepImageJProcessing pre;
    private DeepImageJProcessing post;

    public static DeepImageJExecutionConfig build(Map<String, Object> yamlMap) {
        DeepImageJExecutionConfig config = new DeepImageJExecutionConfig();
        config.pyramidalModel = yamlMap.containsKey(pyramidKey) ? (Boolean)yamlMap.get(pyramidKey) : false;
        config.allowTiling = yamlMap.containsKey(tilingKey) ? (Boolean)yamlMap.get(tilingKey) : false;
        Map testInformationMap = yamlMap.containsKey(testInfoKey) ? (Map)yamlMap.get(testInfoKey) : Collections.EMPTY_MAP;
        Map predictionMap = (Map)yamlMap.get(predictionKey);
        config.createProcessings(predictionMap);
        return config;
    }

    private void createProcessings(Object predictionMap) {
        if (predictionMap == null || !(predictionMap instanceof HashMap) || !(predictionMap instanceof Map)) {
            this.pre = DeepImageJProcessing.build(null);
            this.post = DeepImageJProcessing.build(null);
            return;
        }
        if (predictionMap instanceof HashMap) {
            this.pre = DeepImageJProcessing.build(((HashMap)predictionMap).get(preKey));
            this.post = DeepImageJProcessing.build(((HashMap)predictionMap).get(postKey));
        } else if (predictionMap instanceof Map) {
            this.pre = DeepImageJProcessing.build(((Map)predictionMap).get(preKey));
            this.post = DeepImageJProcessing.build(((Map)predictionMap).get(postKey));
        }
    }

    private DeepImageJExecutionConfig() {
    }

    public boolean isPyramidalModel() {
        return this.pyramidalModel;
    }

    public boolean isAllowTiling() {
        return this.allowTiling;
    }

    public String getTensorFlowModelTag() {
        return this.tensorFlowModelTag;
    }

    public String getTensorFlowSignatureDef() {
        return this.tensorFlowSignatureDef;
    }

    public DeepImageJProcessing getPreprocesing() {
        return this.pre;
    }

    public DeepImageJProcessing getPostprocesing() {
        return this.post;
    }
}

