/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.adapter;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.bioimageio.description.exceptions.ModelSpecsException;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.model.BaseModel;
import io.bioimage.modelrunner.model.java.BioimageIoModelJava;
import io.bioimage.modelrunner.model.python.BioimageIoModelPytorch;
import io.bioimage.modelrunner.model.special.stardist.Stardist2D;
import io.bioimage.modelrunner.model.special.stardist.StardistAbstract;
import io.bioimage.modelrunner.tensor.Tensor;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public abstract class RunnerAdapter
implements Closeable {
    protected final ModelDescriptor descriptor;
    protected final BaseModel model;
    protected boolean closed = false;
    protected boolean loaded = false;

    protected abstract <T extends RealType<T> & NativeType<T>> LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>> displayTestInputs(LinkedHashMap<TensorSpec, String> var1);

    protected abstract LinkedHashMap<TensorSpec, String> getTestInputs();

    protected RunnerAdapter(ModelDescriptor descriptor) throws IOException, LoadEngineException {
        this.descriptor = descriptor;
        List<String> wList = descriptor.getWeights().getAllSuportedWeightNames();
        if (descriptor.getModelFamily().equals("stardist")) {
            this.model = StardistAbstract.fromBioimageioModel(descriptor);
        } else if (descriptor.getModelFamily().equals("bioimage.io") && (wList.size() != 1 || !wList.contains(ModelWeight.getPytorchID()))) {
            this.model = BioimageIoModelJava.createBioimageioModel(descriptor.getModelPath());
        } else if (descriptor.getModelFamily().equals("bioimage.io")) {
            this.model = BioimageIoModelPytorch.create(descriptor);
        } else {
            throw new IllegalArgumentException("Model not supported");
        }
    }

    protected RunnerAdapter(ModelDescriptor descriptor, ClassLoader classloader) throws IOException, LoadEngineException {
        this.descriptor = descriptor;
        List<String> wList = descriptor.getWeights().getAllSuportedWeightNames();
        if (descriptor.getModelFamily().equals("stardist")) {
            this.model = StardistAbstract.fromBioimageioModel(descriptor);
        } else if (descriptor.getModelFamily().equals("bioimage.io") && (wList.size() != 1 || !wList.contains(ModelWeight.getPytorchID()))) {
            this.model = BioimageIoModelJava.createBioimageioModel(descriptor.getModelPath(), classloader);
        } else if (descriptor.getModelFamily().equals("bioimage.io")) {
            this.model = BioimageIoModelPytorch.create(descriptor);
        } else {
            throw new IllegalArgumentException("Model not supported");
        }
    }

    protected RunnerAdapter(ModelDescriptor descriptor, String enginesPath) throws IOException, LoadEngineException {
        this.descriptor = descriptor;
        List<String> wList = descriptor.getWeights().getAllSuportedWeightNames();
        if (descriptor.getModelFamily().equals("stardist")) {
            this.model = Stardist2D.fromBioimageioModel(descriptor);
        } else if (descriptor.getModelFamily().equals("bioimage.io") && (wList.size() != 1 || !wList.contains(ModelWeight.getPytorchID()))) {
            this.model = BioimageIoModelJava.createBioimageioModel(descriptor.getModelPath(), enginesPath);
        } else if (descriptor.getModelFamily().equals("bioimage.io")) {
            this.model = BioimageIoModelPytorch.create(descriptor);
        } else {
            throw new IllegalArgumentException("Model not supported");
        }
    }

    protected RunnerAdapter(ModelDescriptor descriptor, String enginesPath, ClassLoader classloader) throws IOException, LoadEngineException {
        this.descriptor = descriptor;
        List<String> wList = descriptor.getWeights().getAllSuportedWeightNames();
        if (descriptor.getModelFamily().equals("stardist")) {
            this.model = Stardist2D.fromBioimageioModel(descriptor);
        } else if (descriptor.getModelFamily().equals("bioimage.io") && (wList.size() != 1 || !wList.contains(ModelWeight.getPytorchID()))) {
            this.model = BioimageIoModelJava.createBioimageioModel(descriptor.getModelPath(), enginesPath, classloader);
        } else if (descriptor.getModelFamily().equals("bioimage.io")) {
            this.model = BioimageIoModelPytorch.create(descriptor);
        } else {
            throw new IllegalArgumentException("Model not supported");
        }
    }

    public ModelDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void load() throws LoadModelException {
        if (this.closed) {
            throw new RuntimeException("The model has already been closed");
        }
        this.model.loadModel();
        this.loaded = true;
    }

    public <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<R>> run(List<Tensor<T>> inputTensors) throws FileNotFoundException, RunModelException, IOException {
        if (this.closed) {
            throw new RuntimeException("The model has already been closed");
        }
        if (!this.model.isLoaded()) {
            throw new RuntimeException("Please first load the model");
        }
        return this.model.run(inputTensors);
    }

    public <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<R>> runOnTestImages() throws FileNotFoundException, ModelSpecsException, RunModelException, IOException {
        LinkedHashMap<TensorSpec, String> testInputs = this.getTestInputs();
        LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>> inputRais = this.displayTestInputs(testInputs);
        List inputTensors = this.createTestTensorList(inputRais);
        return this.model.run(inputTensors);
    }

    private <T extends RealType<T> & NativeType<T>> List<Tensor<T>> createTestTensorList(LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>> inputRais) {
        return inputRais.entrySet().stream().map(ee -> Tensor.build(((TensorSpec)ee.getKey()).getName(), ((TensorSpec)ee.getKey()).getAxesOrder(), (RandomAccessibleInterval)ee.getValue())).collect(Collectors.toList());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isLoaded() {
        if (this.isClosed()) {
            return false;
        }
        return this.loaded;
    }

    @Override
    public void close() throws IOException {
        this.model.close();
        this.closed = true;
        this.loaded = false;
    }
}

