/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.tensor.shm;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import io.bioimage.modelrunner.numpy.DecodeNumpy;
import io.bioimage.modelrunner.tensor.Utils;
import io.bioimage.modelrunner.tensor.shm.CLibrary;
import io.bioimage.modelrunner.tensor.shm.LibRt;
import io.bioimage.modelrunner.tensor.shm.SharedMemoryArray;
import io.bioimage.modelrunner.utils.CommonUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import java.util.regex.Matcher;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.nio.ByteBufferAccess;
import net.imglib2.img.basictypeaccess.nio.DoubleBufferAccess;
import net.imglib2.img.basictypeaccess.nio.FloatBufferAccess;
import net.imglib2.img.basictypeaccess.nio.IntBufferAccess;
import net.imglib2.img.basictypeaccess.nio.LongBufferAccess;
import net.imglib2.img.basictypeaccess.nio.ShortBufferAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class SharedMemoryArrayLinux
implements SharedMemoryArray {
    private static final LibRt INSTANCE_RT = LibRt.INSTANCE;
    private static final CLibrary INSTANCE_C = CLibrary.INSTANCE;
    private boolean useLibRT = true;
    private int shmFd;
    private Pointer pSharedMemory;
    private final String memoryName;
    private int size;
    private String originalDataType;
    private long[] originalDims;
    private boolean unlinked = false;
    private Boolean isNumpyFormat = null;
    private boolean isFortran = false;

    protected SharedMemoryArrayLinux(int size, String dtype, long[] shape, Boolean isNumpy, boolean isFortran) throws FileAlreadyExistsException {
        this(SharedMemoryArray.createShmName(), size, dtype, shape, isNumpy, isFortran);
    }

    private SharedMemoryArrayLinux(String name, int size, String dtype, long[] shape, Boolean isNumpy, boolean isFortran) throws FileAlreadyExistsException {
        this.originalDataType = dtype;
        this.originalDims = shape;
        this.size = size;
        this.memoryName = name;
        this.isNumpyFormat = isNumpy;
        this.isFortran = isFortran;
        try {
            this.shmFd = INSTANCE_RT.shm_open(this.memoryName, 2, 448);
        }
        catch (Exception ex) {
            this.useLibRT = false;
            this.shmFd = INSTANCE_C.shm_open(this.memoryName, 2, 448);
        }
        long prevSize = 0L;
        boolean alreadyExists = false;
        if (this.shmFd != -1) {
            alreadyExists = true;
            prevSize = SharedMemoryArrayLinux.getSHMSize(this.shmFd, this.useLibRT);
        }
        if (alreadyExists && prevSize != (long)size) {
            throw new FileAlreadyExistsException("Shared memory segment already exists with different dimensions, data type or format. Size of existing shared memory segment: " + prevSize + ", size of proposed object: " + size);
        }
        if (!alreadyExists) {
            try {
                this.shmFd = INSTANCE_RT.shm_open(this.memoryName, 66, 448);
            }
            catch (Exception ex) {
                this.shmFd = INSTANCE_C.shm_open(this.memoryName, 66, 448);
            }
            if (this.shmFd < 0) {
                throw new RuntimeException("shm_open failed, errno: " + Native.getLastError());
            }
        }
        if (!alreadyExists) {
            if (this.useLibRT && INSTANCE_RT.ftruncate(this.shmFd, this.size) == -1) {
                INSTANCE_RT.close(this.shmFd);
                throw new RuntimeException("ftruncate failed, errno: " + Native.getLastError());
            }
            if (!this.useLibRT && INSTANCE_C.ftruncate(this.shmFd, this.size) == -1) {
                INSTANCE_C.close(this.shmFd);
                throw new RuntimeException("ftruncate failed, errno: " + Native.getLastError());
            }
        }
        this.pSharedMemory = this.useLibRT ? INSTANCE_RT.mmap(Pointer.NULL, this.size, 3, 1, this.shmFd, 0) : INSTANCE_C.mmap(Pointer.NULL, this.size, 3, 1, this.shmFd, 0);
        if (this.useLibRT && this.pSharedMemory == Pointer.NULL) {
            INSTANCE_RT.close(this.shmFd);
            throw new RuntimeException("mmap failed, errno: " + Native.getLastError());
        }
        if (!this.useLibRT && this.pSharedMemory == Pointer.NULL) {
            INSTANCE_C.close(this.shmFd);
            throw new RuntimeException("mmap failed, errno: " + Native.getLastError());
        }
        if (!alreadyExists && this.isNumpyFormat.booleanValue()) {
            byte[] header = SharedMemoryArrayLinux.getNpyHeader(dtype, shape, this.isFortran);
            long offset = 0L;
            for (byte b : header) {
                this.pSharedMemory.setByte(offset++, b);
            }
        }
    }

    protected static long getSHMSize(String memoryName) {
        int shmFd;
        if (!memoryName.startsWith("/")) {
            memoryName = "/" + memoryName;
        }
        boolean useLibRT = true;
        try {
            shmFd = INSTANCE_RT.shm_open(memoryName, 2, 448);
        }
        catch (Exception ex) {
            shmFd = INSTANCE_C.shm_open(memoryName, 2, 448);
            useLibRT = false;
        }
        if (shmFd < 0) {
            throw new RuntimeException("Failed to open shared memory, it might not exist. Errno: " + Native.getLastError());
        }
        return SharedMemoryArrayLinux.getSHMSize(shmFd, useLibRT);
    }

    protected static long getSHMSize(int shmFd, boolean useLibRT) {
        if (shmFd < 0) {
            throw new RuntimeException("Invalid shmFd. It should be bigger than 0.");
        }
        long size = useLibRT ? INSTANCE_RT.lseek(shmFd, 0L, 2) : INSTANCE_C.lseek(shmFd, 0L, 2);
        if (size == -1L && useLibRT) {
            throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Native.getLastError());
        }
        if (size == -1L && !useLibRT) {
            throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Native.getLastError());
        }
        return size;
    }

    private SharedMemoryArrayLinux(String name) {
        this.memoryName = name;
    }

    protected static <T extends RealType<T> & NativeType<T>> SharedMemoryArrayLinux readOrCreate(String name, int size, long[] shape, String strDType, Boolean isNumpy, boolean isFortran) throws FileAlreadyExistsException {
        return new SharedMemoryArrayLinux(name, size, strDType, shape, isNumpy, isFortran);
    }

    protected static <T extends RealType<T> & NativeType<T>> SharedMemoryArrayLinux readOrCreate(String name, int size) throws FileAlreadyExistsException {
        return new SharedMemoryArrayLinux(name, size, null, null, null, false);
    }

    protected static <T extends RealType<T> & NativeType<T>> SharedMemoryArrayLinux create(int size, long[] shape, String strDType, Boolean isNumpy, boolean isFortran) {
        try {
            return new SharedMemoryArrayLinux(size, strDType, shape, isNumpy, isFortran);
        }
        catch (FileAlreadyExistsException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
    }

    protected static SharedMemoryArrayLinux create(int size) {
        try {
            return new SharedMemoryArrayLinux(size, null, null, null, false);
        }
        catch (FileAlreadyExistsException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
    }

    protected static <T extends RealType<T> & NativeType<T>> SharedMemoryArrayLinux createSHMAFromRAI(String name, RandomAccessibleInterval<T> rai, boolean isFortranOrder, boolean isNumpy) throws FileAlreadyExistsException {
        SharedMemoryArray.checkMemorySegmentName(name);
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        SharedMemoryArrayLinux shma = null;
        if (Util.getTypeFromInterval(rai) instanceof ByteType) {
            int size = 1;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildInt8((RandomAccessibleInterval<ByteType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedByteType) {
            int size = 1;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildUint8((RandomAccessibleInterval<UnsignedByteType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof ShortType) {
            int size = 2;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildInt16((RandomAccessibleInterval<ShortType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedShortType) {
            int size = 2;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildUint16((RandomAccessibleInterval<UnsignedShortType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof IntType) {
            int size = 4;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildInt32((RandomAccessibleInterval<IntType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedIntType) {
            int size = 4;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildUint32((RandomAccessibleInterval<UnsignedIntType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof LongType) {
            int size = 8;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildInt64((RandomAccessibleInterval<LongType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof FloatType) {
            int size = 4;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildFloat32((RandomAccessibleInterval<FloatType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof DoubleType) {
            int size = 8;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayLinux(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildFloat64((RandomAccessibleInterval<DoubleType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else {
            throw new IllegalArgumentException("The image has an unsupported type: " + ((RealType)Util.getTypeFromInterval(rai)).getClass().toString());
        }
        return shma;
    }

    protected static SharedMemoryArrayLinux read(String memoryName) {
        int shmFd;
        if (!memoryName.startsWith("/")) {
            memoryName = "/" + memoryName;
        }
        boolean useLibRT = true;
        try {
            shmFd = INSTANCE_RT.shm_open(memoryName, 2, 448);
        }
        catch (Exception ex) {
            shmFd = INSTANCE_C.shm_open(memoryName, 2, 448);
            useLibRT = false;
        }
        if (shmFd < 0) {
            throw new RuntimeException("Shared memory segmentmight not exist: " + memoryName + ". Failed to open shared memory. Errno: " + Native.getLastError());
        }
        long size = useLibRT ? INSTANCE_RT.lseek(shmFd, 0L, 2) : INSTANCE_C.lseek(shmFd, 0L, 2);
        if (size == -1L && useLibRT) {
            INSTANCE_RT.close(shmFd);
            throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Native.getLastError());
        }
        if (size == -1L && !useLibRT) {
            INSTANCE_C.close(shmFd);
            throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Native.getLastError());
        }
        Pointer pSharedMemory = useLibRT ? INSTANCE_RT.mmap(null, (int)size, 1, 1, shmFd, 0) : INSTANCE_C.mmap(null, (int)size, 1, 1, shmFd, 0);
        if (pSharedMemory == Pointer.NULL && useLibRT) {
            INSTANCE_RT.close(shmFd);
            throw new RuntimeException("Failed to map shared memory. Errmo: " + Native.getLastError());
        }
        if (pSharedMemory == Pointer.NULL && !useLibRT) {
            INSTANCE_C.close(shmFd);
            throw new RuntimeException("Failed to map shared memory. Errmo: " + Native.getLastError());
        }
        SharedMemoryArrayLinux shm = new SharedMemoryArrayLinux(memoryName);
        shm.shmFd = shmFd;
        shm.pSharedMemory = pSharedMemory;
        shm.size = (int)size;
        shm.useLibRT = useLibRT;
        shm.findNumpyFormat();
        return shm;
    }

    private void addByteArray(byte[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            this.pSharedMemory.setByte((long)i, arr[i]);
        }
    }

    private void buildInt8(RandomAccessibleInterval<ByteType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, this.isFortran);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setByte(offset + i++, ((ByteType)cursor.get()).get());
        }
    }

    private void buildUint8(RandomAccessibleInterval<UnsignedByteType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setByte(offset + i++, ((UnsignedByteType)cursor.get()).getByte());
        }
    }

    private void buildInt16(RandomAccessibleInterval<ShortType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, this.isFortran);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setShort(offset + i * 2L, ((ShortType)cursor.get()).get());
            ++i;
        }
    }

    private void buildUint16(RandomAccessibleInterval<UnsignedShortType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, this.isFortran);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setShort(offset + i * 2L, ((UnsignedShortType)cursor.get()).getShort());
            ++i;
        }
    }

    private void buildInt32(RandomAccessibleInterval<IntType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, this.isFortran);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setInt(offset + i * 4L, ((IntType)cursor.get()).get());
            ++i;
        }
    }

    private void buildUint32(RandomAccessibleInterval<UnsignedIntType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, this.isFortran);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setInt(offset + i * 4L, ((UnsignedIntType)cursor.get()).getInt());
            ++i;
        }
    }

    private void buildInt64(RandomAccessibleInterval<LongType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, this.isFortran);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setLong(offset + i * 8L, ((LongType)cursor.get()).get());
            ++i;
        }
    }

    private void buildFloat32(RandomAccessibleInterval<FloatType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, this.isFortran);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setFloat(offset + i * 4L, ((FloatType)cursor.get()).get());
            ++i;
        }
    }

    private void buildFloat64(RandomAccessibleInterval<DoubleType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayLinux.getNpyHeader(tensor, this.isFortran);
        }
        long offset = 0L;
        for (byte b : header) {
            this.pSharedMemory.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.pSharedMemory.setDouble(offset + i * 8L, ((DoubleType)cursor.get()).get());
            ++i;
        }
    }

    private static <T extends RealType<T> & NativeType<T>> byte[] getNpyHeader(RandomAccessibleInterval<T> tensor, boolean fortranOrder) {
        int i;
        String strHeader = "{'descr': '<";
        strHeader = strHeader + DecodeNumpy.getDataType((RealType)tensor.getAt(tensor.minAsLongArray()));
        strHeader = strHeader + "', 'fortran_order': " + (fortranOrder ? "True" : "False") + ", 'shape': (";
        for (long ll : tensor.dimensionsAsLongArray()) {
            strHeader = strHeader + ll + ", ";
        }
        strHeader = strHeader.substring(0, strHeader.length() - 2);
        strHeader = strHeader + "), }" + System.lineSeparator();
        byte[] bufInverse = strHeader.getBytes(StandardCharsets.UTF_8);
        byte[] major = new byte[]{1};
        byte[] minor = new byte[]{0};
        byte[] len = new byte[]{(byte)strHeader.length(), (byte)((short)strHeader.length() >> 8)};
        int totalLen = DecodeNumpy.NUMPY_PREFIX.length + 2 + 2 + bufInverse.length;
        byte[] total = new byte[totalLen];
        int c = 0;
        for (i = 0; i < DecodeNumpy.NUMPY_PREFIX.length; ++i) {
            total[c++] = DecodeNumpy.NUMPY_PREFIX[i];
        }
        total[c++] = major[0];
        total[c++] = minor[0];
        total[c++] = len[0];
        total[c++] = len[1];
        for (i = 0; i < bufInverse.length; ++i) {
            total[c++] = bufInverse[i];
        }
        return total;
    }

    private static <T extends RealType<T> & NativeType<T>> byte[] getNpyHeader(String dtype, long[] shape, boolean fortranOrder) {
        int i;
        String strHeader = "{'descr': '<";
        strHeader = strHeader + DecodeNumpy.getDataType(CommonUtils.getImgLib2DataType(dtype));
        strHeader = strHeader + "', 'fortran_order': " + (fortranOrder ? "True" : "False") + ", 'shape': (";
        for (long ll : shape) {
            strHeader = strHeader + ll + ", ";
        }
        strHeader = strHeader.substring(0, strHeader.length() - 2);
        strHeader = strHeader + "), }" + System.lineSeparator();
        byte[] bufInverse = strHeader.getBytes(StandardCharsets.UTF_8);
        byte[] major = new byte[]{1};
        byte[] minor = new byte[]{0};
        byte[] len = new byte[]{(byte)strHeader.length(), (byte)((short)strHeader.length() >> 8)};
        int totalLen = DecodeNumpy.NUMPY_PREFIX.length + 2 + 2 + bufInverse.length;
        byte[] total = new byte[totalLen];
        int c = 0;
        for (i = 0; i < DecodeNumpy.NUMPY_PREFIX.length; ++i) {
            total[c++] = DecodeNumpy.NUMPY_PREFIX[i];
        }
        total[c++] = major[0];
        total[c++] = minor[0];
        total[c++] = len[0];
        total[c++] = len[1];
        for (i = 0; i < bufInverse.length; ++i) {
            total[c++] = bufInverse[i];
        }
        return total;
    }

    @Override
    public String getName() {
        return this.memoryName;
    }

    @Override
    public String getNameForPython() {
        return this.memoryName.substring("/".length());
    }

    @Override
    public Pointer getPointer() {
        return this.pSharedMemory;
    }

    @Override
    public Object getSharedMemoryBlockID() {
        return this.shmFd;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getOriginalDataType() {
        if (this.originalDataType == null && this.isNumpyFormat.booleanValue()) {
            this.findNumpyFormat();
        }
        return this.originalDataType;
    }

    @Override
    public long[] getOriginalShape() {
        if (this.originalDims == null && this.isNumpyFormat.booleanValue()) {
            this.findNumpyFormat();
        }
        return this.originalDims;
    }

    @Override
    public boolean isNumpyFormat() {
        if (this.isNumpyFormat == null) {
            this.findNumpyFormat();
        }
        return this.isNumpyFormat;
    }

    private void findNumpyFormat() {
        this.isNumpyFormat = true;
        try {
            char order;
            int offset = 0;
            byte[] buf = new byte[DecodeNumpy.NUMPY_PREFIX.length];
            this.pSharedMemory.getByteBuffer((long)offset, (long)DecodeNumpy.NUMPY_PREFIX.length).get(buf, 0, DecodeNumpy.NUMPY_PREFIX.length);
            if (!Arrays.equals(buf, DecodeNumpy.NUMPY_PREFIX)) {
                throw new IllegalArgumentException("Malformed  or unsopported Numpy array");
            }
            offset = DecodeNumpy.NUMPY_PREFIX.length;
            byte major = this.pSharedMemory.getByteBuffer((long)offset, 1L).get();
            byte minor = this.pSharedMemory.getByteBuffer((long)(++offset), 1L).get();
            ++offset;
            if (major < 1 || major > 3 || minor != 0) {
                throw new IllegalArgumentException("Unknown numpy version: " + major + '.' + minor);
            }
            int len = major == 1 ? 2 : 4;
            ByteBuffer bb = this.pSharedMemory.getByteBuffer((long)offset, (long)len);
            offset += len;
            bb.order(ByteOrder.LITTLE_ENDIAN);
            len = major == 1 ? (int)bb.getShort() : bb.getInt();
            buf = new byte[len];
            this.pSharedMemory.getByteBuffer((long)offset, (long)len).get(buf, 0, len);
            offset += len;
            String header = new String(buf, StandardCharsets.UTF_8);
            Matcher m = DecodeNumpy.HEADER_PATTERN.matcher(header);
            if (!m.find()) {
                throw new IllegalArgumentException("Invalid numpy header: " + header);
            }
            String typeStr = m.group(1);
            String fortranOrder = m.group(2).trim();
            String shapeStr = m.group(3);
            long[] shape = new long[]{};
            if (!shapeStr.isEmpty()) {
                String[] tokens = shapeStr.split(", ?");
                shape = Arrays.stream(tokens).mapToLong(Long::parseLong).toArray();
            }
            if ((order = typeStr.charAt(0)) != '>' && order != '<' && order != '|') {
                new IllegalArgumentException("Not supported ByteOrder for the provided .npy array.");
            }
            String dtype = DecodeNumpy.getDataType(typeStr.substring(1));
            this.originalDims = shape;
            this.originalDataType = dtype;
            this.isFortran = fortranOrder.equals("True");
        }
        catch (Exception ex) {
            this.isNumpyFormat = false;
        }
    }

    @Override
    public void close() {
        if (this.unlinked) {
            return;
        }
        int checkhmFd = this.useLibRT ? INSTANCE_RT.shm_open(this.memoryName, 0, 448) : INSTANCE_C.shm_open(this.memoryName, 0, 448);
        if (checkhmFd < 0) {
            this.unlinked = true;
            return;
        }
        if (this.pSharedMemory != Pointer.NULL && this.useLibRT && INSTANCE_RT.munmap(this.pSharedMemory, this.size) == -1) {
            throw new RuntimeException("munmap failed. Errno: " + Native.getLastError());
        }
        if (this.pSharedMemory != Pointer.NULL && !this.useLibRT && INSTANCE_C.munmap(this.pSharedMemory, this.size) == -1) {
            throw new RuntimeException("munmap failed. Errno: " + Native.getLastError());
        }
        if (this.useLibRT && INSTANCE_RT.close(this.shmFd) == -1) {
            throw new RuntimeException("close failed. Errno: " + Native.getLastError());
        }
        if (!this.useLibRT && INSTANCE_C.close(this.shmFd) == -1) {
            throw new RuntimeException("close failed. Errno: " + Native.getLastError());
        }
        if (this.useLibRT) {
            INSTANCE_RT.shm_unlink(this.memoryName);
        } else {
            INSTANCE_C.shm_unlink(this.memoryName);
        }
        this.unlinked = true;
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI() {
        if (!(this.originalDims != null && this.originalDataType != null || this.isNumpyFormat())) {
            throw new IllegalArgumentException("The shared memory segment is not stored in Numpy format and the shape and/or data type are not known. Please provide information about them and use the method 'getSharedRAI(long[] shape, boolean isFortran, T dataType)'.");
        }
        if (this.isNumpyFormat()) {
            return this.buildImgLib2FromNumpyLikeSHMA();
        }
        return SharedMemoryArrayLinux.buildFromSharedMemoryBlock(this.pSharedMemory, this.originalDims, this.originalDataType, this.isFortran);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI(long[] shape, T dataType) {
        return SharedMemoryArrayLinux.buildFromSharedMemoryBlock(this.pSharedMemory, shape, dataType, this.isFortran, 0, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI(long[] shape, T dataType, boolean isFortran) {
        return SharedMemoryArrayLinux.buildFromSharedMemoryBlock(this.pSharedMemory, shape, dataType, isFortran, 0, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        if (buffer.capacity() > this.size) {
            throw new IllegalArgumentException("The buffer capacity has to be smaller or equal than the size of the shared memory segment.");
        }
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
        } else {
            byte[] array = new byte[buffer.remaining()];
            buffer.get(array);
        }
        this.pSharedMemory.write(0L, buffer.array(), 0, buffer.capacity());
    }

    @Override
    public ByteBuffer getDataBuffer() {
        return this.pSharedMemory.getByteBuffer(0L, (long)this.size);
    }

    @Override
    public ByteBuffer getDataBufferNoHeader() {
        int offset = 0;
        long totSize = 1L;
        for (long l : this.originalDims) {
            totSize *= l;
        }
        if (this.isNumpyFormat()) {
            long npSize = DecodeNumpy.calculateNpyStyleByteArrayLength(this.originalDims, (RealType)Cast.unchecked(CommonUtils.getImgLib2DataType(this.originalDataType)), this.isFortran);
            offset = (int)(npSize - (long)DecodeNumpy.DATA_TYPES_MAP.get(this.originalDataType).intValue() * totSize);
            totSize = npSize;
        }
        return this.pSharedMemory.getByteBuffer((long)offset, totSize - (long)offset);
    }

    private static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> buildFromSharedMemoryBlock(Pointer pSharedMemory, long[] shape, String type, boolean isFortran) {
        Object dataType = CommonUtils.getImgLib2DataType(type);
        return SharedMemoryArrayLinux.buildFromSharedMemoryBlock(pSharedMemory, shape, dataType, isFortran, 0, ByteOrder.LITTLE_ENDIAN);
    }

    private static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> buildFromSharedMemoryBlock(Pointer pSharedMemory, long[] shape, T dataType, boolean isFortran, int offset, ByteOrder order) {
        int arrSize;
        long[] transposedShape = new long[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            transposedShape[i] = shape[shape.length - i - 1];
        }
        if (dataType instanceof ByteType) {
            arrSize = 1;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ByteBufferAccess byteBufferAccess = new ByteBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.bytes((ByteAccess)byteBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof ByteType && isFortran) {
            arrSize = 1;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ByteBufferAccess byteBufferAccess = new ByteBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.bytes((ByteAccess)byteBufferAccess, (long[])shape));
        }
        if (dataType instanceof UnsignedByteType && isFortran) {
            arrSize = 1;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ByteBufferAccess byteBufferAccess = new ByteBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.unsignedBytes((ByteAccess)byteBufferAccess, (long[])shape));
        }
        if (dataType instanceof UnsignedByteType) {
            arrSize = 1;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ByteBufferAccess byteBufferAccess = new ByteBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.unsignedBytes((ByteAccess)byteBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof ShortType && isFortran) {
            arrSize = 2;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ShortBufferAccess shortBufferAccess = new ShortBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.shorts((ShortAccess)shortBufferAccess, (long[])shape));
        }
        if (dataType instanceof ShortType) {
            arrSize = 2;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ShortBufferAccess shortBufferAccess = new ShortBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.shorts((ShortAccess)shortBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof UnsignedShortType && isFortran) {
            arrSize = 2;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ShortBufferAccess shortBufferAccess = new ShortBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.unsignedShorts((ShortAccess)shortBufferAccess, (long[])shape));
        }
        if (dataType instanceof UnsignedShortType) {
            arrSize = 2;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ShortBufferAccess shortBufferAccess = new ShortBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.unsignedShorts((ShortAccess)shortBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof IntType && isFortran) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            IntBufferAccess intBufferAccess = new IntBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.ints((IntAccess)intBufferAccess, (long[])shape));
        }
        if (dataType instanceof IntType) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            IntBufferAccess intBufferAccess = new IntBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.ints((IntAccess)intBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof UnsignedIntType && isFortran) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            IntBufferAccess intBufferAccess = new IntBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.unsignedInts((IntAccess)intBufferAccess, (long[])shape));
        }
        if (dataType instanceof UnsignedIntType) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            IntBufferAccess intBufferAccess = new IntBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.unsignedInts((IntAccess)intBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof LongType && isFortran) {
            arrSize = 8;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            LongBufferAccess longBufferAccess = new LongBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.longs((LongAccess)longBufferAccess, (long[])shape));
        }
        if (dataType instanceof LongType) {
            arrSize = 8;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            LongBufferAccess longBufferAccess = new LongBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.longs((LongAccess)longBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof FloatType && isFortran) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            FloatBufferAccess floatBufferAccess = new FloatBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.floats((FloatAccess)floatBufferAccess, (long[])shape));
        }
        if (dataType instanceof FloatType) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            FloatBufferAccess floatBufferAccess = new FloatBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.floats((FloatAccess)floatBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof DoubleType && isFortran) {
            arrSize = 8;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            DoubleBufferAccess doubleBufferAccess = new DoubleBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.doubles((DoubleAccess)doubleBufferAccess, (long[])shape));
        }
        if (dataType instanceof DoubleType) {
            arrSize = 8;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            DoubleBufferAccess doubleBufferAccess = new DoubleBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.doubles((DoubleAccess)doubleBufferAccess, (long[])transposedShape)));
        }
        throw new IllegalArgumentException("Type not supported: " + dataType.getClass().toString());
    }

    private <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> buildImgLib2FromNumpyLikeSHMA() {
        int offset = 0;
        byte[] buf = new byte[DecodeNumpy.NUMPY_PREFIX.length];
        this.pSharedMemory.getByteBuffer((long)offset, (long)DecodeNumpy.NUMPY_PREFIX.length).get(buf, 0, DecodeNumpy.NUMPY_PREFIX.length);
        if (!Arrays.equals(buf, DecodeNumpy.NUMPY_PREFIX)) {
            throw new IllegalArgumentException("Malformed  or unsopported Numpy array");
        }
        offset = DecodeNumpy.NUMPY_PREFIX.length;
        byte major = this.pSharedMemory.getByteBuffer((long)offset, 1L).get();
        byte minor = this.pSharedMemory.getByteBuffer((long)(++offset), 1L).get();
        ++offset;
        if (major < 1 || major > 3 || minor != 0) {
            throw new IllegalArgumentException("Unknown numpy version: " + major + '.' + minor);
        }
        int len = major == 1 ? 2 : 4;
        ByteBuffer bb = this.pSharedMemory.getByteBuffer((long)offset, (long)len);
        offset += len;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        len = major == 1 ? (int)bb.getShort() : bb.getInt();
        buf = new byte[len];
        this.pSharedMemory.getByteBuffer((long)offset, (long)len).get(buf, 0, len);
        offset += len;
        String header = new String(buf, StandardCharsets.UTF_8);
        Matcher m = DecodeNumpy.HEADER_PATTERN.matcher(header);
        if (!m.find()) {
            throw new IllegalArgumentException("Invalid numpy header: " + header);
        }
        String typeStr = m.group(1);
        String fortranOrder = m.group(2).trim();
        String shapeStr = m.group(3);
        long[] shape = new long[]{};
        if (!shapeStr.isEmpty()) {
            String[] tokens = shapeStr.split(", ?");
            shape = Arrays.stream(tokens).mapToLong(Long::parseLong).toArray();
        }
        char order = typeStr.charAt(0);
        ByteOrder byteOrder = null;
        if (order == '>') {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (order == '<') {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (order == '|') {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
            new IOException("Numpy .npy file did not specify the byte order of the array. It was automatically opened as little endian but this does not guarantee the that the file is open correctly. Caution is advised.").printStackTrace();
        } else {
            new IllegalArgumentException("Not supported ByteOrder for the provided .npy array.");
        }
        String dtype = DecodeNumpy.getDataType(typeStr.substring(1));
        long numBytes = DecodeNumpy.DATA_TYPES_MAP.get(dtype).intValue();
        long count = shape.length == 0 ? 1L : Arrays.stream(shape).reduce(Math::multiplyExact).getAsLong();
        len = Math.toIntExact(count * numBytes);
        return SharedMemoryArrayLinux.buildFromSharedMemoryBlock(this.pSharedMemory, shape, (RealType)Cast.unchecked(CommonUtils.getImgLib2DataType(dtype)), fortranOrder.equals("True"), offset, byteOrder);
    }
}

