/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.ChainEndX;

public class RawChainArrayList {
    private static ChainEndX[] EMPTY = new ChainEndX[0];
    protected ChainEndX[] elementData;
    protected int elementCount;
    private static final long serialVersionUID = 1L;

    protected RawChainArrayList(int initialCapacity) {
        this.elementData = initialCapacity == 0 ? EMPTY : new ChainEndX[initialCapacity];
    }

    protected void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            ChainEndX[] oldData = this.elementData;
            int newCapacity = oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new ChainEndX[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    protected int size() {
        return this.elementCount;
    }

    protected Object get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elementData[index];
    }

    protected boolean isEmpty() {
        return this.elementCount == 0;
    }

    protected void clear() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    protected void add(ChainEndX o) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = o;
    }

    protected ChainEndX[] getArray() {
        return this.elementData;
    }

    protected ChainEndX[] getArray(int minArraySize) {
        this.ensureCapacity(minArraySize);
        return this.elementData;
    }
}

