/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.description.Axis;
import io.bioimage.modelrunner.bioimageio.description.AxisV04;
import io.bioimage.modelrunner.bioimageio.description.Badge;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.SampleImage;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.bioimageio.description.TensorSpecV04;
import io.bioimage.modelrunner.bioimageio.description.TestArtifact;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelDescriptorV04
extends ModelDescriptor {
    private String newModelID;

    protected ModelDescriptorV04(Map<String, Object> yamlElements) {
        this.yamlElements = yamlElements;
        this.buildModelDescription();
        this.buildBadgeElements();
        this.addSampleAndTestImages();
        this.newModelID = this.findID();
        this.modelID = this.findOldID();
        if (this.getNickname().equals("committed-turkey")) {
            ((TensorSpecV04)this.output_tensors.get((int)0)).dataType = "float32";
        }
    }

    @Override
    public String getNickname() {
        return this.newModelID;
    }

    @Override
    public boolean areRequirementsInstalled() {
        return true;
    }

    @Override
    protected List<String> buildAttachments() {
        Object att = this.yamlElements.get("attachments");
        if (att == null) {
            return new ArrayList<String>();
        }
        if (att instanceof Map) {
            return ModelDescriptorV04.getAllStrings((Map)att);
        }
        if (att instanceof List) {
            return ModelDescriptorV04.getAllStrings((List)att);
        }
        if (att instanceof String) {
            return Arrays.asList((String)att);
        }
        System.err.println("Cannot build the attachments for: " + this.name);
        return new ArrayList<String>();
    }

    private static List<String> getAllStrings(Map<String, Object> map) {
        ArrayList<String> strs = new ArrayList<String>();
        for (Map.Entry<String, Object> ee : map.entrySet()) {
            if (ee.getValue() instanceof String) {
                strs.add((String)ee.getValue());
                continue;
            }
            if (ee.getValue() instanceof Map) {
                strs.addAll(ModelDescriptorV04.getAllStrings((Map)ee.getValue()));
                continue;
            }
            if (!(ee.getValue() instanceof List)) continue;
            strs.addAll(ModelDescriptorV04.getAllStrings((List)ee.getValue()));
        }
        return strs;
    }

    private static List<String> getAllStrings(List<Object> list) {
        ArrayList<String> strs = new ArrayList<String>();
        for (Object ee : list) {
            if (ee instanceof String) {
                strs.add((String)ee);
                continue;
            }
            if (ee instanceof Map) {
                strs.addAll(ModelDescriptorV04.getAllStrings((Map)ee));
                continue;
            }
            if (!(ee instanceof List)) continue;
            strs.addAll(ModelDescriptorV04.getAllStrings((List)ee));
        }
        return strs;
    }

    @Override
    protected List<TensorSpec> buildInputTensors() {
        Object list = this.yamlElements.get("inputs");
        if (!(list instanceof List)) {
            return null;
        }
        ArrayList<TensorSpec> tensors = new ArrayList<TensorSpec>(((List)list).size());
        for (Object elem : (List)list) {
            if (!(elem instanceof Map)) continue;
            tensors.add(new TensorSpecV04((Map)elem, true));
        }
        return tensors;
    }

    @Override
    protected List<TensorSpec> buildOutputTensors() {
        Object list = this.yamlElements.get("outputs");
        if (!(list instanceof List)) {
            return null;
        }
        ArrayList<TensorSpec> tensors = new ArrayList<TensorSpec>(((List)list).size());
        for (Object elem : (List)list) {
            if (!(elem instanceof Map)) continue;
            tensors.add(new TensorSpecV04((Map)elem, false));
        }
        return tensors;
    }

    @Override
    protected void calculateTotalInputHalo() {
        for (TensorSpec out : this.output_tensors) {
            for (Axis ax : out.getAxesInfo().getAxesList()) {
                int axHalo = ax.getHalo();
                if (axHalo == 0) continue;
                String ref = ax.getReferenceTensor();
                if (ref == null) {
                    this.input_tensors.stream().forEach(tt -> {
                        AxisV04 inAx = tt.getAxesInfo().getAxesList().stream().filter(xx -> xx.getAxis().equals(ax.getAxis())).findFirst().orElse(null);
                        if (inAx == null || inAx.getHalo() > axHalo) {
                            return;
                        }
                        inAx.halo = axHalo;
                    });
                    return;
                }
                double axScale = ax.getScale();
                double axOffset = ax.getOffset();
                double nHalo = ((double)axHalo + axOffset) / axScale;
                AxisV04 inAx = (AxisV04)this.findInputTensor(ref).getAxesInfo().getAxis(ax.getReferenceAxis());
                if (inAx == null || (double)inAx.getHalo() > nHalo) {
                    return;
                }
                inAx.halo = (int)nHalo;
            }
        }
    }

    @Override
    protected String findID() {
        Map bioimageMap;
        Map configMap;
        if (this.yamlElements.get("config") != null && this.yamlElements.get("config") instanceof Map && (configMap = (Map)this.yamlElements.get("config")).get("bioimageio") != null && configMap.get("bioimageio") instanceof Map && (bioimageMap = (Map)configMap.get("bioimageio")).get("nickname") != null) {
            return (String)bioimageMap.get("nickname");
        }
        return (String)this.yamlElements.get("id");
    }

    @Override
    protected void addBioEngine() {
    }

    @Override
    public String getModelFamily() {
        return "bioimage.io";
    }

    protected void addSampleAndTestImages() {
        TensorSpecV04 tt;
        int i;
        List<SampleImage> sampleInputs = ModelDescriptorV04.buildSampleImages((List)this.yamlElements.get("sample_inputs"));
        List<SampleImage> sampleOutputs = ModelDescriptorV04.buildSampleImages((List)this.yamlElements.get("sample_outputs"));
        List<TestArtifact> testInputs = ModelDescriptorV04.buildTestArtifacts((List)this.yamlElements.get("test_inputs"));
        List<TestArtifact> testOutputs = ModelDescriptorV04.buildTestArtifacts((List)this.yamlElements.get("test_outputs"));
        for (i = 0; i < sampleInputs.size(); ++i) {
            tt = (TensorSpecV04)this.input_tensors.get(i);
            tt.sampleTensorName = sampleInputs.get(i).getName();
        }
        for (i = 0; i < testInputs.size(); ++i) {
            tt = (TensorSpecV04)this.input_tensors.get(i);
            tt.testTensorName = testInputs.get(i).getName();
        }
        for (i = 0; i < sampleOutputs.size(); ++i) {
            tt = (TensorSpecV04)this.output_tensors.get(i);
            tt.sampleTensorName = sampleOutputs.get(i).getName();
        }
        for (i = 0; i < testOutputs.size(); ++i) {
            tt = (TensorSpecV04)this.output_tensors.get(i);
            tt.testTensorName = testOutputs.get(i).getName();
        }
    }

    protected static List<SampleImage> buildSampleImages(Object coverElements) {
        ArrayList<SampleImage> covers = new ArrayList<SampleImage>();
        if (coverElements instanceof List) {
            List elems = (List)coverElements;
            for (Object elem : elems) {
                if (!(elem instanceof String)) continue;
                covers.add(SampleImage.build((String)elem));
            }
        } else if (coverElements instanceof String) {
            covers.add(SampleImage.build((String)coverElements));
        }
        return covers.stream().filter(i -> i != null).collect(Collectors.toList());
    }

    protected static List<TestArtifact> buildTestArtifacts(Object coverElements) {
        ArrayList<TestArtifact> covers = new ArrayList<TestArtifact>();
        if (coverElements instanceof List) {
            List elems = (List)coverElements;
            for (Object elem : elems) {
                if (!(elem instanceof String)) continue;
                covers.add(TestArtifact.build((String)elem));
            }
        } else if (coverElements instanceof String) {
            covers.add(TestArtifact.build((String)coverElements));
        }
        return covers.stream().filter(i -> i != null).collect(Collectors.toList());
    }

    private List<Badge> buildBadgeElements() {
        Object coverElements = this.yamlElements.get("badges");
        if (!(coverElements instanceof List)) {
            return null;
        }
        ArrayList<Badge> badges = new ArrayList<Badge>();
        for (Object elem : (List)coverElements) {
            if (!(elem instanceof Map)) continue;
            Map dict = (Map)elem;
            badges.add(Badge.build((String)dict.get("label"), (String)dict.get("icon"), (String)dict.get("url")));
        }
        return badges;
    }

    private String findOldID() {
        if (this.yamlElements.get("config") != null && this.yamlElements.get("config") instanceof Map) {
            Map configMap = (Map)this.yamlElements.get("config");
            if (configMap.get("_conceptdoi") != null && configMap.get("_conceptdoi") instanceof String) {
                return (String)configMap.get("_conceptdoi");
            }
            if (configMap.get("_id") != null && configMap.get("_id") instanceof String) {
                String id = (String)configMap.get("_id");
                if (id.length() - id.replace("/", "").length() >= 2 && id.substring(id.indexOf("/") + 1).indexOf("/") - id.indexOf("/") > 2) {
                    return id.substring(0, id.indexOf("/") + id.substring(id.indexOf("/") + 1).indexOf("/") + 1);
                }
                return id;
            }
        }
        if (this.yamlElements.get("id") != null && this.yamlElements.get("id") instanceof String) {
            String id = (String)this.yamlElements.get("id");
            if (id.length() - id.replace("/", "").length() >= 2 && id.substring(id.indexOf("/") + 1).indexOf("/") - id.indexOf("/") > 2) {
                return id.substring(0, id.indexOf("/") + id.substring(id.indexOf("/") + 1).indexOf("/") + 1);
            }
            return id;
        }
        return null;
    }

    protected void setInputTestNpyName(int n, String name) {
        TensorSpecV04 tt = (TensorSpecV04)this.input_tensors.get(n);
        if (this.localModelPath != null) {
            name = this.localModelPath + File.separator + name;
        }
        tt.testTensorName = name;
    }

    protected void setOutputTestNpyName(int n, String name) {
        TensorSpecV04 tt = (TensorSpecV04)this.output_tensors.get(n);
        if (this.localModelPath != null) {
            name = this.localModelPath + File.separator + name;
        }
        tt.testTensorName = name;
    }
}

