/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.model;

import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.tensor.Tensor;
import java.io.Closeable;
import java.util.List;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public abstract class BaseModel
implements Closeable {
    protected boolean loaded = false;
    protected boolean closed = false;
    protected String modelFolder;

    public abstract void loadModel() throws LoadModelException;

    @Override
    public abstract void close();

    public abstract <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> void run(List<Tensor<T>> var1, List<Tensor<R>> var2) throws RunModelException;

    public abstract <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<T>> run(List<Tensor<R>> var1) throws RunModelException;

    public String getModelFolder() {
        return this.modelFolder;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

