/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.border.TitledBorder;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPanel;

public class EzGroup
extends EzPanel {
    private final FoldHandler foldHandler = new FoldHandler();
    private final ArrayList<FoldListener> listeners = new ArrayList();

    public EzGroup(String groupTitle, EzComponent ... ezComponents) {
        super(groupTitle, ezComponents);
        this.container.addMouseListener(this.foldHandler);
    }

    public void addFoldListener(FoldListener listener) {
        this.listeners.add(listener);
    }

    @Deprecated
    public void addEzComponent(EzComponent ... ezComponents) {
        super.add(ezComponents);
    }

    @Override
    protected void buildPanel() {
        if (this.foldHandler.isFolded) {
            this.container.removeAll();
            this.container.setBorder(this.foldHandler.foldedBorder);
        } else {
            super.buildPanel();
            this.container.setBorder(this.foldHandler.unfoldedBorder);
        }
    }

    @Override
    public void dispose() {
        this.listeners.clear();
        this.container.removeMouseListener(this.foldHandler);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFoldStateChanged(boolean state) {
        ArrayList<FoldListener> listenersCopy;
        ArrayList<FoldListener> arrayList = this.listeners;
        synchronized (arrayList) {
            listenersCopy = new ArrayList<FoldListener>(this.listeners);
        }
        for (FoldListener listener : listenersCopy) {
            listener.foldStateChanged(state);
        }
    }

    public boolean getFoldedState() {
        return this.foldHandler.isFolded;
    }

    public void setFoldedState(boolean folded) {
        if (folded == this.foldHandler.isFolded) {
            return;
        }
        this.foldHandler.isFolded = folded;
        this.fireFoldStateChanged(folded);
        this.foldHandler.adjustToolTip();
    }

    private final class FoldHandler
    implements MouseListener {
        private boolean isFolded = false;
        private static final char FOLDED_SYMBOL = '\u25b6';
        private static final char UNFOLDED_SYMBOL = '\u25bc';
        private final TitledBorder foldedBorder;
        private final TitledBorder unfoldedBorder;

        private FoldHandler() {
            this.foldedBorder = new TitledBorder("\u25b6 " + EzGroup.this.name);
            this.unfoldedBorder = new TitledBorder("\u25bc " + EzGroup.this.name);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FontMetrics fm = EzGroup.this.container.getGraphics().getFontMetrics();
            int w = fm.charWidth('\u25b6');
            int h = fm.getHeight();
            int xBorder = 10;
            int yBorder = 4;
            if (e.getX() < xBorder || e.getY() < yBorder || e.getX() > xBorder + w || e.getY() > yBorder + h) {
                e.consume();
                return;
            }
            this.isFolded = !this.isFolded;
            EzGroup.this.fireFoldStateChanged(this.isFolded);
            this.adjustToolTip();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.adjustToolTip();
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void adjustToolTip() {
            if (this.isFolded && !EzGroup.this.getToolTipText().isEmpty()) {
                EzGroup.this.container.setToolTipText(EzGroup.this.getToolTipText());
            } else {
                EzGroup.this.container.setToolTipText(null);
            }
        }
    }

    public static interface FoldListener {
        public void foldStateChanged(boolean var1);
    }
}

