/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;

public class EzVarDimensionPicker
extends EzVarInteger {
    private boolean active;
    final Var<Sequence> s;
    final DimensionId dim;
    final SequenceChangedListener listener;

    public EzVarDimensionPicker(String varName, DimensionId dim, EzVarSequence sequence) {
        this(varName, dim, sequence.variable);
    }

    public EzVarDimensionPicker(String varName, DimensionId dim, Var<Sequence> sequence) {
        this(varName, dim, sequence, false);
    }

    public EzVarDimensionPicker(String varName, DimensionId dim, Var<Sequence> sequence, boolean allowAll) {
        super(varName, allowAll ? -1 : 0, allowAll ? -1 : 0, 0, 1);
        if (allowAll) {
            this.setToolTipText("Choose -1 to select all values");
        }
        this.s = sequence;
        this.dim = dim;
        this.listener = new SequenceChangedListener();
        this.s.addListener(this.listener);
        this.listener.valueChanged(sequence, null, sequence.getValue());
        this.active = true;
    }

    private static int getSize(Sequence s, DimensionId dim) {
        switch (dim) {
            case X: {
                return s.getSizeX();
            }
            case Y: {
                return s.getSizeY();
            }
            case Z: {
                return s.getSizeZ();
            }
            case T: {
                return s.getSizeT();
            }
            case C: {
                return s.getSizeC();
            }
        }
        throw new IllegalArgumentException("Unknown sequence dimension: " + (Object)((Object)dim));
    }

    @Override
    protected void dispose() {
        this.s.removeListener(this.listener);
        super.dispose();
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        if (active) {
            this.s.addListener(this.listener);
        } else {
            this.s.removeListener(this.listener);
        }
    }

    private final class SequenceChangedListener
    implements VarListener<Sequence> {
        private SequenceChangedListener() {
        }

        @Override
        public void valueChanged(Var<Sequence> source, Sequence oldValue, Sequence newValue) {
            if (newValue == null) {
                EzVarDimensionPicker.this.setVisible(false);
                EzVarDimensionPicker.this.setValue(0);
            } else {
                int currentValue = (Integer)EzVarDimensionPicker.this.getValue();
                EzVarDimensionPicker.this.setValue(-1);
                int size = EzVarDimensionPicker.getSize(newValue, EzVarDimensionPicker.this.dim);
                EzVarDimensionPicker.this.setVisible(size > 1);
                EzVarDimensionPicker.this.setMaxValue(Integer.valueOf(size - 1));
                EzVarDimensionPicker.this.setValue(currentValue >= size ? 0 : currentValue);
            }
        }

        @Override
        public void referenceChanged(Var<Sequence> source, Var<? extends Sequence> oldReference, Var<? extends Sequence> newReference) {
        }
    }
}

