/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.button;

import icy.action.IcyAbstractAction;
import icy.gui.util.ComponentUtil;
import icy.resource.icon.IcyIcon;
import icy.util.StringUtil;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class IcyToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 568831905293026365L;
    private boolean flat = false;

    public IcyToggleButton(IcyAbstractAction action) {
        super(action);
        this.init();
    }

    @Deprecated
    public IcyToggleButton(icy.common.IcyAbstractAction action) {
        super(action);
        this.init();
    }

    public IcyToggleButton(String text, IcyIcon icon) {
        super(text, (Icon)((Object)icon));
        this.init();
    }

    public IcyToggleButton(IcyIcon icon) {
        this(null, icon);
    }

    @Deprecated
    public IcyToggleButton(String text, Image iconImage, int iconSize) {
        this(text, new IcyIcon(iconImage, iconSize));
    }

    @Deprecated
    public IcyToggleButton(String text, Image iconImage) {
        this(text, iconImage, 20);
    }

    @Deprecated
    public IcyToggleButton(Image iconImage, int iconSize) {
        this(null, iconImage, iconSize);
    }

    @Deprecated
    public IcyToggleButton(Image iconImage) {
        this(null, iconImage, 20);
    }

    @Deprecated
    public IcyToggleButton(String text, String iconName, int iconSize) {
        this(text, new IcyIcon(iconName, iconSize));
    }

    @Deprecated
    public IcyToggleButton(String text, String iconName) {
        this(text, iconName, 20);
    }

    @Deprecated
    public IcyToggleButton(String iconName, int iconSize) {
        this(null, iconName, iconSize);
    }

    @Deprecated
    public IcyToggleButton(String iconName) {
        this(iconName, 20);
    }

    private void init() {
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        if (this.flat) {
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setFocusable(false);
        }
        this.updateSize();
    }

    @Override
    public void setAction(Action a) {
        super.setAction(a);
        IcyAbstractAction.setToolTipTextFromAction(this, a);
    }

    public IcyIcon getIcyIcon() {
        Icon icon = this.getIcon();
        if (icon instanceof IcyIcon) {
            return (IcyIcon)((Object)icon);
        }
        return null;
    }

    public IcyIcon getSelectedIcyIcon() {
        Icon icon = this.getSelectedIcon();
        if (icon instanceof IcyIcon) {
            return (IcyIcon)((Object)icon);
        }
        return null;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean flat) {
        if (this.flat != flat) {
            this.flat = flat;
            this.setBorderPainted(!flat);
            this.setFocusPainted(!flat);
            this.setFocusable(!flat);
            this.updateSize();
        }
    }

    public String getIconName() {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            return icon.getName();
        }
        return null;
    }

    public void setIconName(String iconName) {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            icon.setName(iconName);
            this.updateSize();
        }
    }

    public String getSelectedIconName() {
        IcyIcon icon = this.getSelectedIcyIcon();
        if (icon != null) {
            return icon.getName();
        }
        return null;
    }

    public void setSelectedIconName(String iconName) {
        IcyIcon icon = this.getSelectedIcyIcon();
        if (icon != null) {
            icon.setName(iconName);
            this.updateSize();
        }
    }

    public void setIconImage(Image iconImage) {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            icon.setImage(iconImage);
            this.updateSize();
        }
    }

    public void setSelectedIconImage(Image iconImage) {
        IcyIcon icon = this.getSelectedIcyIcon();
        if (icon != null) {
            icon.setImage(iconImage);
            this.updateSize();
        }
    }

    public int getIconSize() {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            return icon.getSize();
        }
        return -1;
    }

    public void setIconSize(int iconSize) {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            icon.setSize(iconSize);
            this.updateSize();
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.updateSize();
    }

    public void updateSize() {
        IcyIcon icon = this.getIcyIcon();
        boolean noText = StringUtil.isEmpty(this.getText());
        if (this.flat && icon != null && (noText |= this.getAction() != null && this.getHideActionText())) {
            Dimension dim = icon.getDimension();
            dim.height += 2;
            dim.width += 2;
            ComponentUtil.setFixedSize(this, dim);
        }
    }

    @Override
    protected void actionPropertyChanged(Action action, String propertyName) {
        if (propertyName == "LongDescription" || propertyName == "ShortDescription") {
            IcyAbstractAction.setToolTipTextFromAction(this, action);
        } else {
            super.actionPropertyChanged(action, propertyName);
        }
    }
}

