/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.custom;

import io.bioimage.modelrunner.gui.custom.FooterPanel;
import io.bioimage.modelrunner.gui.custom.PlaceholderTextField;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CellposeGUI
extends JPanel {
    private static final long serialVersionUID = 5381352117710530216L;
    protected JLabel modelLabel;
    protected JLabel customLabel;
    protected JLabel cytoplasmLabel;
    protected JLabel nucleiLabel;
    protected JLabel diameterLabel;
    protected JComboBox<String> modelComboBox;
    protected PlaceholderTextField customModelPathField;
    protected JButton browseButton;
    protected PlaceholderTextField diameterField;
    protected JComboBox<String> cytoCbox;
    protected JComboBox<String> nucleiCbox;
    protected JCheckBox check;
    protected FooterPanel footer;
    protected final String CUSOTM_STR = "your custom model";
    protected static final List<String> VAR_NAMES = Arrays.asList("Select a model:", "Custom Model Path:", "Cytoplasm Color:", "Nuclei Color:", "Diameter:", "Display all outputs");
    public static final String[] RGB_LIST = new String[]{"red", "blue", "green"};
    public static final String[] GRAYSCALE_LIST = new String[]{"gray"};
    public static final HashMap<String, Integer> CHANNEL_MAP = new HashMap();
    private static final Dimension MIN_D;

    protected CellposeGUI() {
        this.setLayout(null);
        this.modelLabel = new JLabel(VAR_NAMES.get(0));
        String[] models = new String[]{"cyto3", "cyto2", "cyto", "nuclei", "your custom model"};
        this.modelComboBox = new JComboBox<String>(models);
        this.customLabel = new JLabel(VAR_NAMES.get(1));
        this.customLabel.setEnabled(false);
        this.customModelPathField = new PlaceholderTextField("path to your custom model");
        this.customModelPathField.setEnabled(false);
        this.browseButton = new JButton("Browse");
        this.browseButton.setEnabled(false);
        this.cytoplasmLabel = new JLabel(VAR_NAMES.get(2));
        this.nucleiLabel = new JLabel(VAR_NAMES.get(3));
        this.cytoCbox = new JComboBox<String>(RGB_LIST);
        this.nucleiCbox = new JComboBox<String>(RGB_LIST);
        this.diameterLabel = new JLabel(VAR_NAMES.get(4));
        this.diameterField = new PlaceholderTextField("optional");
        this.check = new JCheckBox(VAR_NAMES.get(5));
        this.check.setSelected(false);
        this.footer = new FooterPanel();
        this.add(this.footer);
        this.add(this.modelLabel);
        this.add(this.modelComboBox);
        this.add(this.customLabel);
        this.add(this.customModelPathField);
        this.add(this.browseButton);
        this.add(this.cytoplasmLabel);
        this.add(this.cytoCbox);
        this.add(this.nucleiLabel);
        this.add(this.nucleiCbox);
        this.add(this.diameterLabel);
        this.add(this.diameterField);
        this.add(this.check);
        this.setMinimumSize(MIN_D);
        this.organiseComponents();
        this.modelComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                boolean enabled = CellposeGUI.this.modelComboBox.getSelectedItem().equals("your custom model");
                CellposeGUI.this.customLabel.setEnabled(enabled);
                CellposeGUI.this.customModelPathField.setEnabled(enabled);
                CellposeGUI.this.browseButton.setEnabled(enabled);
            }
        });
    }

    private void organiseComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int rawW = CellposeGUI.this.getWidth();
                int rawH = CellposeGUI.this.getHeight();
                int inset = 5;
                int nParams = VAR_NAMES.size();
                int nRows = nParams + 1;
                int rowH = (rawH - inset * nRows) / nRows;
                int y = inset;
                int modelLabelW = (rawW - inset * 3) / 5;
                CellposeGUI.this.modelLabel.setBounds(inset, y, modelLabelW, rowH);
                int cboxW = rawW - inset * 3 - modelLabelW;
                CellposeGUI.this.modelComboBox.setBounds(inset * 2 + modelLabelW, y, cboxW, rowH);
                int browseButtonW = modelLabelW / 1;
                int textFieldW = rawW - inset * 4 - modelLabelW - browseButtonW;
                CellposeGUI.this.customLabel.setBounds(inset, y += inset + rowH, modelLabelW, rowH);
                CellposeGUI.this.customModelPathField.setBounds(inset * 2 + modelLabelW, y, textFieldW, rowH);
                CellposeGUI.this.browseButton.setBounds(inset * 3 + modelLabelW + textFieldW, y, browseButtonW, rowH);
                CellposeGUI.this.cytoplasmLabel.setBounds(inset, y += inset + rowH, modelLabelW, rowH);
                CellposeGUI.this.cytoCbox.setBounds(inset * 2 + modelLabelW, y, cboxW, rowH);
                CellposeGUI.this.nucleiLabel.setBounds(inset, y += inset + rowH, modelLabelW, rowH);
                CellposeGUI.this.nucleiCbox.setBounds(inset * 2 + modelLabelW, y, cboxW, rowH);
                CellposeGUI.this.diameterLabel.setBounds(inset, y += inset + rowH, modelLabelW, rowH);
                CellposeGUI.this.diameterField.setBounds(inset * 2 + modelLabelW, y, cboxW, rowH);
                CellposeGUI.this.check.setBounds(inset, y += inset + rowH, rawW - 2 * inset, rowH);
                CellposeGUI.this.footer.setBounds(inset, y += inset + rowH, rawW - 2 * inset, rowH);
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Cellpose Plugin");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add(new CellposeGUI());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setSize(60, 100);
            }
        });
    }

    static {
        CHANNEL_MAP.put("red", 1);
        CHANNEL_MAP.put("blue", 2);
        CHANNEL_MAP.put("green", 3);
        CHANNEL_MAP.put("gray", 0);
        MIN_D = new Dimension(20, 40);
    }
}

