/*
 * Decompiled with CFR 0.152.
 */
package icy.preferences;

import icy.util.ClassUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPreferences {
    private static final String TYPE_SECTION = "section";
    private static final String TYPE_KEY = "key";
    private final XMLPreferencesRoot root;
    private final Element currentElement;

    XMLPreferences(XMLPreferencesRoot root, Element element) {
        this.root = root;
        this.currentElement = element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String absolutePath() {
        String result = "/" + this.name();
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            Element parent = XMLUtil.getParentElement(this.currentElement);
            while (parent != null && parent != this.root.element) {
                result = "/" + XMLUtil.getGenericElementName(parent) + result;
                parent = XMLUtil.getParentElement(parent);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String name() {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            return XMLUtil.getGenericElementName(this.currentElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLPreferences getParent() {
        Element parent;
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            parent = XMLUtil.getParentElement(this.currentElement);
        }
        if (parent != null) {
            return new XMLPreferences(this.root, parent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<XMLPreferences> getChildren() {
        ArrayList<Element> elements;
        ArrayList<XMLPreferences> result = new ArrayList<XMLPreferences>();
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            elements = XMLUtil.getGenericElements(this.currentElement, TYPE_SECTION);
        }
        for (Element element : elements) {
            result.add(new XMLPreferences(this.root, element));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> childrenNames() {
        ArrayList<String> result = new ArrayList<String>();
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            for (Element element : XMLUtil.getGenericElements(this.currentElement, TYPE_SECTION)) {
                result.add(XMLUtil.getGenericElementName(element));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getSection(String name) {
        Element element;
        if (StringUtil.isEmpty(name)) {
            return this.currentElement;
        }
        if (name.startsWith("/")) {
            element = this.root.element;
        } else {
            if (!this.exists()) {
                return null;
            }
            element = this.currentElement;
        }
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            String[] stringArray = name.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String subName = stringArray[n2];
                if (!subName.isEmpty()) {
                    element = XMLUtil.getGenericElement(element, TYPE_SECTION, subName);
                }
                ++n2;
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element setSection(String name) {
        Element element;
        if (StringUtil.isEmpty(name)) {
            return this.currentElement;
        }
        if (name.startsWith("/")) {
            element = this.root.element;
        } else {
            if (!this.exists()) {
                return null;
            }
            element = this.currentElement;
        }
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            String[] stringArray = name.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String subName = stringArray[n2];
                if (!subName.isEmpty()) {
                    element = XMLUtil.setGenericElement(element, TYPE_SECTION, subName);
                }
                ++n2;
            }
        }
        return element;
    }

    public XMLPreferences node(String name) {
        Element element = this.setSection(name);
        if (element != null) {
            return new XMLPreferences(this.root, element);
        }
        return null;
    }

    public XMLPreferences nodeForClass(Object object) {
        if (object != null) {
            return this.node(ClassUtil.getPathFromQualifiedName(object.getClass().getName()));
        }
        return null;
    }

    public Element getXMLNode() {
        return this.currentElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists() {
        if (this.currentElement == this.root.element) {
            return true;
        }
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            Element parent = XMLUtil.getParentElement(this.currentElement);
            while (true) {
                if (parent == null) {
                    return false;
                }
                if (parent == this.root.element) {
                    return true;
                }
                parent = XMLUtil.getParentElement(parent);
            }
        }
    }

    public boolean nodeExists(String name) {
        return this.getSection(name) != null;
    }

    public boolean nodeForClassExists(Object object) {
        if (object != null) {
            return this.nodeExists(ClassUtil.getPathFromQualifiedName(object.getClass().getName()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> keys() {
        ArrayList<String> result = new ArrayList<String>();
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            for (Element element : XMLUtil.getGenericElements(this.currentElement, TYPE_KEY)) {
                result.add(XMLUtil.getGenericElementName(element));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            ArrayList<Node> nodes = XMLUtil.getChildren(this.currentElement);
            for (Node node : nodes) {
                String nodeName = node.getNodeName();
                if (nodeName.equals(TYPE_KEY) || nodeName.equals(TYPE_SECTION)) continue;
                XMLUtil.removeNode((Node)this.currentElement, node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.removeChildren(this.currentElement, TYPE_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Element element) {
        if (element != null) {
            XMLPreferencesRoot xMLPreferencesRoot = this.root;
            synchronized (xMLPreferencesRoot) {
                Element parent = XMLUtil.getParentElement(element);
                if (parent != null) {
                    XMLUtil.removeNode((Node)parent, element);
                }
            }
        }
    }

    public void remove() {
        this.remove(this.currentElement);
    }

    public void remove(String name) {
        this.remove(this.getSection(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren() {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.removeChildren(this.currentElement, TYPE_SECTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, String def) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            return XMLUtil.getGenericElementValue(this.currentElement, TYPE_KEY, key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean def) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            return XMLUtil.getGenericElementBooleanValue(this.currentElement, TYPE_KEY, key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String key, byte[] def) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            return XMLUtil.getGenericElementBytesValue(this.currentElement, TYPE_KEY, key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String key, double def) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            return XMLUtil.getGenericElementDoubleValue(this.currentElement, TYPE_KEY, key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float def) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            return XMLUtil.getGenericElementFloatValue(this.currentElement, TYPE_KEY, key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int def) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            return XMLUtil.getGenericElementIntValue(this.currentElement, TYPE_KEY, key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long def) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            return XMLUtil.getGenericElementLongValue(this.currentElement, TYPE_KEY, key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.setGenericElementValue(this.currentElement, TYPE_KEY, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBoolean(String key, boolean value) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.setGenericElementBooleanValue(this.currentElement, TYPE_KEY, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBytes(String key, byte[] value) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.setGenericElementBytesValue(this.currentElement, TYPE_KEY, key, (byte[])value.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDouble(String key, double value) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.setGenericElementDoubleValue(this.currentElement, TYPE_KEY, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFloat(String key, float value) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.setGenericElementFloatValue(this.currentElement, TYPE_KEY, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInt(String key, int value) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.setGenericElementIntValue(this.currentElement, TYPE_KEY, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLong(String key, long value) {
        XMLPreferencesRoot xMLPreferencesRoot = this.root;
        synchronized (xMLPreferencesRoot) {
            XMLUtil.setGenericElementLongValue(this.currentElement, TYPE_KEY, key, value);
        }
    }

    public static class XMLPreferencesRoot {
        private final String filename;
        private Document doc;
        Element element;
        XMLPreferences preferences;

        public XMLPreferencesRoot(String filename) {
            this.filename = filename;
            this.load();
        }

        public void load() {
            this.load(this.filename);
        }

        public void load(String filename) {
            try {
                this.doc = XMLUtil.loadDocument(new File(filename));
            }
            catch (Throwable t) {
                System.err.println("Error: " + filename + " preferences file is corrupted, cannot recover settings.");
                this.doc = null;
            }
            if (this.doc == null) {
                this.doc = XMLUtil.createDocument(false);
            }
            this.element = XMLUtil.createRootElement(this.doc);
            this.preferences = new XMLPreferences(this, this.element);
            this.preferences.clean();
        }

        public void save() {
            this.save(this.filename);
        }

        public void save(String filename) {
            if (this.doc != null) {
                XMLUtil.saveDocument(this.doc, new File(filename));
            }
        }

        public Element getElement() {
            return this.element;
        }

        public XMLPreferences getPreferences() {
            return this.preferences;
        }
    }
}

