/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.system.thread.ThreadUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import plugins.adufour.ezplug.EzComponent;

public class EzLabel
extends EzComponent {
    private JEditorPane label;
    private String text;
    private Color textColor;
    private int labelWidth = 200;

    public EzLabel(String text) {
        this(text, null);
    }

    public EzLabel(String text, Color textColor) {
        super("label");
        this.text = text;
        this.textColor = textColor;
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                EzLabel.this.label = new JEditorPane("text/html", "");
                EzLabel.this.label.setEditable(false);
                EzLabel.this.label.setOpaque(false);
                EzLabel.this.label.setMargin(new Insets(0, 2, 0, 2));
                EzLabel.this.updateLabel();
            }
        }, !SwingUtilities.isEventDispatchThread());
    }

    public void setText(String text) {
        this.text = text;
        this.updateLabel();
    }

    public void setLabelWidth(int width) {
        this.labelWidth = width;
        this.updateLabel();
    }

    public void setColor(Color textColor) {
        this.textColor = textColor;
        this.updateLabel();
    }

    @Override
    protected void addTo(Container container) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 10, 2, 10);
        gbc.fill = 2;
        gbc.gridwidth = 0;
        container.add((Component)this.label, gbc);
    }

    @Override
    public void setToolTipText(String text) {
        this.label.setToolTipText(text);
    }

    @Deprecated
    public void setNumberOfColumns(int nbCols) {
    }

    @Deprecated
    public void setNumberOfRows(int nbRows) {
    }

    private static String convertToHTML(String text, Color textColor, int labelWidth) {
        if (text.trim().toLowerCase().startsWith("<html>") && text.toLowerCase().contains("<body")) {
            return text;
        }
        String html = text.trim();
        if (!html.toLowerCase().startsWith("<html>")) {
            html = "<html>" + html.replace("\n", "<br>") + "</html>";
        }
        int r = textColor.getRed();
        int g = textColor.getGreen();
        int b = textColor.getBlue();
        String style = "max-width: " + labelWidth + "px; ";
        style = style + "font: helvetica; ";
        style = style + "color: rgb(" + r + "," + g + "," + b + "); ";
        html = html.replace("<html>", "<html><body style='" + style + "'>");
        html = html.replace("</html>", "</body></html>");
        return html;
    }

    private void updateLabel() {
        Color color = this.textColor;
        if (color == null) {
            color = this.label.getForeground();
        }
        String html = EzLabel.convertToHTML(this.text, color, this.labelWidth);
        this.label.setText(html);
    }
}

