/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.transformations;

import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.transformations.AbstractTensorTransformation;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class ScaleLinearTransformation
extends AbstractTensorTransformation {
    private static final String name = "scale_linear";
    private Double gainDouble = 1.0;
    private Double offsetDouble = 0.0;
    private double[] gainArr;
    private double[] offsetArr;
    private String axes;
    private double eps = Math.pow(10.0, -6.0);

    public ScaleLinearTransformation() {
        super(name);
    }

    public void setEps(Object eps) {
        if (eps instanceof Integer) {
            this.eps = ((Integer)eps).intValue();
        } else if (eps instanceof Double) {
            this.eps = (Double)eps;
        } else if (eps instanceof String) {
            this.eps = Double.valueOf((String)eps);
        } else {
            throw new IllegalArgumentException("'eps' parameter has to be either and instance of " + Float.class + " or " + Double.class + ". The provided argument is an instance of: " + eps.getClass());
        }
    }

    public void setGain(Object gain) {
        if (gain instanceof Integer) {
            this.gainDouble = (double)((Integer)gain);
        } else if (gain instanceof Double) {
            this.gainDouble = (double)((Double)gain);
        } else if (gain instanceof String) {
            this.gainDouble = Double.valueOf((String)gain);
        } else if (gain instanceof ArrayList) {
            this.gainArr = new double[((ArrayList)gain).size()];
            int c = 0;
            for (Object elem : (ArrayList)gain) {
                if (elem instanceof Integer) {
                    this.gainArr[c++] = ((Integer)elem).intValue();
                    continue;
                }
                if (elem instanceof Double) {
                    this.gainArr[c++] = (Double)elem;
                    continue;
                }
                if (elem instanceof ArrayList) {
                    throw new IllegalArgumentException("'gain' parameter cannot be an ArrayList containing another ArrayList. At the moment, only transformations of planes is allowed.");
                }
                throw new IllegalArgumentException("If the 'gain' parameter is an array, its elements  have to be instances of" + Integer.class + " or " + Double.class + ". The provided ArrayList contains instances of: " + elem.getClass());
            }
        } else {
            throw new IllegalArgumentException("'gain' parameter has to be either and instance of " + Integer.class + ", " + Double.class + " or " + ArrayList.class + ". The provided argument is an instance of: " + gain.getClass());
        }
    }

    public void setOffset(Object offset) {
        if (offset instanceof Integer) {
            this.offsetDouble = (double)((Integer)offset);
        } else if (offset instanceof Double) {
            this.offsetDouble = (double)((Double)offset);
        } else if (offset instanceof String) {
            this.offsetDouble = Double.valueOf((String)offset);
        } else if (offset instanceof ArrayList) {
            this.offsetArr = new double[((ArrayList)offset).size()];
            int c = 0;
            for (Object elem : (ArrayList)offset) {
                if (elem instanceof Integer) {
                    this.offsetArr[c++] = ((Integer)elem).intValue();
                    continue;
                }
                if (elem instanceof Double) {
                    this.offsetArr[c++] = (Double)elem;
                    continue;
                }
                if (elem instanceof ArrayList) {
                    throw new IllegalArgumentException("'offset' parameter cannot be an ArrayList containing another ArrayList. At the moment, only transformations of planes is allowed.");
                }
                throw new IllegalArgumentException("If the 'offset' parameter is an array, its elements  have to be instances of" + Integer.class + " or " + Double.class + ". The provided ArrayList contains instances of: " + elem.getClass());
            }
        } else {
            throw new IllegalArgumentException("'offset' parameter has to be either and instance of " + Integer.class + ", " + Double.class + " or " + ArrayList.class + ". The provided argument is an instance of: " + offset.getClass());
        }
    }

    public void setAxes(Object axes) {
        if (axes instanceof String && ((String)axes).equals("channel")) {
            this.axes = "c";
        } else if (axes instanceof String) {
            this.axes = (String)axes;
        } else if (axes instanceof List) {
            this.axes = "";
            for (Object ax : (List)axes) {
                if (!(ax instanceof String)) {
                    throw new IllegalArgumentException("JDLL does not currently support this axes format. Please write an issue attaching the rdf.yaml file at: https://github.com/bioimage-io/JDLL/issues");
                }
                ax = ax.equals("channel") ? "c" : ax;
                this.axes = this.axes + ax;
            }
        } else if (axes instanceof String[]) {
            String[] axesArr = (String[])axes;
            this.axes = "";
            for (String ax : axesArr) {
                ax = ax.equals("channel") ? "c" : ax;
                this.axes = this.axes + ax;
            }
        } else {
            throw new IllegalArgumentException("'axes' parameter has to be an instance of " + String.class + ", of a String array or of a List of Strings. The provided argument is " + axes.getClass());
        }
    }

    public void setAxis(Object axes) {
        if (axes instanceof String && ((String)axes).equals("channel")) {
            this.axes = "c";
        } else if (axes instanceof String) {
            this.axes = (String)axes;
        } else if (axes instanceof List) {
            this.axes = "";
            for (Object ax : (List)axes) {
                if (!(ax instanceof String)) {
                    throw new IllegalArgumentException("JDLL does not currently support this axes format. Please write an issue attaching the rdf.yaml file at: https://github.com/bioimage-io/JDLL/issues");
                }
                ax = ax.equals("channel") ? "c" : ax;
                this.axes = this.axes + ax;
            }
        } else if (axes instanceof String[]) {
            String[] axesArr = (String[])axes;
            this.axes = "";
            for (String ax : axesArr) {
                ax = ax.equals("channel") ? "c" : ax;
                this.axes = this.axes + ax;
            }
        } else {
            throw new IllegalArgumentException("'axes' parameter has to be an instance of " + String.class + ", of a String array or of a List of Strings. The provided argument is " + axes.getClass());
        }
    }

    public void checkRequiredArgs() {
        if (this.offsetDouble == null && this.offsetArr == null) {
            throw new IllegalArgumentException(String.format(DEFAULT_MISSING_ARG_ERR, name, "offset"));
        }
        if (this.gainDouble == null && this.gainArr == null) {
            throw new IllegalArgumentException(String.format(DEFAULT_MISSING_ARG_ERR, name, "gain"));
        }
        if (this.offsetDouble == null && this.gainDouble != null || this.offsetDouble != null && this.gainDouble == null) {
            throw new IllegalArgumentException("Both arguments 'gain' and 'offset' need to be of the same type. Either a single value or an array.");
        }
        if (this.offsetArr != null && this.axes == null) {
            throw new IllegalArgumentException("If 'offset' and 'gain' are provided as arrays, the corresponding 'axes' argument should be provided too.");
        }
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> Tensor<FloatType> apply(Tensor<R> input) {
        this.checkRequiredArgs();
        Tensor<FloatType> output = this.makeOutput(input);
        this.applyInPlace(output);
        return output;
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> void applyInPlace(Tensor<R> input) {
        this.checkRequiredArgs();
        String selectedAxes = "";
        for (String ax : input.getAxesOrderString().split("")) {
            if (this.axes == null || this.axes.toLowerCase().contains(ax.toLowerCase()) || ax.toLowerCase().equals("b")) continue;
            selectedAxes = selectedAxes + ax;
        }
        if (this.axes == null || selectedAxes.equals("") || input.getAxesOrderString().replace("b", "").length() == selectedAxes.length()) {
            if (this.gainDouble == null) {
                throw new IllegalArgumentException("The 'axes' parameter is not compatible with the parameters 'gain' and 'offset'.The parameters gain and offset cannot be arrays with the given axes parameter provided.");
            }
            this.globalScale(input);
        } else if (this.axes.length() <= 2 && this.axes.length() > 0) {
            this.axesScale(input, selectedAxes);
        } else {
            throw new IllegalArgumentException("At the moment, only allowed scaling of planes.");
        }
    }

    private <R extends RealType<R> & NativeType<R>> void globalScale(Tensor<R> output) {
        this.scaleLinear(output.getData(), this.gainDouble, this.offsetDouble);
    }

    private <R extends RealType<R> & NativeType<R>> void axesScale(Tensor<R> output, String axesOfInterest) {
        int i;
        long[] start = new long[output.getData().numDimensions()];
        long[] dims = output.getData().dimensionsAsLongArray();
        long[] indOfDims = new long[axesOfInterest.length()];
        long[] sizeOfDims = new long[axesOfInterest.length()];
        for (i = 0; i < indOfDims.length; ++i) {
            indOfDims[i] = output.getAxesOrderString().indexOf(axesOfInterest.split("")[i]);
        }
        for (i = 0; i < sizeOfDims.length; ++i) {
            sizeOfDims[i] = dims[(int)indOfDims[i]];
        }
        long[][] points = ScaleLinearTransformation.getAllCombinations(sizeOfDims);
        int c = 0;
        for (long[] pp : points) {
            for (int i2 = 0; i2 < pp.length; ++i2) {
                start[(int)indOfDims[i2]] = pp[i2];
                dims[(int)indOfDims[i2]] = pp[i2] + 1L;
            }
            long[] end = new long[dims.length];
            for (int i3 = 0; i3 < dims.length; ++i3) {
                end[i3] = dims[i3] - start[i3];
            }
            IntervalView plane = Views.offsetInterval(output.getData(), (long[])start, (long[])end);
            float gain = (float)(this.gainArr != null ? this.gainArr[c] : this.gainDouble);
            float offset = (float)(this.offsetArr != null ? this.offsetArr[c] : this.offsetDouble);
            this.scaleLinear((RandomAccessibleInterval<R>)plane, gain, offset);
        }
    }

    private static long[][] getAllCombinations(long[] arr) {
        long n = 1L;
        for (long nn : arr) {
            n *= nn;
        }
        long[][] allPoints = new long[(int)n][arr.length];
        int i = 0;
        while ((long)i < n) {
            for (int j = 0; j < arr.length; ++j) {
                int factor = 1;
                for (int k = 0; k < j; ++k) {
                    factor = (int)((long)factor * arr[k]);
                }
                int auxVal = i / factor;
                int val = auxVal % (int)arr[j];
                allPoints[i][j] = val;
            }
            ++i;
        }
        return allPoints;
    }

    public <R extends RealType<R> & NativeType<R>> void scaleLinear(RandomAccessibleInterval<R> rai, double gain, double offset) {
        RealType type = (RealType)Util.getTypeFromInterval(rai);
        if (type instanceof IntegerType) {
            LoopBuilder.setImages(rai).multiThreaded().forEachPixel(i -> i.setReal(Math.floor(i.getRealDouble() * gain + offset)));
        } else {
            LoopBuilder.setImages(rai).multiThreaded().forEachPixel(i -> i.setReal(i.getRealDouble() * gain + offset));
        }
    }
}

