/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.AreaX;
import icy.type.geom.areax.AreaXBody;
import icy.type.geom.areax.AreaXOperation;
import icy.type.geom.areax.AreaXRules;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class BoundsRules
extends AreaXRules {
    boolean lookForDisconnectedShapes;
    boolean lookForInnerShapes;

    public BoundsRules() {
        this(true, true);
    }

    public BoundsRules(boolean lookForInnerShapes, boolean lookForDisconnectedShapes) {
        this.lookForInnerShapes = lookForInnerShapes;
        this.lookForDisconnectedShapes = lookForDisconnectedShapes;
    }

    @Override
    public AreaXBody execute(AreaXBody body, AreaXOperation[] operations) {
        ArrayList<Object> vector = new ArrayList<Object>();
        int startOfRun = this.getStartingIndex(-1, operations);
        while (startOfRun != -1 && startOfRun < operations.length) {
            int operator = operations[startOfRun].operator;
            int endOfRun = startOfRun;
            int k = startOfRun + 1;
            while (k < operations.length) {
                if (operations[k] != null) {
                    if (operations[k].operator == operator) {
                        endOfRun = k++;
                        continue;
                    }
                    endOfRun = k - 1;
                    k = operations.length;
                    continue;
                }
                ++k;
            }
            body = this.executeRun(body, operator, startOfRun, endOfRun, operations, vector);
            startOfRun = this.getStartingIndex(endOfRun + 1, operations);
        }
        return body;
    }

    private int getStartingIndex(int initialIndex, AreaXOperation[] operations) {
        int k = initialIndex;
        while (k < operations.length) {
            if (k >= 0 && operations[k] != null) {
                return k;
            }
            ++k;
        }
        return k;
    }

    private AreaXBody executeRun(AreaXBody body, int operator, int startIndex, int endIndex, AreaXOperation[] operations, List<Object> vector) {
        int a = startIndex;
        while (a <= endIndex) {
            Shape shape = operations[a].getOperand();
            if (!(shape instanceof AreaX)) {
                AreaXBody newBody = AreaXBody.create(shape.getPathIterator(null), false);
                operations[a] = new AreaXOperation(new AreaX(newBody), operator);
            }
            ++a;
        }
        if (this.lookForDisconnectedShapes || this.lookForInnerShapes) {
            boolean canSearchInnerShapes = operator == 0 || operator == 1;
            List<Object> listOfUnconnectedShapes = vector;
            if (operator != 3) {
                int a2 = startIndex;
                while (a2 < endIndex) {
                    listOfUnconnectedShapes.clear();
                    if (operations[a2] != null) {
                        AreaX base = (AreaX)operations[a2].getOperand();
                        Rectangle2D baseBounds = operations[a2].getBounds();
                        vector.add(operations[a2]);
                        int b = a2 + 1;
                        while (b <= endIndex) {
                            Rectangle2D bBounds;
                            Rectangle2D rectangle2D = bBounds = operations[b] != null ? operations[b].getBounds() : null;
                            if (this.lookForInnerShapes && canSearchInnerShapes && operations[b] != null && baseBounds.contains(bBounds) && base.contains(operations[b].getBounds())) {
                                operations[b] = null;
                            }
                            if (this.lookForDisconnectedShapes && operations[b] != null) {
                                boolean failed = false;
                                int c = 0;
                                while (!failed && c < vector.size()) {
                                    AreaXOperation op = (AreaXOperation)vector.get(c);
                                    if (bBounds.intersects(op.getBounds())) {
                                        failed = true;
                                    }
                                    ++c;
                                }
                                if (!failed) {
                                    listOfUnconnectedShapes.add(operations[b]);
                                    operations[b] = null;
                                }
                            }
                            ++b;
                        }
                        if (listOfUnconnectedShapes.size() > 1) {
                            AreaXBody newBody = base != null ? base.getBody() : ((AreaX)operations[a2].getOperand()).getBody();
                            int size = listOfUnconnectedShapes.size();
                            int b2 = 1;
                            while (b2 < size) {
                                Shape shape = ((AreaXOperation)listOfUnconnectedShapes.get(b2)).getOperand();
                                AreaXBody bodyB = ((AreaX)shape).getBody();
                                vector.set(b2, bodyB);
                                ++b2;
                            }
                            newBody = newBody.merge(vector, 1, size - 1);
                            operations[a2] = new AreaXOperation(new AreaX(newBody), operator);
                        }
                    }
                    ++a2;
                }
            }
        }
        return super.execute(body, startIndex, endIndex, operations);
    }
}

