/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.transformations;

import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.transformations.AbstractTensorPixelTransformation;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class BinarizeTransformation
extends AbstractTensorPixelTransformation {
    private static String name = "binarize";
    private Double threshold;
    private Double eps = Math.pow(10.0, -6.0);

    public BinarizeTransformation() {
        super(name);
        super.setDoubleUnitaryOperator(v -> v >= this.threshold ? 1.0 : 0.0);
    }

    public void setEps(Object eps) {
        if (eps instanceof Integer) {
            this.eps = (double)((Integer)eps);
        } else if (eps instanceof Double) {
            this.eps = (double)((Double)eps);
        } else if (eps instanceof String) {
            this.eps = Double.valueOf((String)eps);
        } else {
            throw new IllegalArgumentException("'eps' parameter has to be either and instance of " + Float.class + " or " + Double.class + ". The provided argument is an instance of: " + eps.getClass());
        }
    }

    public void setThreshold(Object threshold) {
        if (threshold instanceof Integer) {
            this.threshold = (double)((Integer)threshold);
        } else if (threshold instanceof Double) {
            this.threshold = (double)((Double)threshold);
        } else if (threshold instanceof String) {
            this.threshold = Double.valueOf((String)threshold);
        } else {
            throw new IllegalArgumentException("'threshold' parameter has to be either and instance of " + Integer.class + " or " + Double.class + ". The provided argument is an instance of: " + threshold.getClass());
        }
    }

    public void checkRequiredArgs() {
        if (this.threshold == null) {
            throw new IllegalArgumentException(String.format(DEFAULT_MISSING_ARG_ERR, name, "threshold"));
        }
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> Tensor<FloatType> apply(Tensor<R> input) {
        this.checkRequiredArgs();
        return super.apply(input);
    }

    @Override
    public <R extends RealType<R> & NativeType<R>> void applyInPlace(Tensor<R> input) {
        this.checkRequiredArgs();
        super.applyInPlace(input);
    }
}

