/*
 * Decompiled with CFR 0.152.
 */
package icy.search;

import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.interface_.PluginSearchProvider;
import icy.search.SearchResult;
import icy.search.SearchResultConsumer;
import icy.search.SearchResultProducer;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SearchEngine
implements SearchResultConsumer,
PluginLoader.PluginLoaderListener {
    final ArrayList<SearchResultProducer> producers = new ArrayList();
    private final List<SearchEngineListener> listeners = new ArrayList<SearchEngineListener>();
    final Runnable searchProviderSetter = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String savedSearch = SearchEngine.this.lastSearch;
            SearchEngine.this.cancelSearch();
            ArrayList<SearchResultProducer> arrayList = SearchEngine.this.producers;
            synchronized (arrayList) {
                SearchEngine.this.producers.clear();
            }
            for (PluginDescriptor plugin : PluginLoader.getPlugins(PluginSearchProvider.class)) {
                try {
                    PluginSearchProvider psp = (PluginSearchProvider)((Object)plugin.getPluginClass().newInstance());
                    SearchResultProducer producer = psp.getSearchProviderClass().newInstance();
                    ArrayList<SearchResultProducer> arrayList2 = SearchEngine.this.producers;
                    synchronized (arrayList2) {
                        SearchEngine.this.producers.add(producer);
                    }
                }
                catch (Throwable t) {
                    IcyExceptionHandler.handleException(plugin, t, true);
                }
            }
            arrayList = SearchEngine.this.producers;
            synchronized (arrayList) {
                Collections.sort(SearchEngine.this.producers);
            }
            SearchEngine.this.search(savedSearch);
        }
    };
    String lastSearch = "";

    public SearchEngine() {
        PluginLoader.addListener(this);
        this.updateSearchProducers();
    }

    private void updateSearchProducers() {
        ThreadUtil.runSingle(this.searchProviderSetter);
    }

    public void cancelSearch() {
        this.search("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(String text) {
        this.lastSearch = text;
        this.fireSearchStartedEvent();
        ArrayList<SearchResultProducer> arrayList = this.producers;
        synchronized (arrayList) {
            for (SearchResultProducer producer : this.producers) {
                producer.search(text, (SearchResultConsumer)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResultProducer> getSearchResultProducers() {
        ArrayList<SearchResultProducer> arrayList = this.producers;
        synchronized (arrayList) {
            return new ArrayList<SearchResultProducer>(this.producers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSearchingProducerCount() {
        int result = 0;
        ArrayList<SearchResultProducer> arrayList = this.producers;
        synchronized (arrayList) {
            for (SearchResultProducer producer : this.producers) {
                if (!producer.isSearching()) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSearching() {
        ArrayList<SearchResultProducer> arrayList = this.producers;
        synchronized (arrayList) {
            SearchResultProducer producer;
            Iterator<SearchResultProducer> iterator = this.producers.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(producer = iterator.next()).isSearching());
            return true;
        }
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public SearchResult getResult(int index) {
        List<SearchResult> results = this.getResults();
        if (index >= 0 && index < results.size()) {
            return results.get(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> getResults() {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        ArrayList<SearchResultProducer> arrayList = this.producers;
        synchronized (arrayList) {
            for (SearchResultProducer producer : this.producers) {
                List<SearchResult> producerResults;
                List<SearchResult> list = producerResults = producer.getResults();
                synchronized (list) {
                    Collections.sort(producerResults);
                    results.addAll(producerResults);
                }
            }
        }
        return results;
    }

    @Override
    public void pluginLoaderChanged(PluginLoader.PluginLoaderEvent e) {
        this.updateSearchProducers();
    }

    @Override
    public void resultChanged(SearchResultProducer producer, SearchResult result) {
        this.fireResultChangedEvent(result);
    }

    @Override
    public void resultsChanged(SearchResultProducer producer) {
        this.fireResultsChangedEvent();
    }

    @Override
    public void searchCompleted(SearchResultProducer producer) {
        if (this.getSearchingProducerCount() == 1) {
            this.fireSearchCompletedEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchEngineListener> getListeners() {
        List<SearchEngineListener> list = this.listeners;
        synchronized (list) {
            return new ArrayList<SearchEngineListener>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SearchEngineListener listener) {
        SearchEngineListener searchEngineListener = listener;
        synchronized (searchEngineListener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SearchEngineListener listener) {
        SearchEngineListener searchEngineListener = listener;
        synchronized (searchEngineListener) {
            this.listeners.remove(listener);
        }
    }

    protected void fireResultChangedEvent(SearchResult result) {
        for (SearchEngineListener listener : this.getListeners()) {
            listener.resultChanged(this, result);
        }
    }

    protected void fireResultsChangedEvent() {
        for (SearchEngineListener listener : this.getListeners()) {
            listener.resultsChanged(this);
        }
    }

    protected void fireSearchStartedEvent() {
        for (SearchEngineListener listener : this.getListeners()) {
            listener.searchStarted(this);
        }
    }

    protected void fireSearchCompletedEvent() {
        for (SearchEngineListener listener : this.getListeners()) {
            listener.searchCompleted(this);
        }
    }

    public static interface SearchEngineListener {
        public void resultChanged(SearchEngine var1, SearchResult var2);

        public void resultsChanged(SearchEngine var1);

        public void searchStarted(SearchEngine var1);

        public void searchCompleted(SearchEngine var1);
    }
}

