/*
 * Decompiled with CFR 0.152.
 */
package icy.system;

import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.util.StringUtil;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.FieldInfo;

public class ClassPatcher {
    private static final String ARG_RESULT = "result";
    private final ClassPool pool = ClassPool.getDefault();
    private final String patchPackage;
    private final String patchSuffix;

    public ClassPatcher(ClassLoader classLoader, String patchPackage, String patchSuffix) {
        this.pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        if (classLoader != null) {
            this.pool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
        }
        this.patchPackage = patchPackage;
        this.patchSuffix = patchSuffix;
    }

    public ClassPatcher(String patchPackage, String patchSuffix) {
        this(null, patchPackage, patchSuffix);
    }

    public void insertAfterMethod(String fullClass, String methodSig) {
        this.insertAfterMethod(fullClass, methodSig, this.newCode(fullClass, methodSig));
    }

    public void insertAfterMethod(String fullClass, String methodSig, String newCode) {
        try {
            this.getMethod(fullClass, methodSig).insertAfter(newCode);
        }
        catch (CannotCompileException e) {
            throw new IllegalArgumentException("Cannot modify method: " + methodSig, e);
        }
    }

    public void insertBeforeMethod(String fullClass, String methodSig) {
        this.insertBeforeMethod(fullClass, methodSig, this.newCode(fullClass, methodSig));
    }

    public void insertBeforeMethod(String fullClass, String methodSig, String newCode) {
        try {
            this.getMethod(fullClass, methodSig).insertBefore(newCode);
        }
        catch (CannotCompileException e) {
            throw new IllegalArgumentException("Cannot modify method: " + methodSig, e);
        }
    }

    public void insertMethod(String fullClass, String methodSig) {
        this.insertMethod(fullClass, methodSig, this.newCode(fullClass, methodSig));
    }

    public void insertMethod(String fullClass, String methodSig, String newCode) {
        CtClass classRef = this.getClass(fullClass);
        String methodBody = String.valueOf(methodSig) + " { " + newCode + " } ";
        try {
            CtMethod methodRef = CtNewMethod.make((String)methodBody, (CtClass)classRef);
            classRef.addMethod(methodRef);
        }
        catch (CannotCompileException e) {
            throw new IllegalArgumentException("Cannot add method: " + methodSig, e);
        }
    }

    public void replaceMethod(String fullClass, String methodSig) {
        this.replaceMethod(fullClass, methodSig, this.newCode(fullClass, methodSig));
    }

    public void replaceMethod(String fullClass, String methodSig, String newCode) {
        try {
            this.getMethod(fullClass, methodSig).setBody(newCode);
        }
        catch (CannotCompileException e) {
            throw new IllegalArgumentException("Cannot modify method: " + methodSig, e);
        }
    }

    public Class<?> loadClass(String fullClass, Class<?> neighbor) {
        CtClass classRef = this.getClass(fullClass);
        try {
            if (SystemUtil.getJavaVersionAsNumber() >= 9.0) {
                return this.pool.toClass(classRef, neighbor);
            }
            return this.pool.toClass(classRef);
        }
        catch (CannotCompileException e) {
            IcyExceptionHandler.showErrorMessage(e, false);
            System.err.println("Cannot load class: " + fullClass);
            return null;
        }
    }

    public Class<?> loadClass(String fullClass, Class<?> neighbor, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        CtClass classRef = this.getClass(fullClass);
        try {
            if (SystemUtil.getJavaVersionAsNumber() >= 9.0) {
                return this.pool.toClass(classRef, neighbor, classLoader, protectionDomain);
            }
            return this.pool.toClass(classRef, classLoader, protectionDomain);
        }
        catch (CannotCompileException e) {
            IcyExceptionHandler.showErrorMessage(e, false);
            System.err.println("Cannot load class: " + fullClass);
            return null;
        }
    }

    public void setFieldPublic(String fullClass, String name) {
        CtField field = this.getField(fullClass, name);
        FieldInfo info = field.getFieldInfo();
        info.setAccessFlags(1);
    }

    private CtClass getClass(String fullClass) {
        try {
            return this.pool.get(fullClass);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("No such class: " + fullClass, e);
        }
    }

    private CtMethod getMethod(String fullClass, String methodSig) {
        CtClass cc = this.getClass(fullClass);
        String name = this.getMethodName(methodSig);
        String[] argTypes = this.getMethodArgTypes(methodSig, false);
        CtClass[] params = new CtClass[argTypes.length];
        int i = 0;
        while (i < params.length) {
            params[i] = this.getClass(argTypes[i]);
            ++i;
        }
        try {
            return cc.getDeclaredMethod(name, params);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("No such method: " + methodSig, e);
        }
    }

    private CtField getField(String fullClass, String name) {
        CtClass cc = this.getClass(fullClass);
        try {
            return cc.getDeclaredField(name);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("No such field: " + name, e);
        }
    }

    private String newCode(String fullClass, String methodSig) {
        int dotIndex = fullClass.lastIndexOf(".");
        String className = fullClass.substring(dotIndex + 1);
        String methodName = this.getMethodName(methodSig);
        boolean isStatic = this.isStatic(methodSig);
        boolean isVoid = this.isVoid(methodSig);
        StringBuilder newCode = new StringBuilder(String.valueOf(isVoid ? "" : "return ") + this.patchPackage + "." + className + this.patchSuffix + "." + methodName + "(");
        boolean firstArg = true;
        if (!isStatic) {
            newCode.append("this");
            firstArg = false;
        }
        int i = 1;
        String[] stringArray = this.getMethodArgNames(methodSig, true);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String argName = stringArray[n2];
            if (firstArg) {
                firstArg = false;
            } else {
                newCode.append(", ");
            }
            if (StringUtil.equals(argName, ARG_RESULT)) {
                newCode.append("$_");
            } else {
                newCode.append("$" + i);
                ++i;
            }
            ++n2;
        }
        newCode.append(");");
        return newCode.toString();
    }

    private String getMethodName(String methodSig) {
        int parenIndex = methodSig.indexOf("(");
        int spaceIndex = methodSig.lastIndexOf(" ", parenIndex);
        return methodSig.substring(spaceIndex + 1, parenIndex);
    }

    private String[] getMethodArgs(String methodSig, boolean wantResult) {
        String[] args;
        ArrayList<String> result = new ArrayList<String>();
        int parenIndex = methodSig.indexOf("(");
        String methodArgs = methodSig.substring(parenIndex + 1, methodSig.length() - 1);
        String[] stringArray = args = methodArgs.equals("") ? new String[]{} : methodArgs.split(",");
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String a = arg.trim();
            if (!StringUtil.equals(a.split(" ")[1], ARG_RESULT) || wantResult) {
                result.add(a);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getMethodArgTypes(String methodSig, boolean wantResult) {
        String[] args = this.getMethodArgs(methodSig, wantResult);
        int i = 0;
        while (i < args.length) {
            args[i] = args[i].split(" ")[0];
            ++i;
        }
        return args;
    }

    private String[] getMethodArgNames(String methodSig, boolean wantResult) {
        String[] args = this.getMethodArgs(methodSig, wantResult);
        int i = 0;
        while (i < args.length) {
            args[i] = args[i].split(" ")[1];
            ++i;
        }
        return args;
    }

    private boolean isStatic(String methodSig) {
        int parenIndex = methodSig.indexOf("(");
        String methodPrefix = methodSig.substring(0, parenIndex);
        String[] stringArray = methodPrefix.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.equals("static")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isVoid(String methodSig) {
        int parenIndex = methodSig.indexOf("(");
        String methodPrefix = methodSig.substring(0, parenIndex);
        return methodPrefix.startsWith("void ") || methodPrefix.indexOf(" void ") > 0;
    }
}

