/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.apposed.appose;

import io.bioimage.modelrunner.apposed.appose.Environment;
import io.bioimage.modelrunner.apposed.appose.Mamba;
import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.compress.archivers.ArchiveException;

public class Builder {
    private boolean systemPath;
    private File baseDir;
    private File condaEnvironmentYaml;
    private String javaVendor;
    private String javaVersion;

    public Environment build() {
        final String base = this.baseDir.getPath();
        final boolean useSystemPath = this.systemPath;
        try {
            Mamba conda = new Mamba(Mamba.BASE_PATH);
            conda.installMicromamba();
            String envName = "appose";
            if (!conda.getEnvironmentNames().contains(envName)) {
                conda.createWithYaml(envName, this.condaEnvironmentYaml.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ArchiveException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MambaInstallException e) {
            throw new RuntimeException(e);
        }
        return new Environment(){

            @Override
            public String base() {
                return base;
            }

            @Override
            public boolean useSystemPath() {
                return useSystemPath;
            }
        };
    }

    public Builder useSystemPath() {
        this.systemPath = true;
        return this;
    }

    public Builder base(File directory) {
        this.baseDir = directory;
        return this;
    }

    public Builder conda(File environmentYaml) {
        this.condaEnvironmentYaml = environmentYaml;
        return this;
    }

    public Builder java(String vendor, String version) {
        this.javaVendor = vendor;
        this.javaVersion = version;
        return this;
    }
}

