/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.model.special.stardist;

import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.model.special.stardist.StardistAbstract;
import io.bioimage.modelrunner.tensor.Tensor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.apache.commons.compress.archivers.ArchiveException;

public class Stardist2D
extends StardistAbstract {
    private static String MODULE_NAME = "StarDist2D";
    private static final Map<String, String> PRETRAINED_EQUIVALENCE = new HashMap<String, String>();

    protected Stardist2D(String modelName, String baseDir, Map<String, Object> config) throws IOException {
        super(modelName, baseDir, config);
        this.scaleRangeAxes = "xyc";
    }

    private Stardist2D(String modelName, String baseDir) throws IOException {
        super(modelName, baseDir);
        String axes = ((String)this.config.get("axes")).toUpperCase();
        if (axes.contains("Z")) {
            throw new IllegalArgumentException("Trying to instantiate a StarDist3D model. Please use Stardist3D instead of Stardist2D.");
        }
        this.scaleRangeAxes = "xyc";
    }

    private Stardist2D(ModelDescriptor descriptor) throws IOException {
        super(descriptor);
        String axes = ((String)this.config.get("axes")).toUpperCase();
        if (axes.contains("Z")) {
            throw new IllegalArgumentException("Trying to instantiate a StarDist3D model. Please use Stardist3D instead of Stardist2D.");
        }
        this.scaleRangeAxes = "xyc";
    }

    @Override
    protected String createImportsCode() {
        return String.format(LOAD_MODEL_CODE_ABSTRACT, MODULE_NAME, MODULE_NAME, MODULE_NAME, MODULE_NAME, MODULE_NAME, this.name, this.basedir);
    }

    @Override
    protected <T extends RealType<T> & NativeType<T>> void checkInput(RandomAccessibleInterval<T> image) {
        if (image.dimensionsAsLongArray().length == 2 && this.nChannels != 1) {
            throw new IllegalArgumentException("Stardist2D needs an image with three dimensions: XYC");
        }
        if (image.dimensionsAsLongArray().length != 3 && this.nChannels != 1) {
            throw new IllegalArgumentException("Stardist2D needs an image with three dimensions: XYC");
        }
        if (image.dimensionsAsLongArray().length != 2 && image.dimensionsAsLongArray()[2] != (long)this.nChannels) {
            throw new IllegalArgumentException("This Stardist2D model requires " + this.nChannels + " channels.");
        }
        if (image.dimensionsAsLongArray().length > 3 || image.dimensionsAsLongArray().length < 2) {
            throw new IllegalArgumentException("Stardist2D model requires an image with dimensions XYC.");
        }
    }

    @Override
    protected <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> reconstructMask() throws IOException {
        RandomAccessibleInterval<RealType> maskCopy;
        RandomAccessibleInterval mask = this.shma.getSharedRAI();
        if (this.nChannels == 1) {
            maskCopy = Tensor.createCopyOfRaiInWantedDataType((RandomAccessibleInterval)Cast.unchecked(mask), (RealType)Util.getTypeFromInterval((Interval)Cast.unchecked(this.shma.getSharedRAI())));
            this.shma.close();
        } else {
            long[] maxPos = mask.maxAsLongArray();
            maxPos[2] = 0L;
            IntervalView maskInterval = Views.interval(mask, (long[])mask.minAsLongArray(), (long[])maxPos);
            maskCopy = Tensor.createCopyOfRaiInWantedDataType((RandomAccessibleInterval)Cast.unchecked((Object)maskInterval), (RealType)Util.getTypeFromInterval((Interval)Cast.unchecked(this.shma.getSharedRAI())));
            this.shma.close();
        }
        return maskCopy;
    }

    @Override
    public boolean is2D() {
        return true;
    }

    @Override
    public boolean is3D() {
        return false;
    }

    public static Stardist2D fromBioimageioModel(ModelDescriptor descriptor) throws IOException {
        if (!descriptor.getConfig().getSpecMap().keySet().contains("stardist")) {
            throw new IllegalArgumentException("This Bioimage.io model does not correspond to a StarDist model.");
        }
        if (!descriptor.getModelFamily().equals("stardist")) {
            throw new RuntimeException("Please first install StarDist with 'StardistAbstract.installRequirements()'");
        }
        if (descriptor.getInputTensors().get(0).getAxesOrder().contains("z")) {
            throw new IllegalArgumentException("This StarDist model is 3D");
        }
        return new Stardist2D(descriptor);
    }

    public static Stardist2D fromPretained(String pretrainedModel, boolean install) throws IOException, InterruptedException {
        return Stardist2D.fromPretained(pretrainedModel, new File("models").getAbsolutePath(), install);
    }

    public static Stardist2D fromPretained(String pretrainedModel, String installDir, boolean install) throws IOException, InterruptedException {
        if ((pretrainedModel.equals("StarDist H&E Nuclei Segmentation") || pretrainedModel.equals("2D_versatile_he")) && !install) {
            ModelDescriptor md = ModelDescriptorFactory.getModelsAtLocalRepo().stream().filter(mm -> mm.getName().equals("StarDist H&E Nuclei Segmentation")).findFirst().orElse(null);
            if (md != null) {
                return new Stardist2D(md);
            }
            return null;
        }
        if (pretrainedModel.equals("StarDist H&E Nuclei Segmentation") || pretrainedModel.equals("2D_versatile_he")) {
            String path = BioimageioRepo.connect().downloadByName("StarDist H&E Nuclei Segmentation", installDir);
            return Stardist2D.fromBioimageioModel(ModelDescriptorFactory.readFromLocalFile(path));
        }
        if ((pretrainedModel.equals("StarDist Fluorescence Nuclei Segmentation") || pretrainedModel.equals("2D_versatile_fluo")) && !install) {
            ModelDescriptor md = ModelDescriptorFactory.getModelsAtLocalRepo().stream().filter(mm -> mm.getName().equals("StarDist Fluorescence Nuclei Segmentation")).findFirst().orElse(null);
            if (md != null) {
                return new Stardist2D(md);
            }
            return null;
        }
        if (pretrainedModel.equals("StarDist Fluorescence Nuclei Segmentation") || pretrainedModel.equals("2D_versatile_fluo")) {
            String path = BioimageioRepo.connect().downloadByName("StarDist Fluorescence Nuclei Segmentation", installDir);
            return Stardist2D.fromBioimageioModel(ModelDescriptorFactory.readFromLocalFile(path));
        }
        throw new IllegalArgumentException("There is no Stardist2D model called: " + pretrainedModel);
    }

    public static String donwloadPretrained(String modelName, String downloadDir) throws ExecutionException, InterruptedException, IOException {
        return Stardist2D.donwloadPretrained(modelName, downloadDir, null);
    }

    public static String donwloadPretrained(String modelName, String downloadDir, Consumer<Double> progressConsumer) throws InterruptedException, IOException {
        if (!PRETRAINED_EQUIVALENCE.keySet().contains(modelName)) {
            return Stardist2D.donwloadPretrainedBioimageio(modelName, downloadDir, progressConsumer);
        }
        return Stardist2D.donwloadPretrainedBioimageio(PRETRAINED_EQUIVALENCE.get(modelName), downloadDir, progressConsumer);
    }

    private static String donwloadPretrainedBioimageio(String modelName, String downloadDir, Consumer<Double> progressConsumer) throws InterruptedException, IOException {
        BioimageioRepo br = BioimageioRepo.connect();
        ModelDescriptor descriptor = br.selectByName(modelName);
        if (descriptor == null) {
            descriptor = br.selectByID(modelName);
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("The model does not correspond to on of the available pretrained StarDist2D models. To find a list of available cellpose models, please run StarDist2D.getPretrainedList()");
        }
        return BioimageioRepo.downloadModel(descriptor, downloadDir, progressConsumer);
    }

    public static void main(String[] args) throws IOException, InterruptedException, RuntimeException, MambaInstallException, LoadEngineException, RunModelException, ArchiveException, URISyntaxException, LoadModelException {
        Stardist2D.installRequirements();
        Stardist2D model = Stardist2D.fromPretained("2D_versatile_fluo", false);
        ArrayImg img = ArrayImgs.floats((long[])new long[]{512L, 512L});
        Map res = model.run(img);
        model.close();
        System.out.println(true);
    }

    static {
        PRETRAINED_EQUIVALENCE.put("2D_versatile_he", "StarDist H&E Nuclei Segmentation");
        PRETRAINED_EQUIVALENCE.put("2D_versatile_fluo", "StarDist Fluorescence Nuclei Segmentation");
    }
}

