/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence.edit;

import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.edit.AbstractROIsSequenceEdit;
import java.util.Collection;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ROIRemovesSequenceEdit
extends AbstractROIsSequenceEdit {
    public ROIRemovesSequenceEdit(Sequence sequence, Collection<ROI> rois) {
        super(sequence, rois, rois.size() > 1 ? "ROI group removed" : "ROI removed");
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Sequence sequence = this.getSequence();
        sequence.beginUpdate();
        try {
            for (ROI roi : this.getROIs()) {
                sequence.addROI(roi, false);
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Sequence sequence = this.getSequence();
        sequence.beginUpdate();
        try {
            for (ROI roi : this.getROIs()) {
                sequence.removeROI(roi, false);
            }
        }
        finally {
            sequence.endUpdate();
        }
    }
}

