/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.system;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private final int major;
    private final int minor;
    private final int patch;
    private final String preRelease;
    private final String buildMetadata;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(?<major>0|[1-9]\\d*)(?:\\.(?<minor>0|[1-9]\\d*))?(?:\\.(?<patch>0|[1-9]\\d*))?(?:-(?<pre>[0-9A-Za-z-\\.]+))?(?:\\+(?<build>[0-9A-Za-z-\\.]+))?$");

    private Version(int major, int minor, int patch, String preRelease, String buildMetadata) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.buildMetadata = buildMetadata;
    }

    public static Version parse(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid version string: " + version);
        }
        int maj = Integer.parseInt(m.group("major"));
        int min = m.group("minor") != null ? Integer.parseInt(m.group("minor")) : 0;
        int pat = m.group("patch") != null ? Integer.parseInt(m.group("patch")) : 0;
        String pre = m.group("pre");
        String build = m.group("build");
        return new Version(maj, min, pat, pre, build);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public String getBuildMetadata() {
        return this.buildMetadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.preRelease != null) {
            sb.append('-').append(this.preRelease);
        }
        if (this.buildMetadata != null) {
            sb.append('+').append(this.buildMetadata);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] examples;
        for (String ver : examples = new String[]{"1.2.3", "2.0", "3", "4.5.6-RC1", "7.8-SNAPSHOT+exp.sha.5114f85", "10.0.1+001"}) {
            Version v = Version.parse(ver);
            System.out.println("Parsed \u201c" + ver + "\u201d \u2192 major=" + v.getMajor() + ", minor=" + v.getMinor() + ", patch=" + v.getPatch() + ", preRelease=" + v.getPreRelease() + ", buildMetadata=" + v.getBuildMetadata());
        }
    }
}

