/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import icy.image.colormap.IcyColorMap;
import icy.image.lut.LUT;
import icy.math.Scaler;
import icy.vtk.VtkCPUVolumeMapper;
import vtk.vtkAbstractVolumeMapper;
import vtk.vtkColorTransferFunction;
import vtk.vtkGPUVolumeRayCastMapper;
import vtk.vtkImageData;
import vtk.vtkOpenGLGPUVolumeRayCastMapper;
import vtk.vtkPiecewiseFunction;
import vtk.vtkRenderer;
import vtk.vtkVolume;
import vtk.vtkVolumeMapper;
import vtk.vtkVolumeProperty;

public class VtkImageVolume {
    protected vtkVolumeMapper volumeMapper;
    protected vtkVolume volume;
    protected vtkVolumeProperty volumeProperty = new vtkVolumeProperty();
    protected vtkImageData imageData;
    protected vtkRenderer renderer;

    public VtkImageVolume() {
        this.volumeProperty.IndependentComponentsOn();
        this.volumeProperty.DisableGradientOpacityOn();
        this.setShade(false);
        this.setAmbient(0.5);
        this.setDiffuse(0.4);
        this.setSpecular(0.4);
        this.setInterpolationMode(1);
        this.volumeMapper = new VtkCPUVolumeMapper();
        this.setSampleResolution(0.0);
        this.volume = new vtkVolume();
        this.volume.SetProperty(this.volumeProperty);
        this.volume.SetMapper((vtkAbstractVolumeMapper)this.volumeMapper);
        this.volume.SetPickable(0);
        this.imageData = null;
    }

    public void release() {
        this.volume.Delete();
        this.volumeMapper.RemoveAllInputs();
        this.volumeMapper.Delete();
        this.volumeProperty.Delete();
        if (this.imageData != null) {
            this.imageData.GetPointData().GetScalars().Delete();
            this.imageData.GetPointData().Delete();
            this.imageData.Delete();
        }
        this.volume = null;
        this.volumeMapper = null;
        this.volumeProperty = null;
        this.imageData = null;
    }

    public vtkVolume getVolume() {
        return this.volume;
    }

    protected int getChannelCount() {
        if (this.imageData != null) {
            return this.imageData.GetNumberOfScalarComponents();
        }
        return 1;
    }

    public void setColorMap(vtkColorTransferFunction map, int channel) {
        vtkColorTransferFunction oldMap = this.volumeProperty.GetRGBTransferFunction(channel);
        if (this.volumeProperty.GetRGBTransferFunction() == oldMap) {
            oldMap = null;
        }
        this.volumeProperty.SetColor(channel, map);
        if (oldMap != null) {
            oldMap.Delete();
        }
    }

    public void setOpacityMap(vtkPiecewiseFunction map, int channel) {
        vtkPiecewiseFunction oldMap = this.volumeProperty.GetScalarOpacity(channel);
        if (this.volumeProperty.GetScalarOpacity() == oldMap) {
            oldMap = null;
        }
        this.volumeProperty.SetScalarOpacity(channel, map);
        if (oldMap != null) {
            oldMap.Delete();
        }
    }

    public void setLUT(LUT value) {
        int channel = 0;
        while (channel < Math.min(value.getNumChannel(), this.getChannelCount())) {
            this.setLUT(value.getLutChannel(channel), channel);
            ++channel;
        }
    }

    public void setLUT(LUT.LUTChannel lutChannel, int channel) {
        int i;
        IcyColorMap colorMap = lutChannel.getColorMap();
        Scaler scaler = lutChannel.getScaler();
        vtkColorTransferFunction newColorMap = new vtkColorTransferFunction();
        newColorMap.SetRange(scaler.getLeftIn(), scaler.getRightIn());
        int i2 = 0;
        while (i2 < 256) {
            newColorMap.AddRGBPoint(scaler.unscale(i2), (double)colorMap.getNormalizedRed(i2), (double)colorMap.getNormalizedGreen(i2), (double)colorMap.getNormalizedBlue(i2));
            ++i2;
        }
        vtkColorTransferFunction oldColorMap = this.volumeProperty.GetRGBTransferFunction(channel);
        if (this.volumeProperty.GetRGBTransferFunction() == oldColorMap) {
            oldColorMap = null;
        }
        this.volumeProperty.SetColor(channel, newColorMap);
        if (oldColorMap != null) {
            oldColorMap.Delete();
        }
        vtkPiecewiseFunction newOpacity = new vtkPiecewiseFunction();
        if (colorMap.isEnabled()) {
            i = 0;
            while (i < 256) {
                newOpacity.AddPoint(scaler.unscale(i), (double)colorMap.getNormalizedAlpha(i));
                ++i;
            }
        } else {
            i = 0;
            while (i < 256) {
                newOpacity.AddPoint(scaler.unscale(i), 0.0);
                ++i;
            }
        }
        vtkPiecewiseFunction oldOpacity = this.volumeProperty.GetScalarOpacity(channel);
        if (this.volumeProperty.GetScalarOpacity() == oldOpacity) {
            oldOpacity = null;
        }
        this.volumeProperty.SetScalarOpacity(channel, newOpacity);
        if (oldOpacity != null) {
            oldOpacity.Delete();
        }
    }

    public double getSampleResolution() {
        if (this.volumeMapper instanceof VtkCPUVolumeMapper) {
            VtkCPUVolumeMapper mapper = (VtkCPUVolumeMapper)this.volumeMapper;
            if (mapper.GetAutoAdjustSampleDistances() != 0) {
                return 0.0;
            }
            return mapper.GetImageSampleDistance();
        }
        if (this.volumeMapper instanceof vtkGPUVolumeRayCastMapper) {
            vtkGPUVolumeRayCastMapper mapper = (vtkGPUVolumeRayCastMapper)this.volumeMapper;
            if (mapper.GetAutoAdjustSampleDistances() != 0) {
                return 0.0;
            }
            return mapper.GetImageSampleDistance();
        }
        if (this.volumeMapper instanceof vtkOpenGLGPUVolumeRayCastMapper) {
            vtkOpenGLGPUVolumeRayCastMapper mapper = (vtkOpenGLGPUVolumeRayCastMapper)this.volumeMapper;
            if (mapper.GetAutoAdjustSampleDistances() != 0) {
                return 0.0;
            }
            return mapper.GetImageSampleDistance();
        }
        return 0.0;
    }

    public void setSampleResolution(double value) {
        if (this.volumeMapper instanceof VtkCPUVolumeMapper) {
            VtkCPUVolumeMapper mapper = (VtkCPUVolumeMapper)this.volumeMapper;
            if (value == 0.0) {
                mapper.AutoAdjustSampleDistancesOn();
            } else {
                mapper.AutoAdjustSampleDistancesOff();
                mapper.SetImageSampleDistance((float)value);
            }
        } else if (this.volumeMapper instanceof vtkGPUVolumeRayCastMapper) {
            vtkGPUVolumeRayCastMapper mapper = (vtkGPUVolumeRayCastMapper)this.volumeMapper;
            if (value == 0.0) {
                mapper.AutoAdjustSampleDistancesOn();
            } else {
                mapper.AutoAdjustSampleDistancesOff();
                mapper.SetImageSampleDistance((float)value);
            }
        } else if (this.volumeMapper instanceof vtkOpenGLGPUVolumeRayCastMapper) {
            vtkOpenGLGPUVolumeRayCastMapper mapper = (vtkOpenGLGPUVolumeRayCastMapper)this.volumeMapper;
            if (value == 0.0) {
                mapper.AutoAdjustSampleDistancesOn();
            } else {
                mapper.AutoAdjustSampleDistancesOff();
                mapper.SetImageSampleDistance((float)value);
            }
        }
    }

    public boolean isPickable() {
        return this.volume.GetPickable() != 0;
    }

    public void setPickable(boolean value) {
        this.volume.SetPickable(value ? 1 : 0);
    }

    public double[] getScale() {
        return this.volume.GetScale();
    }

    public void setScale(double x, double y, double z) {
        this.volume.SetScale(x, y, z);
    }

    public void setScale(double[] xyz) {
        this.volume.SetScale(xyz);
    }

    public boolean getShade() {
        return this.volumeProperty.GetShade() == 1;
    }

    public void setShade(boolean value) {
        int num = this.getChannelCount();
        int ch = 0;
        while (ch < num) {
            this.volumeProperty.SetShade(ch, value ? 1 : 0);
            ++ch;
        }
        this.volumeProperty.SetShade(value ? 1 : 0);
    }

    public double getAmbient() {
        return this.volumeProperty.GetAmbient();
    }

    public void setAmbient(double value) {
        int num = this.getChannelCount();
        int ch = 0;
        while (ch < num) {
            this.volumeProperty.SetAmbient(ch, value);
            ++ch;
        }
        this.volumeProperty.SetAmbient(value);
    }

    public double getDiffuse() {
        return this.volumeProperty.GetDiffuse();
    }

    public void setDiffuse(double value) {
        int num = this.getChannelCount();
        int ch = 0;
        while (ch < num) {
            this.volumeProperty.SetDiffuse(ch, value);
            ++ch;
        }
        this.volumeProperty.SetDiffuse(value);
    }

    public double getSpecular() {
        return this.volumeProperty.GetSpecular();
    }

    public void setSpecular(double value) {
        int num = this.getChannelCount();
        int ch = 0;
        while (ch < num) {
            this.volumeProperty.SetSpecular(ch, value);
            ++ch;
        }
        this.volumeProperty.SetSpecular(value);
    }

    public double getSpecularPower() {
        return this.volumeProperty.GetSpecularPower();
    }

    public void setSpecularPower(double value) {
        int num = this.getChannelCount();
        int ch = 0;
        while (ch < num) {
            this.volumeProperty.SetSpecularPower(ch, value);
            ++ch;
        }
        this.volumeProperty.SetSpecularPower(value);
    }

    public int getInterpolationMode() {
        return this.volumeProperty.GetInterpolationType();
    }

    public void setInterpolationMode(int value) {
        this.volumeProperty.SetInterpolationType(value);
    }

    public boolean getGPURendering() {
        return this.volumeMapper instanceof vtkOpenGLGPUVolumeRayCastMapper;
    }

    public boolean setGPURendering(boolean value) {
        if (this.getGPURendering() != value) {
            VtkVolumeBlendType blendingMode = this.getBlendingMode();
            double sampleResolution = this.getSampleResolution();
            Object newMapper = value ? new vtkOpenGLGPUVolumeRayCastMapper() : new VtkCPUVolumeMapper();
            this.volume.SetMapper((vtkAbstractVolumeMapper)newMapper);
            if (this.volumeMapper != null) {
                this.volumeMapper.RemoveAllInputs();
                this.volumeMapper.Delete();
            }
            this.volumeMapper = newMapper;
            if (this.imageData != null) {
                newMapper.SetInputData(this.imageData);
            }
            this.setBlendingMode(blendingMode);
            this.setSampleResolution(sampleResolution);
            return true;
        }
        return false;
    }

    public VtkVolumeBlendType getBlendingMode() {
        return VtkVolumeBlendType.values()[this.volumeMapper.GetBlendMode()];
    }

    public void setBlendingMode(VtkVolumeBlendType value) {
        this.volumeMapper.SetBlendMode(value.ordinal());
    }

    public vtkImageData getVolumeData() {
        return this.imageData;
    }

    public void setVolumeData(vtkImageData data) {
        if (this.imageData != data) {
            this.volumeMapper.SetInputData(data);
            if (this.imageData != null) {
                this.imageData.GetPointData().GetScalars().Delete();
                this.imageData.GetPointData().Delete();
                this.imageData.Delete();
            }
            this.imageData = data;
        }
        this.updateChannelProperties();
    }

    protected void updateChannelProperties() {
        this.setShade(this.getShade());
        this.setAmbient(this.getAmbient());
        this.setDiffuse(this.getDiffuse());
        this.setSpecular(this.getSpecular());
        this.setSpecularPower(this.getSpecularPower());
    }

    public void setVisible(boolean value) {
        this.volume.SetVisibility(value ? 1 : 0);
    }

    public boolean isVisible() {
        return this.volume.GetVisibility() != 0;
    }

    public static enum VtkVolumeBlendType {
        COMPOSITE{

            public String toString() {
                return "Composite";
            }
        }
        ,
        MAXIMUM_INTENSITY{

            public String toString() {
                return "Maximum intensity";
            }
        }
        ,
        MINIMUM_INTENSITY{

            public String toString() {
                return "Minimum intensity";
            }
        }
        ,
        ADDITIVE{

            public String toString() {
                return "Additive";
            }
        };

    }
}

