/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.system;

import io.bioimage.modelrunner.system.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PlatformDetection {
    public static final String OS_WINDOWS = "windows";
    public static final String OS_OSX = "macosx";
    public static final String OS_LINUX = "linux";
    public static final String ARCH_PPC64LE = "ppc64le";
    public static final String ARCH_X86_32 = "x86";
    public static final String ARCH_X86_64 = "x86_64";
    public static final String ARCH_S390X = "s390x";
    public static final String ARCH_AARCH64 = "aarch64";
    public static final String ARCH_ARM64 = "arm64";
    public static final Map<String, String> archMap;
    private static String DETECT_CHIP_TERMINAL_COMMAND;
    private static String PYTHON_ARCH_DETECTION_COMMAND;
    private static String UNAME_M;
    private static String OS;
    private static String ARCH;
    private static boolean ROSETTA;
    private static Integer JAVA_VERSION;

    public static String getOs() {
        if (OS != null) {
            return OS;
        }
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            OS = OS_WINDOWS;
        } else if (System.getProperty("os.name").toLowerCase().replace(" ", "").contains(OS_OSX)) {
            OS = OS_OSX;
        } else if (System.getProperty("os.name").toLowerCase().contains(OS_LINUX) || System.getProperty("os.name").toLowerCase().endsWith("ix")) {
            OS = OS_LINUX;
        } else {
            throw new IllegalArgumentException("Operating system not supported by Miniconda: " + System.getProperty("os.name") + ". Only supported OS are: " + OS_WINDOWS + ", " + OS_OSX + " and " + OS_LINUX);
        }
        return OS;
    }

    public static String getArch() {
        if (ARCH != null) {
            return ARCH;
        }
        ARCH = archMap.get(System.getProperty("os.arch"));
        if (ARCH == null) {
            throw new IllegalArgumentException("Unknown architecture " + System.getProperty("os.arch"));
        }
        if (ARCH.equals(ARCH_X86_64) && !PlatformDetection.getOs().equals(OS_WINDOWS)) {
            try {
                Process proc = Runtime.getRuntime().exec(new String[]{"bash", "-c", DETECT_CHIP_TERMINAL_COMMAND});
                String txt = PlatformDetection.waitProcessExecutionAndGetOutputText(proc);
                if (txt.toLowerCase().contains("apple m")) {
                    ROSETTA = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Error checking the chip architecture with bash");
            }
        }
        return ARCH;
    }

    public static boolean isUsingRosseta() {
        if (ARCH == null) {
            PlatformDetection.getArch();
        }
        return ROSETTA;
    }

    public String toString() {
        if (OS == null) {
            PlatformDetection.getOs();
        }
        if (ARCH == null) {
            PlatformDetection.getArch();
        }
        return OS + "-" + ARCH;
    }

    public static boolean isWindows() {
        return PlatformDetection.getOs().equals(OS_WINDOWS);
    }

    public static boolean isLinux() {
        return PlatformDetection.getOs().equals(OS_LINUX);
    }

    public static boolean isMacOS() {
        return PlatformDetection.getOs().equals(OS_OSX);
    }

    private static String waitProcessExecutionAndGetOutputText(Process proc) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String inputStreamTxt = "";
        boolean first = true;
        while (proc.isAlive() || first) {
            first = false;
            try {
                String txtAux1 = PlatformDetection.readBufferedReaderIntoStringIntoString(bufferedReader);
                inputStreamTxt = inputStreamTxt + txtAux1;
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrumped process");
            }
        }
        bufferedReader.close();
        return inputStreamTxt;
    }

    private static String readBufferedReaderIntoStringIntoString(BufferedReader input) throws IOException {
        String line;
        String text = "";
        while ((line = input.readLine()) != null) {
            text = text + line + System.lineSeparator();
        }
        return text;
    }

    public static Version getOSVersion() {
        return Version.parse(System.getProperty("os.version"));
    }

    public static int getJavaVersion() {
        if (JAVA_VERSION != null) {
            return JAVA_VERSION;
        }
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        JAVA_VERSION = Integer.parseInt(version);
        return JAVA_VERSION;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("os.version"));
    }

    static {
        HashMap<String, String> architectures = new HashMap<String, String>();
        architectures.put(ARCH_X86_32, ARCH_X86_32);
        architectures.put("i386", ARCH_X86_32);
        architectures.put("i486", ARCH_X86_32);
        architectures.put("i586", ARCH_X86_32);
        architectures.put("i686", ARCH_X86_32);
        architectures.put(ARCH_X86_64, ARCH_X86_64);
        architectures.put("amd64", ARCH_X86_64);
        architectures.put(ARCH_PPC64LE, ARCH_PPC64LE);
        architectures.put(ARCH_S390X, ARCH_S390X);
        architectures.put(ARCH_ARM64, ARCH_ARM64);
        architectures.put(ARCH_AARCH64, ARCH_ARM64);
        archMap = Collections.unmodifiableMap(architectures);
        DETECT_CHIP_TERMINAL_COMMAND = "sysctl -n machdep.cpu.brand_string";
        PYTHON_ARCH_DETECTION_COMMAND = "\"import platform; print(platform.machine())\"";
        ROSETTA = false;
    }
}

