/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin.classloader;

import icy.file.FileUtil;
import icy.network.NetworkUtil;
import icy.plugin.classloader.Configuration;
import icy.plugin.classloader.JarResources;
import icy.plugin.classloader.exception.JclException;
import icy.plugin.classloader.exception.ResourceNotFoundException;
import icy.system.IcyExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClasspathResources
extends JarResources {
    private static Logger logger = Logger.getLogger(ClasspathResources.class.getName());
    private boolean ignoreMissingResources = Configuration.suppressMissingResourceException();

    protected void loadRemoteResource(URL url) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Attempting to load a remote resource.");
        }
        if (url.toString().toLowerCase().endsWith(".jar")) {
            try {
                this.loadJar(url);
            }
            catch (IOException e) {
                System.err.println("JarResources.loadJar(" + url + ") error:");
                IcyExceptionHandler.showErrorMessage(e, false, true);
            }
            return;
        }
        if (this.entryUrls.containsKey(url.toString())) {
            if (!this.collisionAllowed) {
                throw new JclException("Resource " + url.toString() + " already loaded");
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Resource " + url.toString() + " already loaded; ignoring entry...");
            }
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Loading remote resource.");
        }
        this.entryUrls.put(url.toString(), url);
    }

    protected byte[] loadRemoteResourceContent(URL url) throws IOException {
        byte[] result = NetworkUtil.download(url.openStream());
        if (result != null) {
            this.loadedSize += result.length;
        }
        return result;
    }

    protected void loadResource(URL url) {
        try {
            File file = new File(url.toURI());
            this.loadResource(file, FileUtil.getGenericPath(file.getAbsolutePath()));
        }
        catch (IllegalArgumentException iae) {
            this.loadRemoteResource(url);
        }
        catch (URISyntaxException e) {
            throw new JclException("URISyntaxException", e);
        }
    }

    protected void loadResource(String path) {
        File fp;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Resource: " + path);
        }
        if (!(fp = new File(path)).exists() && !this.ignoreMissingResources) {
            throw new JclException("File/Path does not exist");
        }
        this.loadResource(fp, FileUtil.getGenericPath(path));
    }

    protected void loadResource(File fol, String packName) {
        if (fol.isFile()) {
            if (fol.getName().toLowerCase().endsWith(".jar")) {
                try {
                    this.loadJar(fol.toURI().toURL());
                }
                catch (IOException e) {
                    System.err.println("JarResources.loadJar(" + fol.getAbsolutePath() + ") error:");
                    IcyExceptionHandler.showErrorMessage(e, false, true);
                }
            } else {
                this.loadResourceInternal(fol, packName);
            }
        } else if (fol.list() != null) {
            String[] stringArray = fol.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                File fl = new File(String.valueOf(fol.getAbsolutePath()) + "/" + f);
                String pn = packName;
                if (fl.isDirectory()) {
                    if (!pn.equals("")) {
                        pn = String.valueOf(pn) + "/";
                    }
                    pn = String.valueOf(pn) + fl.getName();
                }
                this.loadResource(fl, pn);
                ++n2;
            }
        }
    }

    protected void loadResourceInternal(File file, String pack) {
        String entryName = "";
        if (pack.length() > 0) {
            entryName = String.valueOf(pack) + "/";
        }
        if (this.entryUrls.containsKey(entryName = String.valueOf(entryName) + file.getName())) {
            if (!this.collisionAllowed) {
                throw new JclException("Resource " + entryName + " already loaded");
            }
            if (logger.isLoggable(Level.WARNING)) {
                logger.finest("Resource " + entryName + " already loaded; ignoring entry...");
            }
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Loading resource: " + entryName);
        }
        try {
            this.entryUrls.put(entryName, file.toURI().toURL());
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.finest("Error while loading: " + entryName);
            }
            System.err.println("JarResources.loadResourceInternal(" + file.getAbsolutePath() + ") error:");
            IcyExceptionHandler.showErrorMessage(e, false, true);
        }
    }

    @Override
    protected void loadContent(String name, URL url) throws IOException {
        if (url.getProtocol().equalsIgnoreCase("jar")) {
            super.loadContent(name, url);
        } else if (url.getProtocol().equalsIgnoreCase("file")) {
            byte[] content = this.loadResourceContent(url);
            this.setResourceContent(name, content);
        } else {
            byte[] content = this.loadRemoteResourceContent(url);
            this.setResourceContent(name, content);
        }
    }

    protected byte[] loadResourceContent(URL url) throws IOException {
        byte[] result = NetworkUtil.download(url.openStream());
        if (result != null) {
            this.loadedSize += result.length;
        }
        return result;
    }

    public void unload(String resource) {
        if (this.entryContents.containsKey(resource)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Removing resource " + resource);
            }
        } else {
            throw new ResourceNotFoundException(resource, "Resource not found in local ClasspathResources");
        }
        this.entryContents.remove(resource);
    }

    public boolean isCollisionAllowed() {
        return this.collisionAllowed;
    }

    public void setCollisionAllowed(boolean collisionAllowed) {
        this.collisionAllowed = collisionAllowed;
    }

    public boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }
}

