/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.download;

import io.bioimage.modelrunner.utils.CommonUtils;
import io.bioimage.modelrunner.versionmanagement.JarInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class FileDownloader {
    private final URL website;
    private final File file;
    private final boolean printProgress;
    private final String name;
    private Long fileSize;
    private AtomicLong sizeDownloaded = new AtomicLong(0L);
    private int lost_conn = 0;
    private long already = 0L;
    private boolean complete = false;
    private Consumer<Long> totalProgress;
    private Consumer<Double> partialProgress;
    private static final long CHUNK_SIZE = 0x100000L;
    private static final int STALL_THRES = 10000;
    private static final int PROGRESS_INTER = 1000;
    private static final int MAX_RETRIES = 3;

    public FileDownloader(String url, File file, boolean printProgress) throws MalformedURLException {
        this.website = new URL(url);
        this.file = file;
        this.printProgress = printProgress;
        this.name = FileDownloader.getFileNameFromURLString(url);
    }

    public FileDownloader(String url, File file) throws MalformedURLException {
        this(url, file, true);
    }

    public void setTotalProgressConsumer(Consumer<Long> totalProgress) {
        this.totalProgress = totalProgress;
    }

    public void setPartialProgressConsumer(Consumer<Double> partialProgress) {
        this.partialProgress = partialProgress;
    }

    public String getFileName() {
        return this.name;
    }

    public long getOnlineFileSize() {
        if (this.fileSize != null) {
            return this.fileSize;
        }
        try {
            JarInfo jarInfo = JarInfo.getInstance();
            if (jarInfo.get(this.website.toString()) != null) {
                this.fileSize = jarInfo.get(this.website.toString()).longValue();
                return this.fileSize;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileSize = FileDownloader.getFileSize(this.website);
        return this.fileSize;
    }

    public long getSizeDownloaded() {
        return this.sizeDownloaded.get();
    }

    public void download(Thread parentThread) throws IOException, ExecutionException {
        this.already = 0L;
        while (this.lost_conn < 3 && !this.complete && parentThread.isAlive()) {
            this.downloadAttempt(parentThread);
        }
        if (!this.complete) {
            throw new IOException("Unable to download file after 3 attempts.");
        }
    }

    private void downloadAttempt(Thread parentThread) throws IOException, ExecutionException {
        SSLContext sslContext;
        HttpsURLConnection conn = (HttpsURLConnection)this.website.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        if (this.already > 0L) {
            conn.setRequestProperty("Range", "bytes=" + this.already + "-");
        }
        try {
            sslContext = FileDownloader.getAllTrustingSSLContext();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        conn.setSSLSocketFactory(sslContext.getSocketFactory());
        try (InputStream str = conn.getInputStream();
             ReadableByteChannel rbc = Channels.newChannel(str);
             FileOutputStream fos = new FileOutputStream(this.file, this.already != 0L);){
            this.performDownload(fos, rbc, parentThread);
        }
        catch (SocketTimeoutException ex) {
            System.err.println("Socket timeout accessing: " + this.website);
            ++this.lost_conn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDownload(FileOutputStream fos, ReadableByteChannel rbc, Thread parentThread) throws ExecutionException {
        ExecutorService downloadExecutor = Executors.newSingleThreadExecutor();
        ScheduledExecutorService monitorExecutor = Executors.newScheduledThreadPool(2);
        this.getOnlineFileSize();
        Callable<Void> downloadTask = () -> {
            this.call(rbc, fos);
            return null;
        };
        Future<Void> downloadFuture = downloadExecutor.submit(downloadTask);
        long[] lastProgress = new long[]{this.already};
        Runnable stallDetectionTask = () -> {
            if (!parentThread.isAlive()) {
                downloadFuture.cancel(true);
                return;
            }
            long bytesDownloaded = this.file.length();
            if (bytesDownloaded == lastProgress[0]) {
                System.err.println("Connection lost. Time number: " + (this.lost_conn + 1));
                downloadFuture.cancel(true);
            } else {
                lastProgress[0] = bytesDownloaded;
            }
        };
        Runnable progressPrintTask = () -> {
            if (!parentThread.isAlive()) {
                downloadFuture.cancel(true);
                return;
            }
            long totalPro = this.file.length();
            double partialPro = (double)totalPro / (double)this.fileSize.longValue();
            if (this.printProgress) {
                System.out.println(FileDownloader.getStringToPrintProgress(this.file.getName(), partialPro));
            }
            if (this.totalProgress != null) {
                this.totalProgress.accept(totalPro);
            }
            if (this.partialProgress != null) {
                this.partialProgress.accept(partialPro);
            }
        };
        monitorExecutor.scheduleAtFixedRate(stallDetectionTask, 10000L, 10000L, TimeUnit.MILLISECONDS);
        monitorExecutor.scheduleAtFixedRate(progressPrintTask, 0L, 1000L, TimeUnit.MILLISECONDS);
        try {
            downloadFuture.get();
            this.complete = true;
        }
        catch (InterruptedException | CancellationException e) {
            ++this.lost_conn;
        }
        finally {
            downloadExecutor.shutdownNow();
            monitorExecutor.shutdownNow();
        }
        this.finalProgress();
    }

    private void finalProgress() {
        long totalPro = this.file.length();
        double partialPro = (double)totalPro / (double)this.fileSize.longValue();
        if (this.printProgress) {
            System.out.println(FileDownloader.getStringToPrintProgress(this.file.getName(), partialPro));
        }
        if (this.totalProgress != null) {
            this.totalProgress.accept(totalPro);
        }
        if (this.partialProgress != null) {
            this.partialProgress.accept(partialPro);
        }
    }

    public void download() throws IOException, ExecutionException {
        this.download(Thread.currentThread());
    }

    private void call(ReadableByteChannel rbc, FileOutputStream fos) throws IOException {
        long transferred;
        this.sizeDownloaded.set(this.already);
        while ((transferred = fos.getChannel().transferFrom(rbc, this.sizeDownloaded.get(), 0x100000L)) != 0L) {
            this.sizeDownloaded.set(this.sizeDownloaded.get() + transferred);
            if (!Thread.currentThread().isInterrupted()) continue;
            return;
        }
    }

    public static long getFileSize(URL url) {
        HttpsURLConnection conn = null;
        try {
            SSLContext sslContext = FileDownloader.getAllTrustingSSLContext();
            conn = (HttpsURLConnection)url.openConnection();
            conn.setSSLSocketFactory(sslContext.getSocketFactory());
            conn.setRequestProperty("User-Agent", CommonUtils.getJDLLUserAgent());
            if (conn.getResponseCode() >= 300 && conn.getResponseCode() <= 308) {
                return FileDownloader.getFileSize(FileDownloader.redirectedURL(url));
            }
            if (conn.getResponseCode() != 200) {
                throw new Exception("Unable to connect to: " + url);
            }
            long size = conn.getContentLengthLong();
            conn.disconnect();
            return size;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "Unable to connect to " + url.toString();
            System.out.println(msg);
            return 1L;
        }
    }

    private static SSLContext getAllTrustingSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return sslContext;
    }

    public static URL redirectedURL(URL url) throws MalformedURLException, URISyntaxException {
        int statusCode;
        HttpURLConnection conn;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", CommonUtils.getJDLLUserAgent());
            statusCode = conn.getResponseCode();
        }
        catch (IOException ex) {
            return url;
        }
        if (statusCode < 300 || statusCode > 308) {
            return url;
        }
        String newURL = conn.getHeaderField("Location");
        try {
            conn.disconnect();
            return FileDownloader.redirectedURL(new URL(newURL));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                conn.disconnect();
                if (newURL.startsWith("//")) {
                    return FileDownloader.redirectedURL(new URL("http:" + newURL));
                }
                throw new MalformedURLException();
            }
            catch (MalformedURLException malformedURLException2) {
                URI uri = url.toURI();
                String scheme = uri.getScheme();
                String host = uri.getHost();
                String mainDomain = scheme + "://" + host;
                conn.disconnect();
                return FileDownloader.redirectedURL(new URL(mainDomain + newURL));
            }
        }
    }

    public static String getFileNameFromURLString(String str) throws MalformedURLException {
        if (str.startsWith("https://zenodo.org/") && str.endsWith("/content")) {
            str = str.substring(0, str.length() - "/content".length());
        }
        URL url = new URL(str);
        return new File(url.getPath()).getName();
    }

    private static String getStringToPrintProgress(String kk, double progress) {
        int i;
        int n = 30;
        int nProgressBar = (int)(progress * (double)n);
        String progressStr = new File(kk).getName() + ": [";
        for (i = 0; i < nProgressBar; ++i) {
            progressStr = progressStr + "#";
        }
        for (i = nProgressBar; i < n; ++i) {
            progressStr = progressStr + ".";
        }
        progressStr = progressStr + "] " + Math.round(progress * 100.0) + "%";
        return progressStr;
    }
}

