/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import icy.gui.dialog.ConfirmDialog;
import icy.main.Icy;
import icy.math.UnitUtil;
import icy.plugin.abstract_.Plugin;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.util.BlockListener;
import plugins.adufour.blocks.util.BlocksException;
import plugins.adufour.blocks.util.LinkCutException;
import plugins.adufour.blocks.util.LoopException;
import plugins.adufour.blocks.util.NoSuchBlockException;
import plugins.adufour.blocks.util.NoSuchLinkException;
import plugins.adufour.blocks.util.NoSuchVariableException;
import plugins.adufour.blocks.util.ScopeException;
import plugins.adufour.blocks.util.StopException;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.blocks.util.VarListListener;
import plugins.adufour.blocks.util.WorkFlowListener;
import plugins.adufour.protocols.gui.MainFrame;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarObject;
import plugins.adufour.vars.util.VarException;

public class WorkFlow
extends Plugin
implements Block,
Iterable<BlockDescriptor>,
BlockListener,
WorkFlowListener {
    private final BlockDescriptor descriptor = new BlockDescriptor(-1, this);
    private final HashSet<WorkFlowListener> listeners = new HashSet();
    private final ArrayList<BlockDescriptor> orderedBlocks = new ArrayList();
    private final boolean topLevel;
    private final ArrayList<Link<?>> links = new ArrayList();
    private final VarListListener inputVarListener = new VarListListener(){

        @Override
        public void variableAdded(VarList list, Var<?> variable) {
            WorkFlow.this.descriptor.addInput(WorkFlow.this.getInputVarID(variable), variable);
        }

        @Override
        public void variableRemoved(VarList list, Var<?> variable) {
            WorkFlow.this.descriptor.removeInput(variable);
        }
    };
    private final VarListListener outputVarListener = new VarListListener(){

        @Override
        public void variableAdded(VarList list, Var<?> variable) {
            WorkFlow.this.descriptor.addOutput(WorkFlow.this.getOutputVarID(variable), variable);
        }

        @Override
        public void variableRemoved(VarList list, Var<?> variable) {
            WorkFlow.this.descriptor.removeOutput(variable);
        }
    };
    private Thread executionThread;
    private boolean userInterruption = false;
    private ArrayList<BlockDescriptor> blockSelection = new ArrayList();
    private ArrayList<Link<?>> linkSelection = new ArrayList();
    private static final OutputStream nullStream = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    private PrintStream logStream = new PrintStream(nullStream);

    public void setLogStream(PrintStream logStream) {
        this.logStream = logStream;
    }

    public PrintStream getLogStream() {
        return this.descriptor.getContainer() == null ? this.logStream : this.descriptor.getContainer().getLogStream();
    }

    public WorkFlow() {
        this(false);
    }

    public WorkFlow(boolean topLevel) {
        this.topLevel = topLevel;
    }

    public void addBlock(BlockDescriptor blockInfo) {
        blockInfo.setContainer(this);
        this.orderedBlocks.add(blockInfo);
        blockInfo.addBlockListener(this);
        if (blockInfo.isWorkFlow()) {
            ((WorkFlow)blockInfo.getBlock()).addListener(this);
        }
        if (!this.descriptor.isTopLevelWorkFlow()) {
            for (Var<?> inputVar : blockInfo.inputVars) {
                if (this.descriptor.inputVars.contains(inputVar)) continue;
                this.descriptor.addInput(this.getInputVarID(inputVar), inputVar);
            }
            for (Var<?> outputVar : blockInfo.outputVars) {
                if (this.descriptor.outputVars.contains(outputVar)) continue;
                this.descriptor.addOutput(this.getOutputVarID(outputVar), outputVar);
            }
            blockInfo.inputVars.addVarListListener(this.inputVarListener);
            blockInfo.outputVars.addVarListListener(this.outputVarListener);
        }
        this.blockAdded(this, blockInfo);
    }

    @Deprecated
    public BlockDescriptor addBlock(Block block) {
        return this.addBlock(-1, block, new Point());
    }

    @Deprecated
    public BlockDescriptor addBlock(int ID, Block block, Point location) {
        BlockDescriptor blockDescriptor;
        if (block instanceof WorkFlow) {
            blockDescriptor = ((WorkFlow)block).descriptor;
            blockDescriptor.setContainer(this);
            blockDescriptor.setLocation(location.x, location.y);
        } else {
            blockDescriptor = new BlockDescriptor(ID, block, this, location);
        }
        this.addBlock(blockDescriptor);
        return blockDescriptor;
    }

    public <T> Link<T> addLink(BlockDescriptor srcBlock, String srcArgID, BlockDescriptor dstBlock, String dstArgID) throws NoSuchBlockException, NoSuchVariableException, ClassCastException {
        if (!this.orderedBlocks.contains(srcBlock)) {
            throw new NoSuchBlockException(srcBlock);
        }
        if (!this.orderedBlocks.contains(dstBlock)) {
            throw new NoSuchBlockException(dstBlock);
        }
        Var srcVar = srcBlock.outputVars.get(srcArgID);
        if (srcVar == null) {
            throw new NoSuchVariableException(srcBlock, srcArgID);
        }
        Var dstVar = dstBlock.inputVars.get(dstArgID);
        if (dstVar == null) {
            throw new NoSuchVariableException(dstBlock, dstArgID);
        }
        return this.addLink(srcBlock, srcVar, dstBlock, dstVar);
    }

    public <T> Link<T> addLink(BlockDescriptor srcBlock, Var<T> srcVar, BlockDescriptor dstBlock, Var<T> dstVar) throws LoopException, ClassCastException {
        Link<T> link = this.checkLink(srcBlock, srcVar, dstBlock, dstVar);
        dstVar.setReference(srcVar);
        if (this.orderedBlocks.indexOf(link.srcBlock) > this.orderedBlocks.indexOf(link.dstBlock)) {
            this.reOrder(link.srcBlock, link.dstBlock);
        }
        this.links.add(link);
        for (WorkFlowListener listener : this.listeners) {
            listener.linkAdded(this, link);
        }
        return link;
    }

    public void addListener(WorkFlowListener listener) {
        this.listeners.add(listener);
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public boolean contains(BlockDescriptor dstBlock) {
        return this.orderedBlocks.contains(dstBlock);
    }

    public <T> Link<T> checkLink(BlockDescriptor srcBlock, Var<T> srcVar, BlockDescriptor dstBlock, Var<T> dstVar) throws ClassCastException {
        Link<T> link = new Link<T>(this, srcBlock, srcVar, dstBlock, dstVar);
        this.checkScope(link);
        this.checkLoop(link);
        this.checkType(link);
        return link;
    }

    protected <T> void checkScope(Link<T> link) throws ScopeException {
        if (this.contains(link.srcBlock) != this.contains(link.dstBlock)) {
            throw new ScopeException();
        }
        if (link.srcBlock.isLoop() && ((Loop)link.srcBlock.getBlock()).isLoopVariable(link.srcVar)) {
            throw new ScopeException();
        }
    }

    protected <T> void checkLoop(Link<T> link) throws LoopException {
        if (link.srcBlock.equals(link.dstBlock) || this.depends(link.srcBlock, link.dstBlock)) {
            throw new LoopException();
        }
    }

    protected <T> void checkType(Link<T> link) throws ClassCastException {
        if (link.dstVar.isAssignableFrom(link.srcVar)) {
            return;
        }
        if (link.srcVar instanceof VarObject) {
            return;
        }
        if (link.dstVar instanceof VarMutable) {
            return;
        }
        throw new ClassCastException("<html><h4>Variables \"" + link.dstVar.getName() + "\" and \"" + link.srcVar.getName() + "\" are of different type and cannot be linked</h4></html>");
    }

    @Override
    public void declareInput(VarList inputMap) {
    }

    @Override
    public void declareOutput(VarList outputMap) {
    }

    private boolean depends(BlockDescriptor srcBlock, BlockDescriptor dstBlock) {
        boolean srcDependsOnDst = false;
        for (Link<?> link : this.links) {
            if (link.dstBlock != srcBlock) continue;
            if (link.srcBlock == dstBlock) {
                return true;
            }
            if (!(srcDependsOnDst |= this.depends(link.srcBlock, dstBlock))) continue;
            return true;
        }
        return srcDependsOnDst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockDescriptor> getBlockDescriptors(boolean recursive) {
        ArrayList<BlockDescriptor> result = new ArrayList<BlockDescriptor>();
        ArrayList<BlockDescriptor> arrayList = this.orderedBlocks;
        synchronized (arrayList) {
            for (BlockDescriptor block : this.orderedBlocks) {
                if (recursive && block.isWorkFlow()) {
                    result.addAll(((WorkFlow)block.getBlock()).getBlockDescriptors(true));
                }
                result.add(block);
            }
        }
        return result;
    }

    public List<BlockDescriptor> getInputBlockDescriptors(boolean recursive) {
        ArrayList<BlockDescriptor> result = new ArrayList<BlockDescriptor>();
        for (BlockDescriptor block : this.getBlockDescriptors(recursive)) {
            if (!block.isInput()) continue;
            result.add(block);
        }
        return result;
    }

    public List<BlockDescriptor> getOutputBlockDescriptors(boolean recursive) {
        ArrayList<BlockDescriptor> result = new ArrayList<BlockDescriptor>();
        for (BlockDescriptor block : this.getBlockDescriptors(recursive)) {
            if (!block.isOutput()) continue;
            result.add(block);
        }
        return result;
    }

    public BlockDescriptor getBlock(int index) {
        return this.orderedBlocks.get(index);
    }

    public BlockDescriptor getBlockByID(int blockID) throws NoSuchBlockException {
        if (blockID == this.descriptor.getID()) {
            return this.descriptor;
        }
        for (BlockDescriptor bd : this.orderedBlocks) {
            if (bd.getID() != blockID) continue;
            return bd;
        }
        throw new NoSuchBlockException(blockID, this);
    }

    public String getInputVarID(Var<?> variable) {
        BlockDescriptor owner = this.getInputOwner(variable);
        return owner.getID() + ":" + owner.getVarID(variable);
    }

    public String getOutputVarID(Var<?> variable) {
        BlockDescriptor owner = this.getOutputOwner(variable);
        return owner.getID() + ":" + owner.getVarID(variable);
    }

    public BlockDescriptor getBlockDescriptor() {
        return this.descriptor;
    }

    public BlockDescriptor getInputOwner(Var<?> var) {
        for (BlockDescriptor blockInfo : this.orderedBlocks) {
            for (Var<?> inputVar : blockInfo.inputVars) {
                if (!inputVar.equals(var)) continue;
                return blockInfo;
            }
        }
        return null;
    }

    public BlockDescriptor getOutputOwner(Var<?> var) {
        for (BlockDescriptor blockInfo : this.orderedBlocks) {
            for (Var<?> outputVar : blockInfo.outputVars) {
                if (!outputVar.equals(var)) continue;
                return blockInfo;
            }
        }
        return null;
    }

    public Iterable<Link<?>> getLinksIterator() {
        return new Iterable<Link<?>>(){

            @Override
            public Iterator<Link<?>> iterator() {
                return WorkFlow.this.links.iterator();
            }
        };
    }

    public int indexOf(BlockDescriptor blockInfo) {
        if (blockInfo == null) {
            return -1;
        }
        return this.orderedBlocks.indexOf(blockInfo);
    }

    @Override
    public Iterator<BlockDescriptor> iterator() {
        return new Iterator<BlockDescriptor>(){
            private final Iterator<BlockDescriptor> orderedBlocksIt;
            {
                this.orderedBlocksIt = WorkFlow.this.orderedBlocks.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.orderedBlocksIt.hasNext();
            }

            @Override
            public BlockDescriptor next() {
                return this.orderedBlocksIt.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void prioritize(BlockDescriptor blockDesc) {
        int currentOrder = this.indexOf(blockDesc);
        int targetOrder = 0;
        HashSet<BlockDescriptor> dependencies = new HashSet<BlockDescriptor>();
        for (Link<?> link : this.links) {
            if (link.dstBlock != blockDesc || !this.contains(link.srcBlock)) continue;
            dependencies.add(link.srcBlock);
        }
        for (BlockDescriptor dependency : dependencies) {
            this.prioritize(dependency);
        }
        for (BlockDescriptor dependency : dependencies) {
            int order = this.indexOf(dependency) + 1;
            if (order <= targetOrder) continue;
            targetOrder = order;
        }
        if (targetOrder != currentOrder) {
            this.orderedBlocks.add(targetOrder, this.orderedBlocks.remove(currentOrder));
            for (WorkFlowListener listener : this.listeners) {
                listener.workFlowReordered(this);
            }
        }
    }

    private void reOrder(BlockDescriptor prevBlock, BlockDescriptor nextBlock) {
        this.orderedBlocks.remove(prevBlock);
        this.orderedBlocks.add(this.orderedBlocks.indexOf(nextBlock), prevBlock);
        for (Link<?> link : this.links) {
            if (link.dstBlock != prevBlock || this.orderedBlocks.indexOf(link.srcBlock) <= this.orderedBlocks.indexOf(prevBlock)) continue;
            this.reOrder(link.srcBlock, prevBlock);
            break;
        }
        for (WorkFlowListener listener : this.listeners) {
            listener.workFlowReordered(this);
        }
    }

    public void removeBlock(BlockDescriptor blockInfo, boolean checkSelection) {
        Link<?> link;
        int i;
        if (blockInfo.getBlock() instanceof WorkFlow) {
            WorkFlow wf = (WorkFlow)blockInfo.getBlock();
            if (checkSelection && !wf.getBlockSelection().isEmpty()) {
                try {
                    for (BlockDescriptor bd : wf) {
                        Point contLoc = bd.getContainer().getBlockDescriptor().getLocation();
                        Point loc = bd.getLocation();
                        bd.setLocation(contLoc.x + loc.x, contLoc.y + loc.y);
                    }
                    MainFrame.copySelection(wf, true);
                    MainFrame.pasteSelection(this, true);
                }
                catch (LinkCutException e) {
                    if (ConfirmDialog.confirm("Warning", e.getMessage(), 2)) {
                        MainFrame.pasteSelection(this, true);
                    }
                    return;
                }
            } else {
                checkSelection = false;
            }
        }
        for (i = 0; i < this.links.size(); ++i) {
            link = this.links.get(i);
            if (blockInfo != link.srcBlock) continue;
            link.dstVar.setReference(null);
            this.links.remove(i--);
            for (WorkFlowListener listener : this.listeners) {
                listener.linkRemoved(this, link);
            }
        }
        for (i = 0; i < this.links.size(); ++i) {
            link = this.links.get(i);
            if (blockInfo != link.dstBlock) continue;
            link.dstVar.setReference(null);
            this.links.remove(i--);
            for (WorkFlowListener listener : this.listeners) {
                listener.linkRemoved(this, link);
            }
        }
        if (!blockInfo.isWorkFlow()) {
            for (Var<?> inputVar : blockInfo.inputVars) {
                this.descriptor.removeInput(inputVar);
            }
            for (Var<?> outputVar : blockInfo.outputVars) {
                this.descriptor.removeOutput(outputVar);
            }
        }
        this.orderedBlocks.remove(blockInfo);
        blockInfo.removeBlockListener(this);
        for (WorkFlowListener listener : this.listeners) {
            listener.blockRemoved(this, blockInfo);
            listener.workFlowReordered(this);
        }
        blockInfo.inputVars.removeVarListListener(this.inputVarListener);
        blockInfo.outputVars.removeVarListListener(this.outputVarListener);
        this.blockSelection.remove(blockInfo);
    }

    public boolean isLinked(Var<?> var) {
        for (Link<?> link : this.links) {
            if (link.dstVar != var && link.srcVar != var) continue;
            return true;
        }
        return false;
    }

    public void removeLink(Var<?> dstVar) {
        for (Link<?> link : this.links) {
            if (link.dstVar != dstVar || !this.links.remove(link)) continue;
            link.dstVar.setReference(null);
            for (WorkFlowListener listener : this.listeners) {
                listener.linkRemoved(this, link);
            }
            return;
        }
        if (this.descriptor.getContainer() == null) {
            throw new NoSuchLinkException("In method WorkFlow.removeLink():\nNo link points to " + this.getInputOwner(dstVar).getName() + " > " + dstVar.getName());
        }
        this.descriptor.getContainer().removeLink(dstVar);
    }

    public void removeListener(WorkFlowListener listener) {
        this.listeners.remove(listener);
    }

    public void reset() {
        for (BlockDescriptor block : this.orderedBlocks) {
            block.reset();
        }
    }

    public void runWorkFlow() {
        this.runWorkFlow(false);
    }

    public void runWorkFlow(boolean waitForCompletion) {
        this.descriptor.setStatus(BlockDescriptor.BlockStatus.DIRTY);
        this.executionThread = new Thread((Runnable)this.descriptor, "Workflow");
        this.executionThread.start();
        if (waitForCompletion) {
            while (this.descriptor.getStatus() == BlockDescriptor.BlockStatus.RUNNING) {
                ThreadUtil.sleep(100);
            }
        }
    }

    public void interrupt() {
        if (this.executionThread != null) {
            this.executionThread.interrupt();
            this.userInterruption = true;
        } else {
            this.descriptor.getContainer().interrupt();
        }
    }

    private boolean isInterrupted() {
        if (Icy.getMainInterface().isHeadLess()) {
            return false;
        }
        if (this.descriptor.getContainer() != null) {
            return this.descriptor.getContainer().isInterrupted();
        }
        return this.userInterruption || this.executionThread.isInterrupted();
    }

    @Override
    public void run() {
        if (this.orderedBlocks.size() == 0) {
            return;
        }
        this.descriptor.setStatus(BlockDescriptor.BlockStatus.RUNNING);
        BlockDescriptor runningBlock = null;
        String finalStatus = "";
        this.userInterruption = false;
        long startTime = 0L;
        long endTime = 0L;
        try {
            startTime = System.nanoTime();
            String statusPrefix = this.getBlockDescriptor().getContainer() == null ? "" : "\"" + this.getBlockDescriptor().getContainer().descriptor.getName() + "\" => ";
            PrintStream log = this.getLogStream();
            for (int blockIndex = 0; blockIndex < this.orderedBlocks.size(); ++blockIndex) {
                if (this.isInterrupted()) {
                    throw new StopException();
                }
                BlockDescriptor blockDescriptor = this.orderedBlocks.get(blockIndex);
                if (blockDescriptor.getStatus() == BlockDescriptor.BlockStatus.READY) continue;
                runningBlock = blockDescriptor;
                String blockLog = "block #" + (blockIndex + 1) + " [" + blockDescriptor.getDefinedName() + "]";
                this.statusChanged(this, "Running block " + statusPrefix + "\"" + blockDescriptor.getDefinedName() + "\" (#" + (blockIndex + 1) + ")...");
                String indentation = "";
                WorkFlow container = this.descriptor.getContainer();
                while (container != null) {
                    indentation = indentation + "   ";
                    container = container.descriptor.getContainer();
                }
                log.print(indentation + "Running " + blockLog);
                if (blockDescriptor.inputVars.size() > 0) {
                    log.println(" with the following parameters:");
                    for (Var<?> var : blockDescriptor.inputVars) {
                        if (!blockDescriptor.inputVars.isVisible(var)) continue;
                        log.print(indentation + "- " + var.getName() + ": " + var.getValueAsString(true));
                        Var<?> reference = var.getReference();
                        if (reference != null) {
                            BlockDescriptor owner = this.getOutputOwner(reference);
                            if (owner == null) {
                                owner = this.getInputOwner(reference);
                            }
                            if (owner == null) {
                                log.println(" (from variable \"" + reference.getName() + "\" defined outside this workflow)");
                                continue;
                            }
                            if (owner == this.descriptor) {
                                log.println(" (from local loop or batch variable \"" + reference.getName() + "\")");
                                continue;
                            }
                            log.println(" (from variable \"" + reference.getName() + "\" of block #" + (this.indexOf(owner) + 1) + " [" + owner.getDefinedName() + "])");
                            continue;
                        }
                        log.println();
                    }
                }
                long tic = System.nanoTime();
                blockDescriptor.run();
                long tac = System.nanoTime();
                String time = UnitUtil.displayTimeAsStringWithUnits((tac - tic) / 1000000L, false);
                log.println(indentation + "Finished " + blockLog + " in " + (time.isEmpty() ? "0 ms" : time));
                runningBlock = null;
                if (!blockDescriptor.isFinalBlock()) continue;
                blockDescriptor.setFinalBlock(false);
                this.interrupt();
            }
            if (this.descriptor.getContainer() != null) {
                log.println();
            }
            finalStatus = "The workflow executed successfully";
        }
        catch (StopException e) {
            if (this.descriptor.getContainer() != null) {
                throw e;
            }
            finalStatus = "The workflow was interrupted";
        }
        catch (RuntimeException e) {
            finalStatus = "The workflow did not execute properly";
            boolean catchException = false;
            if (e instanceof IcyHandledException || e instanceof VarException) {
                catchException = true;
            } else if (e instanceof BlocksException) {
                catchException = ((BlocksException)e).catchException;
            }
            if (catchException) {
                String blockName = runningBlock.getDefinedName();
                int blockID = this.indexOf(runningBlock) + 1;
                throw new IcyHandledException("While running block \"" + blockName + "\" (" + blockID + "):\n" + e.getMessage());
            }
            throw e;
        }
        finally {
            this.descriptor.setStatus(BlockDescriptor.BlockStatus.READY);
            endTime = System.nanoTime();
            double time = endTime - startTime;
            finalStatus = finalStatus + " (total running time: " + StringUtil.toString(time / 1.0E9, 2) + " seconds)";
            this.statusChanged(this, finalStatus);
        }
    }

    public void setLocation(BlockDescriptor blockInfo, Point point) {
        blockInfo.setLocation(point.x, point.y);
    }

    public int size() {
        return this.orderedBlocks.size();
    }

    @Override
    public void blockStatusChanged(BlockDescriptor blockInfo, BlockDescriptor.BlockStatus status) {
        if (status == BlockDescriptor.BlockStatus.DIRTY) {
            for (Link<?> link : this.links) {
                if (link.srcBlock != blockInfo) continue;
                link.dstBlock.setStatus(BlockDescriptor.BlockStatus.DIRTY);
            }
        }
    }

    @Override
    public void blockVariableAdded(BlockDescriptor block, Var<?> variable) {
    }

    @Override
    public <T> void blockVariableChanged(BlockDescriptor block, Var<T> variable, T newValue) {
        this.blockVariableChanged(this, block, variable, newValue);
    }

    @Override
    public void blockCollapsed(BlockDescriptor block, boolean collapsed) {
    }

    @Override
    public void blockDimensionChanged(BlockDescriptor block, int newWidth, int newHeight) {
        this.blockDimensionChanged(this, block, newWidth, newHeight);
    }

    @Override
    public void blockLocationChanged(BlockDescriptor block, int newX, int newY) {
        this.blockLocationChanged(this, block, newX, newY);
    }

    @Override
    public void blockAdded(WorkFlow source, BlockDescriptor addedBlock) {
        for (WorkFlowListener listener : this.listeners) {
            listener.blockAdded(source, addedBlock);
        }
    }

    @Override
    public void blockRemoved(WorkFlow source, BlockDescriptor removedBlock) {
        for (WorkFlowListener listener : this.listeners) {
            listener.blockRemoved(source, removedBlock);
        }
    }

    @Override
    public void linkAdded(WorkFlow source, Link<?> addedLink) {
        for (WorkFlowListener listener : this.listeners) {
            listener.linkAdded(source, addedLink);
        }
    }

    @Override
    public void linkRemoved(WorkFlow source, Link<?> removedLink) {
        for (WorkFlowListener listener : this.listeners) {
            listener.linkRemoved(source, removedLink);
        }
    }

    @Override
    public void workFlowReordered(WorkFlow source) {
        for (WorkFlowListener listener : this.listeners) {
            listener.workFlowReordered(source);
        }
    }

    @Override
    public void blockCollapsed(WorkFlow source, BlockDescriptor block, boolean collapsed) {
        for (WorkFlowListener listener : this.listeners) {
            listener.blockCollapsed(source, block, collapsed);
        }
    }

    @Override
    public void blockDimensionChanged(WorkFlow source, BlockDescriptor block, int newWidth, int newHeight) {
        for (WorkFlowListener listener : this.listeners) {
            listener.blockDimensionChanged(this, block, newWidth, newHeight);
        }
    }

    @Override
    public void blockLocationChanged(WorkFlow source, BlockDescriptor block, int newX, int newY) {
        for (WorkFlowListener listener : this.listeners) {
            listener.blockLocationChanged(this, block, newX, newY);
        }
    }

    @Override
    public void blockStatusChanged(WorkFlow source, BlockDescriptor block, BlockDescriptor.BlockStatus status) {
    }

    @Override
    public void blockVariableAdded(WorkFlow source, BlockDescriptor block, Var<?> variable) {
        for (WorkFlowListener listener : this.listeners) {
            listener.blockVariableAdded(this, block, variable);
        }
    }

    @Override
    public <T> void blockVariableChanged(WorkFlow source, BlockDescriptor block, Var<T> variable, T newValue) {
        for (WorkFlowListener listener : this.listeners) {
            listener.blockVariableChanged(this, block, variable, newValue);
        }
    }

    @Override
    public void statusChanged(WorkFlow source, String message) {
        for (WorkFlowListener listener : this.listeners) {
            listener.statusChanged(source, message);
        }
    }

    public void newSelection() {
        this.blockSelection = new ArrayList();
        this.linkSelection = new ArrayList();
    }

    public boolean isBlockSelected(BlockDescriptor bd) {
        return this.blockSelection.contains(bd);
    }

    public boolean isLinkSelected(Link<?> l) {
        return this.linkSelection.contains(l);
    }

    public void selectBlock(BlockDescriptor bd) {
        if (!this.isBlockSelected(bd)) {
            this.blockSelection.add(bd);
        }
    }

    public void selectLink(Link<?> l) {
        if (!this.isLinkSelected(l)) {
            this.linkSelection.add(l);
        }
    }

    public void unselectBlock(BlockDescriptor bd) {
        if (this.isBlockSelected(bd)) {
            this.blockSelection.remove(bd);
        }
    }

    public void unselectLink(Link<?> l) {
        if (this.isLinkSelected(l)) {
            this.linkSelection.remove(l);
        }
    }

    public ArrayList<BlockDescriptor> getBlockSelection() {
        return this.blockSelection;
    }

    public ArrayList<Link<?>> getLinkSelection() {
        return this.linkSelection;
    }
}

