/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description.weights;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.weights.WeightFormat;
import io.bioimage.modelrunner.utils.YAMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModelDependencies {
    private String envFile;
    private LinkedHashMap<String, Object> kwargs;

    protected ModelDependencies(Map<String, Object> map) {
        this.envFile = (String)map.get("source");
    }

    public String getSource() {
        return this.envFile;
    }

    public static List<String> getDependencies(ModelDescriptor descriptor, WeightFormat weights) {
        ArrayList<String> deps = new ArrayList<String>();
        if (weights.getEnvDependencies() == null || weights.getEnvDependencies().getSource() == null) {
            return deps;
        }
        try {
            String path;
            Map<String, Object> map;
            if (descriptor.getModelPath() != null && (map = YAMLUtils.load(path = descriptor.getModelPath() + File.separator + weights.getEnvDependencies().getSource())).get("dependencies") != null && map.get("dependencies") instanceof List) {
                return ModelDependencies.dependenciesMapToList((List)map.get("dependencies"));
            }
            String url = descriptor.getModelURL() + weights.getEnvDependencies().getSource();
            String stringRDF = BioimageioRepo.getJSONFromUrl(url);
            Map<String, Object> map2 = YAMLUtils.loadFromString(stringRDF);
            if (map2.get("dependencies") != null && map2.get("dependencies") instanceof List) {
                return ModelDependencies.dependenciesMapToList((List)map2.get("dependencies"));
            }
        }
        catch (IOException | InterruptedException e) {
            return deps;
        }
        return deps;
    }

    private static List<String> dependenciesMapToList(List<Object> list) {
        ArrayList<String> deps = new ArrayList<String>();
        for (Object elem : list) {
            Object pipList;
            if (elem instanceof String) {
                deps.add((String)elem);
                continue;
            }
            if (!(elem instanceof Map) || !((Map)elem).containsKey("pip") || !((pipList = ((Map)elem).get("pip")) instanceof List)) continue;
            deps.addAll(ModelDependencies.dependenciesMapToList((List)pipList));
        }
        return deps;
    }
}

