/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.resource.ResourceUtil;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPanel;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.ComboBox;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;

public abstract class EzVar<T>
extends EzComponent
implements VarListener<T> {
    final Var<T> variable;
    private JLabel jLabelName;
    private VarEditor<T> varEditor;
    private final HashMap<EzComponent, T[]> visibilityTriggers = new HashMap();
    private final ArrayList<EzVarListener<T>> listeners = new ArrayList();
    private static final ImageIcon helpIcon = ResourceUtil.getColorIcon("help", 12);
    private final JButton bHelp = new JButton(helpIcon);

    protected EzVar(final Var<T> variable, VarEditorModel<T> constraint) {
        super(variable.getName());
        this.variable = variable;
        variable.setDefaultEditorModel(constraint);
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                EzVar.this.bHelp.setPreferredSize(new Dimension(12, 12));
                EzVar.this.bHelp.setBorder(null);
                EzVar.this.bHelp.setContentAreaFilled(false);
                EzVar.this.bHelp.setBorderPainted(false);
                EzVar.this.bHelp.setOpaque(false);
                EzVar.this.jLabelName = new JLabel(variable.getName());
                EzVar.this.varEditor = variable.createVarEditor();
            }
        });
    }

    protected EzVar(Var<T> variable, T[] defaultValues, int defaultValueIndex, boolean freeInput) {
        this(variable, new ValueSelectionModel<int>(defaultValues, defaultValueIndex, freeInput));
    }

    public void addVarChangeListener(EzVarListener<T> listener) {
        this.listeners.add(listener);
    }

    public void addVisibilityTriggerTo(EzComponent targetComponent, T ... values) {
        this.visibilityTriggers.put(targetComponent, values);
        this.updateVisibilityChain();
    }

    @Override
    protected void addTo(Container container) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 10, 2, 5);
        gbc.fill = 2;
        if (this.variable.isOptional()) {
            gbc.insets.left = 5;
            JPanel optionPanel = new JPanel(new BorderLayout(0, 0));
            final JCheckBox option = new JCheckBox("");
            option.setSelected(this.isEnabled());
            option.setFocusable(false);
            option.setToolTipText("Click here to disable this parameter");
            option.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    EzVar.this.setEnabled(option.isSelected());
                    if (option.isSelected()) {
                        option.setToolTipText("Click here to disable this parameter");
                    } else {
                        option.setToolTipText("Click here to enable this parameter");
                    }
                }
            });
            optionPanel.add((Component)option, "West");
            optionPanel.add((Component)this.jLabelName, "Center");
            container.add((Component)optionPanel, gbc);
            gbc.insets.left = 10;
        } else {
            container.add((Component)this.jLabelName, gbc);
        }
        gbc.weightx = 1.0;
        VarEditor<T> ed = this.getVarEditor();
        ed.setEnabled(true);
        JComponent component = (JComponent)ed.getEditorComponent();
        component.setPreferredSize(ed.getPreferredSize());
        container.add((Component)component, gbc);
        gbc.insets.left = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        container.add((Component)this.bHelp, gbc);
    }

    @Override
    protected void dispose() {
        this.visibilityTriggers.clear();
        this.varEditor.dispose();
        this.variable.removeListener(this);
        super.dispose();
    }

    final void fireVariableChangedInternal() {
        this.fireVariableChanged(this.variable.getValue());
    }

    protected final void fireVariableChanged(T value) {
        for (EzVarListener<T> l : this.listeners) {
            l.variableChanged(this, value);
        }
        if (this.getUI() != null && this.varEditor != null) {
            this.updateVisibilityChain();
            SwingUtilities.invokeLater(this.getUI().fullPackingTask);
        }
    }

    public T[] getDefaultValues(T[] dest) {
        if (this.getVarEditor() instanceof ComboBox) {
            JComponent combo = ((ComboBox)this.getVarEditor()).getEditorComponent();
            ArrayList items = new ArrayList(((JComboBox)combo).getItemCount());
            for (int i = 0; i < ((JComboBox)combo).getItemCount(); ++i) {
                items.add(((JComboBox)combo).getItemAt(i));
            }
            return items.toArray(dest);
        }
        throw new UnsupportedOperationException("The input component is not a list of values");
    }

    protected VarEditor<T> getVarEditor() {
        return this.varEditor;
    }

    String getID() {
        String id = this.variable.getName();
        for (EzPanel panel = this.getParentPanel(); panel != null; panel = panel.getParentPanel()) {
            id = panel.name + "." + id;
        }
        return id;
    }

    public T getValue() {
        return this.getValue(false);
    }

    public T getValue(boolean forbidNull) {
        return this.variable.getValue(forbidNull);
    }

    public Var<T> getVariable() {
        return this.variable;
    }

    public boolean isEnabled() {
        return this.variable.isEnabled();
    }

    public void removeVarChangeListener(EzVarListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void removeAllVarChangeListeners() {
        this.variable.removeListeners();
    }

    public void setDefaultValues(T[] values, int defaultValueIndex, boolean allowUserInput) {
        if (this.getVarEditor() instanceof ComboBox) {
            ((ComboBox)this.getVarEditor()).setDefaultValues(values, defaultValueIndex, allowUserInput);
        }
    }

    public void setEnabled(boolean enabled) {
        this.variable.setEnabled(enabled);
        this.jLabelName.setEnabled(enabled);
        this.getVarEditor().setEnabled(enabled);
        this.updateVisibilityChain();
        if (this.getUI() != null) {
            SwingUtilities.invokeLater(this.getUI().fullPackingTask);
        }
    }

    public void setOptional(boolean optional) {
        this.variable.setOptional(optional);
    }

    public void setValue(T value) throws UnsupportedOperationException {
        this.variable.setValue(value);
    }

    @Override
    public void setToolTipText(String text) {
        this.jLabelName.setToolTipText(text);
        this.bHelp.setToolTipText(text);
        this.getVarEditor().setComponentToolTipText(text);
    }

    @Override
    public void setVisible(boolean newVisibleState) {
        super.setVisible(newVisibleState);
        this.updateVisibilityChain();
    }

    public String toString() {
        return this.variable.getName() + " = " + this.variable.toString();
    }

    protected void updateVisibilityChain() {
        Set<EzComponent> componentsToUpdate = this.visibilityTriggers.keySet();
        for (EzComponent component : componentsToUpdate) {
            component.setVisible(false);
        }
        if (!this.isVisible()) {
            return;
        }
        block1: for (EzComponent component : componentsToUpdate) {
            T[] componentTriggerValues = this.visibilityTriggers.get(component);
            if (componentTriggerValues.length == 0 && this.isEnabled()) {
                component.setVisible(true);
                continue;
            }
            for (T triggerValue : componentTriggerValues) {
                if (triggerValue != this.getValue()) continue;
                component.setVisible(true);
                continue block1;
            }
        }
    }

    @Override
    public void valueChanged(Var<T> source, T oldValue, T newValue) {
        this.fireVariableChanged(newValue);
    }

    @Override
    public void referenceChanged(Var<T> source, Var<? extends T> oldReference, Var<? extends T> newReference) {
    }
}

