/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.runmode.ops;

import io.bioimage.modelrunner.runmode.ops.OpInterface;
import java.io.File;
import java.util.LinkedHashMap;

public class GenericOp
implements OpInterface {
    private String opFilePath;
    private String envPath;
    private String methodName;
    private int nOutputs;
    private LinkedHashMap<String, Object> inputsMap;

    public static GenericOp create(String envYaml, String script, String method, int nOutputs) {
        GenericOp op = new GenericOp();
        op.envPath = envYaml;
        op.opFilePath = script;
        op.methodName = method;
        op.nOutputs = nOutputs;
        return op;
    }

    public void setInputs(LinkedHashMap<String, Object> kwargs) {
        this.inputsMap = kwargs;
    }

    @Override
    public String getOpPythonFilename() {
        return new File(this.opFilePath).getName();
    }

    @Override
    public int getNumberOfOutputs() {
        return this.nOutputs;
    }

    @Override
    public void installOp() {
    }

    @Override
    public LinkedHashMap<String, Object> getOpInputs() {
        return this.inputsMap;
    }

    @Override
    public String getCondaEnv() {
        return this.envPath;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getOpDir() {
        return new File(this.opFilePath).getParent();
    }

    @Override
    public boolean isOpInstalled() {
        return false;
    }
}

