/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.tensor;

import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.tensor.Utils;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public final class ImgLib2ToArray {
    private ImgLib2ToArray() {
    }

    public static <T extends RealType<T> & NativeType<T>> Object build(Tensor<T> tensor) throws IllegalArgumentException {
        if (tensor.isEmpty()) {
            return new byte[0];
        }
        return ImgLib2ToArray.build(tensor.getData());
    }

    public static <T extends RealType<T> & NativeType<T>> Object build(RandomAccessibleInterval<T> rai) throws IllegalArgumentException {
        if (Util.getTypeFromInterval(rai) instanceof ByteType) {
            return ImgLib2ToArray.buildInt8((RandomAccessibleInterval<ByteType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        if (Util.getTypeFromInterval(rai) instanceof UnsignedByteType) {
            return ImgLib2ToArray.buildUint8((RandomAccessibleInterval<UnsignedByteType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        if (Util.getTypeFromInterval(rai) instanceof ShortType) {
            return ImgLib2ToArray.buildInt16((RandomAccessibleInterval<ShortType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        if (Util.getTypeFromInterval(rai) instanceof UnsignedShortType) {
            return ImgLib2ToArray.buildUint16((RandomAccessibleInterval<UnsignedShortType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        if (Util.getTypeFromInterval(rai) instanceof IntType) {
            return ImgLib2ToArray.buildInt32((RandomAccessibleInterval<IntType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        if (Util.getTypeFromInterval(rai) instanceof UnsignedIntType) {
            return ImgLib2ToArray.buildUint32((RandomAccessibleInterval<UnsignedIntType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        if (Util.getTypeFromInterval(rai) instanceof LongType) {
            return ImgLib2ToArray.buildInt64((RandomAccessibleInterval<LongType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        if (Util.getTypeFromInterval(rai) instanceof FloatType) {
            return ImgLib2ToArray.buildFloat32((RandomAccessibleInterval<FloatType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        if (Util.getTypeFromInterval(rai) instanceof DoubleType) {
            return ImgLib2ToArray.buildFloat64((RandomAccessibleInterval<DoubleType>)((RandomAccessibleInterval)Cast.unchecked(rai)));
        }
        throw new IllegalArgumentException("The image has an unsupported type: " + ((RealType)Util.getTypeFromInterval(rai)).getClass().toString());
    }

    private static byte[] buildInt8(RandomAccessibleInterval<ByteType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        byte[] flatArr = new byte[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((ByteType)cursor.get()).getByte();
        }
        return flatArr;
    }

    private static byte[] buildUint8(RandomAccessibleInterval<UnsignedByteType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        byte[] flatArr = new byte[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((UnsignedByteType)cursor.get()).getByte();
        }
        return flatArr;
    }

    private static short[] buildInt16(RandomAccessibleInterval<ShortType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        short[] flatArr = new short[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((ShortType)cursor.get()).getShort();
        }
        return flatArr;
    }

    private static short[] buildUint16(RandomAccessibleInterval<UnsignedShortType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        short[] flatArr = new short[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((UnsignedShortType)cursor.get()).getShort();
        }
        return flatArr;
    }

    private static int[] buildInt32(RandomAccessibleInterval<IntType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        int[] flatArr = new int[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((IntType)cursor.get()).getInt();
        }
        return flatArr;
    }

    private static int[] buildUint32(RandomAccessibleInterval<UnsignedIntType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        int[] flatArr = new int[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((UnsignedIntType)cursor.get()).getInt();
        }
        return flatArr;
    }

    private static long[] buildInt64(RandomAccessibleInterval<LongType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        long[] flatArr = new long[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((LongType)cursor.get()).get();
        }
        return flatArr;
    }

    private static float[] buildFloat32(RandomAccessibleInterval<FloatType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        float[] flatArr = new float[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((FloatType)cursor.get()).get();
        }
        return flatArr;
    }

    private static double[] buildFloat64(RandomAccessibleInterval<DoubleType> tensor) {
        tensor = Utils.transpose(tensor);
        long[] tensorShape = tensor.dimensionsAsLongArray();
        int size = 1;
        for (long ll : tensorShape) {
            size = (int)((long)size * ll);
        }
        double[] flatArr = new double[size];
        int[] sArr = new int[tensorShape.length];
        for (int i = 0; i < sArr.length; ++i) {
            sArr[i] = (int)tensorShape[i];
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            flatArr[i++] = ((DoubleType)cursor.get()).get();
        }
        return flatArr;
    }
}

