/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.tensor;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.RealTypeConverters;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public final class Tensor<T extends RealType<T> & NativeType<T>> {
    private String tensorName;
    private int[] axesArray;
    private String axesString;
    private RandomAccessibleInterval<T> data;
    private boolean isImage = true;
    private boolean emptyTensor;
    private Type<T> dType;
    private int[] shape;
    private boolean closed = false;

    private Tensor(String tensorName, String axes, RandomAccessibleInterval<T> data) {
        Objects.requireNonNull(tensorName, "'tensorName' field should not be empty");
        Objects.requireNonNull(axes, "'axes' field should not be empty");
        if (data != null) {
            this.checkDims(data, axes);
        }
        this.tensorName = tensorName;
        this.axesString = axes;
        this.axesArray = Tensor.convertToTensorDimOrder(axes);
        this.data = data;
        if (data != null) {
            this.setShape();
            this.dType = (Type)Util.getTypeFromInterval(data);
            this.emptyTensor = false;
        } else {
            this.emptyTensor = true;
        }
        if (this.axesString.indexOf("x") == -1 && this.axesString.indexOf("y") == -1 && this.axesString.indexOf("z") == -1) {
            this.isImage = false;
        }
    }

    public static <T extends RealType<T> & NativeType<T>> Tensor<T> build(String tensorName, String axes, RandomAccessibleInterval<T> data) {
        if (data == null) {
            throw new IllegalArgumentException("Trying to create tensor from an empty NDArray");
        }
        return new Tensor<T>(tensorName, axes, data);
    }

    public static <T extends RealType<T> & NativeType<T>> Tensor<T> buildEmptyTensor(String tensorName, String axes) {
        return new Tensor<T>(tensorName, axes, null);
    }

    public static <T extends RealType<T> & NativeType<T>> Tensor<T> buildBlankTensor(String tensorName, String axes, long[] shape, T dtype) {
        ArrayImgFactory imgFactory = new ArrayImgFactory(dtype);
        ArrayImg backendData = imgFactory.create(shape);
        return new Tensor<T>(tensorName, axes, backendData);
    }

    public void setData(RandomAccessibleInterval<T> data) {
        this.throwExceptionIfClosed();
        if (data == null && this.data != null) {
            this.data = null;
            return;
        }
        if (!this.emptyTensor) {
            this.checkDims(data, this.axesString);
        }
        if (!this.emptyTensor && !this.equalShape(data.dimensionsAsLongArray())) {
            throw new IllegalArgumentException("Trying to set an array as the backend of the Tensor with a different shape than the Tensor. Tensor shape is: " + Arrays.toString(this.shape) + " and array shape is: " + Arrays.toString(data.dimensionsAsLongArray()));
        }
        if (!this.emptyTensor && this.data != null && this.getDataType().getClass() != ((RealType)Util.getTypeFromInterval(data)).getClass()) {
            throw new IllegalArgumentException("Trying to set an array as the backend of the Tensor with a different data type than the Tensor. Tensor data type is: " + this.dType.toString() + " and array data type is: " + ((RealType)Util.getTypeFromInterval(data)).toString());
        }
        if (this.data == null) {
            this.data = data;
        } else {
            LoopBuilder.setImages(this.data, data).multiThreaded().forEachPixel((i, o) -> i.set((Type)o));
        }
        if (this.emptyTensor) {
            this.setShape();
            this.dType = (Type)Util.getTypeFromInterval(data);
            this.emptyTensor = false;
        }
    }

    public RandomAccessibleInterval<T> getData() {
        this.throwExceptionIfClosed();
        if (this.data == null && this.isEmpty()) {
            throw new IllegalArgumentException("Tensor '" + this.tensorName + "' is empty.");
        }
        if (this.data == null) {
            throw new IllegalArgumentException("If you want to retrieve the tensor data as an NDArray, please first transform the tensor data into an NDArray using: TensorManager.buffer2array(tensor)");
        }
        return this.data;
    }

    public void copyTensorBackend(Tensor<T> source) {
        this.throwExceptionIfClosed();
        if (source.getData() != null) {
            this.copyRAITensorBackend(source);
        }
    }

    public void copyRAITensorBackend(Tensor<T> source) {
        this.throwExceptionIfClosed();
        this.setData(source.getData());
    }

    public static <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> Tensor<R> createCopyOfTensorInWantedDataType(Tensor<T> tt, R type) {
        super.throwExceptionIfClosed();
        RandomAccessibleInterval<T> input = tt.getData();
        ImgFactory factory = Util.getArrayOrCellImgFactory(input, type);
        Img output = factory.create(input);
        RealType s = (RealType)Util.getTypeFromInterval(input);
        RealType d = (RealType)Util.getTypeFromInterval((Interval)output);
        Converter copy = RealTypeConverters.getConverter((RealType)s, (RealType)d);
        boolean useMultiThreading = Intervals.numElements((Dimensions)output) >= 20000L;
        LoopBuilder.setImages(input, (RandomAccessibleInterval)output).multiThreaded(useMultiThreading).forEachPixel((x$0, x$1) -> copy.convert(x$0, x$1));
        return Tensor.build(tt.getName(), tt.getAxesOrderString(), output);
    }

    public static <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> RandomAccessibleInterval<R> createCopyOfRaiInWantedDataType(RandomAccessibleInterval<T> input, R type) {
        ImgFactory factory = Util.getArrayOrCellImgFactory(input, type);
        Img output = factory.create(input);
        RealType s = (RealType)Util.getTypeFromInterval(input);
        RealType d = (RealType)Util.getTypeFromInterval((Interval)output);
        Converter copy = RealTypeConverters.getConverter((RealType)s, (RealType)d);
        boolean useMultiThreading = Intervals.numElements((Dimensions)output) >= 20000L;
        LoopBuilder.setImages(input, (RandomAccessibleInterval)output).multiThreaded(useMultiThreading).forEachPixel((x$0, x$1) -> copy.convert(x$0, x$1));
        return output;
    }

    private void throwExceptionIfClosed() {
        if (!this.closed) {
            return;
        }
        throw new IllegalStateException("The tensor that is trying to be modified has already been closed.");
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.closed = true;
            this.axesArray = null;
            if (this.data != null) {
                this.data = null;
            }
            this.data = null;
            this.axesString = null;
            this.dType = null;
            this.shape = null;
            this.tensorName = null;
        }
        catch (Exception ex) {
            this.closed = false;
            String msg = "Error trying to close tensor: " + this.tensorName + ". ";
            msg = msg + ex.toString();
            throw new IllegalStateException(msg);
        }
    }

    public static <T extends NativeType<T> & RealType<T>> Tensor<T> getTensorByNameFromList(List<Tensor<T>> lTensors, String name) {
        return lTensors.stream().filter(pp -> !pp.isClosed() && pp.getName() != null && pp.getName().equals(name)).findAny().orElse(null);
    }

    private boolean equalShape(long[] longShape) {
        if (longShape.length != this.shape.length) {
            return false;
        }
        for (int i = 0; i < longShape.length; ++i) {
            if ((int)longShape[i] == this.shape[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] convertToTensorDimOrder(String dimOrder) throws IllegalArgumentException {
        dimOrder = dimOrder.toLowerCase();
        int[] tensorDimOrder = new int[dimOrder.length()];
        int hasB = 0;
        int hasI = 0;
        int hasT = 0;
        int hasX = 0;
        int hasY = 0;
        int hasZ = 0;
        int hasC = 0;
        boolean hasR = false;
        block10: for (int i = 0; i < dimOrder.length(); ++i) {
            switch (dimOrder.charAt(i)) {
                case 'b': {
                    tensorDimOrder[i] = 4;
                    hasB = 1;
                    continue block10;
                }
                case 'i': {
                    tensorDimOrder[i] = 3;
                    hasI = 1;
                    continue block10;
                }
                case 'r': {
                    tensorDimOrder[i] = 3;
                    hasI = 1;
                    continue block10;
                }
                case 't': {
                    tensorDimOrder[i] = 4;
                    hasT = 1;
                    continue block10;
                }
                case 'z': {
                    tensorDimOrder[i] = 3;
                    ++hasZ;
                    continue block10;
                }
                case 'c': {
                    tensorDimOrder[i] = 2;
                    ++hasC;
                    continue block10;
                }
                case 'y': {
                    tensorDimOrder[i] = 1;
                    ++hasY;
                    continue block10;
                }
                case 'x': {
                    tensorDimOrder[i] = 0;
                    ++hasX;
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Illegal axis for tensor dim order " + dimOrder + " (" + dimOrder.charAt(i) + ")");
                }
            }
        }
        if (hasB + hasT > 1) {
            throw new IllegalArgumentException("Tensor axes order can only have either one 'b' or one 't'. These axes are exclusive .");
        }
        if (hasZ + 0 + hasI > 1) {
            throw new IllegalArgumentException("Tensor axes order can only have either one 'i', one 'z' or one 'r'.");
        }
        if (hasY > 1 || hasX > 1 || hasC > 1 || hasZ > 1 || hasT > 1 || hasI > 1 || hasB > 1) {
            throw new IllegalArgumentException("There cannot be repeated dimensions in the axes order as this tensor has (" + dimOrder + ").");
        }
        return tensorDimOrder;
    }

    private void setShape() {
        if (this.data == null) {
            throw new IllegalArgumentException("Trying to create tensor from an empty NDArray");
        }
        long[] longShape = this.data.dimensionsAsLongArray();
        this.shape = new int[longShape.length];
        for (int i = 0; i < this.shape.length; ++i) {
            this.shape[i] = (int)longShape[i];
        }
    }

    public String getName() {
        this.throwExceptionIfClosed();
        return this.tensorName;
    }

    public int[] getShape() {
        this.throwExceptionIfClosed();
        return this.shape;
    }

    public String getAxesOrderString() {
        this.throwExceptionIfClosed();
        return this.axesString;
    }

    public int[] getAxesOrder() {
        this.throwExceptionIfClosed();
        return this.axesArray;
    }

    public void setIsImage(boolean isImage) {
        this.throwExceptionIfClosed();
        if (!isImage) {
            this.assertIsList();
        }
        this.isImage = isImage;
    }

    public boolean isImage() {
        this.throwExceptionIfClosed();
        return this.isImage;
    }

    public boolean isEmpty() {
        this.throwExceptionIfClosed();
        return this.emptyTensor;
    }

    public Type<T> getDataType() {
        this.throwExceptionIfClosed();
        return (Type)Util.getTypeFromInterval(this.data);
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void checkDims(RandomAccessibleInterval<T> data, String axesOrder) {
        if (data.dimensionsAsLongArray().length != axesOrder.length()) {
            throw new IllegalArgumentException("The axes order introduced has to correspond to the same number of dimenensions that the NDArray has. In this case the axes order is specfied for " + axesOrder.length() + " dimensions while the array has " + data.dimensionsAsLongArray().length + " dimensions.");
        }
    }

    private void assertIsList() {
        boolean z;
        boolean x = this.axesString.toLowerCase().indexOf("x") != -1;
        boolean y = this.axesString.toLowerCase().indexOf("y") != -1;
        boolean t = this.axesString.toLowerCase().indexOf("t") != -1;
        boolean bl = z = this.axesString.toLowerCase().indexOf("z") != -1;
        if (x || y || t || z) {
            throw new IllegalArgumentException("Tensor '" + this.tensorName + "' cannot be represented as a ist because lists can only have the axes: 'b', 'i', 'c' and 'r'. The axes for this tensor are :" + this.axesString + ".");
        }
    }
}

