/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.tiling;

import java.util.stream.LongStream;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public final class ImgLib2Utils {
    private ImgLib2Utils() {
    }

    public static <T extends RealType<T> & NativeType<T>> void copyRaiData(RandomAccessibleInterval<T> sourceNDArray, RandomAccessibleInterval<T> targetNDArray, int[] sourceOffset, int[] paddingBottomRight) {
        long[] sourceSize = sourceNDArray.dimensionsAsLongArray();
        long[] targetSize = targetNDArray.dimensionsAsLongArray();
        long[] newSourceOffset = LongStream.range(0L, sourceOffset.length).map(i -> Math.min((long)sourceOffset[(int)i], sourceSize[(int)i] + (long)paddingBottomRight[(int)i] - targetSize[(int)i])).toArray();
        long[] internalSourceOffset = LongStream.range(0L, sourceSize.length).map(i -> Math.min(sourceSize[(int)i], Math.max(0L, newSourceOffset[(int)i]))).toArray();
        long[] internalSize = LongStream.range(0L, sourceSize.length).map(i -> Math.max(0L, Math.min(newSourceOffset[(int)i] + targetSize[(int)i], sourceSize[(int)i]) - internalSourceOffset[(int)i])).toArray();
        long[] targetRaiStart = LongStream.range(0L, sourceSize.length).map(i -> internalSourceOffset[(int)i] - newSourceOffset[(int)i]).toArray();
        IntervalView sourceTile = Views.offsetInterval(sourceNDArray, (long[])internalSourceOffset, (long[])internalSize);
        IntervalView targetTile = Views.offsetInterval(targetNDArray, (long[])targetRaiStart, (long[])internalSize);
        LoopBuilder.setImages((RandomAccessibleInterval)sourceTile, (RandomAccessibleInterval)targetTile).multiThreaded().forEachPixel((i, j) -> j.set((Type)i));
    }

    public static <T extends RealType<T> & NativeType<T>> void addMirrorToPatchRai(RandomAccessibleInterval<T> inputNDArr, RandomAccessibleInterval<T> patchNDArr, int[] newPatchStart, int[][] padding) {
        long[] patchSize = patchNDArr.dimensionsAsLongArray();
        long[] imSize = inputNDArr.dimensionsAsLongArray();
        long[] patchStart = LongStream.range(0L, newPatchStart.length).map(i -> Math.min((long)newPatchStart[(int)i], imSize[(int)i] + (long)padding[1][(int)i] - patchSize[(int)i])).toArray();
        long[] paddingFront = LongStream.range(0L, patchStart.length).map(i -> patchStart[(int)i] < 0L ? patchStart[(int)i] * -1L : 0L).toArray();
        patchNDArr = Views.offsetInterval((RandomAccessible)Views.expandMirrorDouble(inputNDArr, (long[])paddingFront), (long[])patchStart, (long[])patchNDArr.dimensionsAsLongArray());
    }

    public static <T extends RealType<T> & NativeType<T>> void fillRaiAt(RandomAccessibleInterval<T> resultNDArray, RandomAccessibleInterval<T> patchNDArray, int[] resultOffset, int[] paddingFront, int[] areaOfInterestSize) {
        long[] finalSize = resultNDArray.dimensionsAsLongArray();
        long[] newPaddingFront = LongStream.range(0L, resultOffset.length).map(i -> Math.min((long)resultOffset[(int)i], finalSize[(int)i] - (long)areaOfInterestSize[(int)i])).toArray();
        long[] startSource = LongStream.range(0L, paddingFront.length).map(i -> newPaddingFront[(int)i] < 0L ? -1L * newPaddingFront[(int)i] + (long)paddingFront[(int)i] : (long)paddingFront[(int)i]).toArray();
        long[] startTarget = LongStream.range(0L, paddingFront.length).map(i -> Math.max(0L, newPaddingFront[(int)i])).toArray();
        long[] endTarget = LongStream.range(0L, paddingFront.length).map(i -> Math.min(finalSize[(int)i], newPaddingFront[(int)i] + (long)areaOfInterestSize[(int)i])).toArray();
        long[] intervalSize = LongStream.range(0L, paddingFront.length).map(i -> endTarget[(int)i] - startTarget[(int)i]).toArray();
        IntervalView resultInterval = Views.offsetInterval(resultNDArray, (long[])startTarget, (long[])intervalSize);
        IntervalView patchInterval = Views.offsetInterval(patchNDArray, (long[])startSource, (long[])intervalSize);
        LoopBuilder.setImages((RandomAccessibleInterval)patchInterval, (RandomAccessibleInterval)resultInterval).multiThreaded().forEachPixel((i, j) -> j.set((Type)i));
    }

    public static int multidimensionalIntoFlatIndex(int[] ind, int[] size) {
        int flat = 0;
        for (int i = 0; i < ind.length; ++i) {
            int inter = ind[i];
            for (int j = i + 1; j < size.length; ++j) {
                inter *= size[j];
            }
            flat += inter;
        }
        return flat;
    }

    public static int[] to5DFillWith0(int[] arr) {
        int[] nArr = new int[5];
        for (int i = 0; i < arr.length; ++i) {
            nArr[i] = arr[i];
        }
        return nArr;
    }

    public static int[] to5DFillWith1(int[] arr) {
        int[] nArr = new int[]{1, 1, 1, 1, 1};
        for (int i = 0; i < arr.length; ++i) {
            nArr[i] = arr[i];
        }
        return nArr;
    }

    public static <T extends RealType<T> & NativeType<T>> int[] getRaiSizeArray(RandomAccessibleInterval<T> s) {
        long[] longShape = s.dimensionsAsLongArray();
        int nDims = longShape.length;
        int[] intShape = new int[longShape.length];
        for (int i = 0; i < nDims; ++i) {
            intShape[i] = (int)longShape[i];
        }
        return intShape;
    }
}

