/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.adapter;

import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import io.bioimage.modelrunner.apposed.appose.Types;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.bioimageio.description.exceptions.ModelSpecsException;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.engine.installation.EngineInstall;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.model.BaseModel;
import io.bioimage.modelrunner.model.java.BioimageIoModelJava;
import io.bioimage.modelrunner.model.python.BioimageIoModelPytorch;
import io.bioimage.modelrunner.model.python.DLModelPytorchProtected;
import io.bioimage.modelrunner.model.special.stardist.Stardist2D;
import io.bioimage.modelrunner.model.special.stardist.StardistAbstract;
import io.bioimage.modelrunner.tensor.Tensor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.apache.commons.compress.archivers.ArchiveException;

public abstract class RunnerAdapter
implements Closeable {
    protected ModelDescriptor descriptor;
    protected final String enginesPath;
    protected final ClassLoader classLoader;
    protected BaseModel model;
    protected boolean closed = false;
    protected boolean loaded = false;

    protected abstract <T extends RealType<T> & NativeType<T>> LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>> displayTestInputs(LinkedHashMap<TensorSpec, String> var1);

    protected abstract LinkedHashMap<TensorSpec, String> getTestInputs();

    protected RunnerAdapter(ModelDescriptor descriptor) {
        this.descriptor = descriptor;
        this.enginesPath = new File("engines").getAbsolutePath();
        this.classLoader = null;
    }

    protected RunnerAdapter(ModelDescriptor descriptor, ClassLoader classloader) {
        this.descriptor = descriptor;
        this.enginesPath = new File("engines").getAbsolutePath();
        this.classLoader = classloader;
    }

    protected RunnerAdapter(ModelDescriptor descriptor, String enginesPath) {
        this.descriptor = descriptor;
        this.enginesPath = enginesPath;
        this.classLoader = null;
    }

    protected RunnerAdapter(ModelDescriptor descriptor, String enginesPath, ClassLoader classloader) {
        this.descriptor = descriptor;
        this.enginesPath = enginesPath;
        this.classLoader = classloader;
    }

    public ModelDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void load() throws LoadModelException {
        this.load(true);
    }

    public void load(boolean installIfMissing) throws LoadModelException {
        if (this.closed) {
            throw new RuntimeException("The model has already been closed");
        }
        try {
            if (this.classLoader == null) {
                this.initWithEnginesPath(installIfMissing);
            } else {
                this.initWithEnginesClassLoader(installIfMissing);
            }
        }
        catch (Exception ex) {
            throw new LoadModelException(Types.stackTrace(ex));
        }
        this.model.loadModel();
        this.loaded = true;
    }

    public <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<R>> run(List<Tensor<T>> inputTensors) throws FileNotFoundException, RunModelException, IOException {
        if (this.closed) {
            throw new RuntimeException("The model has already been closed");
        }
        if (!this.model.isLoaded()) {
            throw new RuntimeException("Please first load the model");
        }
        return this.model.run(inputTensors);
    }

    public <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<R>> runOnTestImages() throws FileNotFoundException, ModelSpecsException, RunModelException, IOException {
        LinkedHashMap<TensorSpec, String> testInputs = this.getTestInputs();
        LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>> inputRais = this.displayTestInputs(testInputs);
        List inputTensors = this.createTestTensorList(inputRais);
        return this.model.run(inputTensors);
    }

    private <T extends RealType<T> & NativeType<T>> List<Tensor<T>> createTestTensorList(LinkedHashMap<TensorSpec, RandomAccessibleInterval<T>> inputRais) {
        return inputRais.entrySet().stream().map(ee -> Tensor.build(((TensorSpec)ee.getKey()).getName(), ((TensorSpec)ee.getKey()).getAxesOrder(), (RandomAccessibleInterval)ee.getValue())).collect(Collectors.toList());
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void initWithEnginesPath(boolean install) throws IOException, LoadEngineException, InterruptedException, RuntimeException, MambaInstallException, ArchiveException, URISyntaxException {
        List<String> wList = this.descriptor.getWeights().getAllSuportedWeightNames();
        if (this.descriptor.getModelFamily().equals("stardist")) {
            boolean installed = StardistAbstract.isInstalled();
            if (install && !installed) {
                StardistAbstract.installRequirements();
            } else if (!installed) {
                this.descriptor = ModelDescriptorFactory.readFromLocalFile(this.descriptor.getModelPath() + File.separator + "rdf.yaml", false);
                this.initWithEnginesPath(install);
                return;
            }
            this.model = Stardist2D.fromBioimageioModel(this.descriptor);
        } else if (this.descriptor.getModelFamily().equals("bioimage.io") && (wList.size() != 1 || !wList.contains(ModelWeight.getPytorchID()))) {
            if (install) {
                Consumer<Double> cons = dd -> {
                    double progress = Math.round(dd * 10000.0) / 100L;
                    System.out.println("Downloading engines for " + this.descriptor.getName() + ":" + progress + "%");
                };
                EngineInstall.installEnginesForModelInDir(this.descriptor, this.enginesPath, cons);
            }
            this.model = BioimageIoModelJava.createBioimageioModel(this.descriptor.getModelPath(), this.enginesPath);
        } else if (this.descriptor.getModelFamily().equals("bioimage.io")) {
            if (install && !DLModelPytorchProtected.isInstalled()) {
                DLModelPytorchProtected.installRequirements();
            }
            this.model = BioimageIoModelPytorch.create(this.descriptor);
        } else {
            throw new IllegalArgumentException("Model not supported");
        }
    }

    private void initWithEnginesClassLoader(boolean install) throws LoadEngineException, IOException, InterruptedException, RuntimeException, MambaInstallException, ArchiveException, URISyntaxException {
        List<String> wList = this.descriptor.getWeights().getAllSuportedWeightNames();
        if (this.descriptor.getModelFamily().equals("stardist")) {
            boolean installed = StardistAbstract.isInstalled();
            if (install && !installed) {
                StardistAbstract.installRequirements();
            } else if (!installed) {
                this.descriptor = ModelDescriptorFactory.readFromLocalFile(this.descriptor.getModelPath() + File.separator + "rdf.yaml", false);
                this.initWithEnginesPath(install);
                return;
            }
            this.model = Stardist2D.fromBioimageioModel(this.descriptor);
        } else if (this.descriptor.getModelFamily().equals("bioimage.io") && (wList.size() != 1 || !wList.contains(ModelWeight.getPytorchID()))) {
            if (install) {
                Consumer<Double> cons = dd -> {
                    double progress = Math.round(dd * 10000.0) / 100L;
                    System.out.println("Downloading engines for " + this.descriptor.getName() + ":" + progress + "%");
                };
                EngineInstall.installEnginesForModelInDir(this.descriptor, this.enginesPath, cons);
            }
            this.model = BioimageIoModelJava.createBioimageioModel(this.descriptor.getModelPath(), this.enginesPath, this.classLoader);
        } else if (this.descriptor.getModelFamily().equals("bioimage.io")) {
            if (install && !DLModelPytorchProtected.isInstalled()) {
                DLModelPytorchProtected.installRequirements();
            }
            this.model = BioimageIoModelPytorch.create(this.descriptor);
        } else {
            throw new IllegalArgumentException("Model not supported");
        }
    }

    public boolean isLoaded() {
        if (this.isClosed()) {
            return false;
        }
        return this.loaded;
    }

    @Override
    public void close() throws IOException {
        this.model.close();
        this.closed = true;
        this.loaded = false;
    }
}

