/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.gui.main.MainFrame;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.preferences.GeneralPreferences;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class IdConfirmDialog {
    public static final int DEFAULT_OPTION = 1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;

    public static boolean getBooleanReturnValue(int returnValue) {
        return returnValue == 0 || returnValue == 0;
    }

    public static boolean confirm(String title, String message, int optionType, String id) {
        Confirmer confirmer = new Confirmer(title, message, optionType, id);
        if (Icy.getMainInterface().isHeadLess()) {
            return true;
        }
        ThreadUtil.invokeNow(confirmer);
        return confirmer.result;
    }

    public static boolean confirm(String title, String message, String id) {
        return IdConfirmDialog.confirm(title, message, 2, id);
    }

    public static boolean confirm(String message, String id) {
        return IdConfirmDialog.confirm("Confirmation", message, 2, id);
    }

    public static class Confirmer
    implements Runnable {
        private final String title;
        private final String message;
        private final int optionType;
        private final String id;
        boolean result;
        JCheckBox doNotDisplayCheckbox;

        public Confirmer(String title, String message, int optionType, String id) {
            this.id = id;
            this.title = title;
            this.message = message;
            this.optionType = optionType;
        }

        @Override
        public void run() {
            if (!StringUtil.isEmpty(this.id)) {
                if (!GeneralPreferences.getPreferencesConfirms().getBoolean(this.id, true)) {
                    this.result = true;
                    return;
                }
                this.doNotDisplayCheckbox = new JCheckBox("Do not show this message again", false);
            } else {
                this.doNotDisplayCheckbox = null;
            }
            MainFrame parent = Icy.getMainInterface().getMainFrame();
            JOptionPane pane = new JOptionPane(this.message, 3, this.optionType, null, null, null);
            pane.setInitialValue(null);
            if (parent != null) {
                pane.setComponentOrientation(((Component)((Object)parent)).getComponentOrientation());
            }
            JDialog dialog = pane.createDialog((Component)((Object)parent), this.title);
            pane.selectInitialValue();
            if (this.doNotDisplayCheckbox != null) {
                dialog.getContentPane().add((Component)GuiUtil.createLineBoxPanel(this.doNotDisplayCheckbox, Box.createHorizontalGlue()), "South");
                dialog.pack();
            }
            dialog.setVisible(true);
            dialog.dispose();
            Object selectedValue = pane.getValue();
            if (this.doNotDisplayCheckbox != null && this.doNotDisplayCheckbox.isSelected()) {
                GeneralPreferences.getPreferencesConfirms().putBoolean(this.id, false);
            }
            this.result = selectedValue == null ? false : (selectedValue instanceof Integer ? IdConfirmDialog.getBooleanReturnValue((Integer)selectedValue) : false);
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

