/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.apposed.appose;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.List;

public final class FilePaths {
    private FilePaths() {
    }

    public static File location(Class<?> c) {
        try {
            return new File(c.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }

    public static File findExe(List<String> dirs, List<String> exes) {
        for (String exe : exes) {
            File exeFile = new File(exe);
            if (exeFile.isAbsolute()) {
                if (!exeFile.canExecute()) continue;
                return exeFile;
            }
            for (String dir : dirs) {
                File f = Paths.get(dir, exe).toFile();
                if (!f.canExecute()) continue;
                return f;
            }
        }
        return null;
    }
}

