/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.image.filtering.convolution;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.util.Arrays;
import plugins.kernel.image.filtering.convolution.IKernel1D;

public class GaussianKernel1D
implements IKernel1D {
    private double[] data;

    private GaussianKernel1D(double[] data) {
        this.data = data;
    }

    public static GaussianKernel1D create(double sigma) {
        double[] data;
        if (sigma < 1.0E-10) {
            data = new double[]{1.0};
        } else {
            double sigma2 = sigma * sigma;
            int k = (int)Math.ceil(sigma * 3.0);
            int width = 2 * k + 1;
            data = new double[width];
            int i = -k;
            while (i <= k) {
                data[i + k] = 1.0 / (Math.sqrt(Math.PI * 2) * sigma * Math.exp((double)(i * i) / sigma2 * 0.5));
                ++i;
            }
            GaussianKernel1D.normalize(data);
        }
        return new GaussianKernel1D(data);
    }

    private static void normalize(double[] data) {
        double accu = 0.0;
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            accu += d;
            ++n2;
        }
        if (accu != 1.0 && accu != 0.0) {
            int i = 0;
            while (i < data.length) {
                int n3 = i++;
                data[n3] = data[n3] / accu;
            }
        }
    }

    @Override
    public Sequence toSequence() {
        IcyBufferedImage image = new IcyBufferedImage(this.data.length, 1, 1, DataType.DOUBLE);
        image.setDataXYAsDouble(0, this.data);
        Sequence kernel = new Sequence(image);
        kernel.setName(this.toString());
        return kernel;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public boolean isSeparable() {
        return true;
    }

    public String toString() {
        return "GaussianKernel1D: " + Arrays.toString(this.data);
    }
}

