/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.CurveX;
import icy.type.geom.areax.Order0X;

final class CurveLinkX {
    CurveX curve;
    double ytop;
    double ybot;
    int etag;
    CurveLinkX next;

    public CurveLinkX(CurveX curve, double ystart, double yend, int etag) {
        this.curve = curve;
        this.ytop = ystart;
        this.ybot = yend;
        this.etag = etag;
        if (this.ytop < curve.getYTop() || this.ybot > curve.getYBot()) {
            throw new InternalError("bad curvelink [" + this.ytop + "=>" + this.ybot + "] for " + curve);
        }
    }

    public boolean absorb(CurveLinkX link) {
        return this.absorb(link.curve, link.ytop, link.ybot, link.etag);
    }

    public boolean absorb(CurveX curve, double ystart, double yend, int etag) {
        if (this.curve != curve || this.etag != etag || this.ybot < ystart || this.ytop > yend) {
            return false;
        }
        if (ystart < curve.getYTop() || yend > curve.getYBot()) {
            throw new InternalError("bad curvelink [" + ystart + "=>" + yend + "] for " + curve);
        }
        this.ytop = Math.min(this.ytop, ystart);
        this.ybot = Math.max(this.ybot, yend);
        return true;
    }

    public boolean isEmpty() {
        return this.ytop == this.ybot;
    }

    public CurveX getCurve() {
        return this.curve;
    }

    public CurveX getSubCurve() {
        if (this.ytop == this.curve.getYTop() && this.ybot == this.curve.getYBot()) {
            return this.curve.getWithDirection(this.etag);
        }
        return this.curve.getSubCurve(this.ytop, this.ybot, this.etag);
    }

    public CurveX getMoveto() {
        return new Order0X(this.getXTop(), this.getYTop());
    }

    public double getXTop() {
        return this.curve.XforY(this.ytop);
    }

    public double getYTop() {
        return this.ytop;
    }

    public double getXBot() {
        return this.curve.XforY(this.ybot);
    }

    public double getYBot() {
        return this.ybot;
    }

    public double getX() {
        return this.curve.XforY(this.ytop);
    }

    public int getEdgeTag() {
        return this.etag;
    }

    public void setNext(CurveLinkX link) {
        this.next = link;
    }

    public CurveLinkX getNext() {
        return this.next;
    }
}

