/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.runmode.ops;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.runmode.RunMode;
import io.bioimage.modelrunner.runmode.ops.OpInterface;
import io.bioimage.modelrunner.tensor.Tensor;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class StardistInferJdllOp
implements OpInterface {
    private String modelName;
    private Tensor<?> inputTensor;
    private String opFilePath;
    private String envPath;
    private LinkedHashMap<String, Object> inputsMap;
    private static final String MODEL_KEY = "model";
    private static final String INPUT_TENSOR_KEY = "input_tensor";
    private static final String OP_METHOD_NAME = "stardist_prediction_2d_mine";
    protected static final String STARDIST_FIELD_KEY = "stardist";
    private static final int N_STARDIST_OUTPUTS = 2;
    private static final String STARDIST_OP_FNAME = "stardist_inference.py";

    public static void main(String[] args) throws Exception {
        ArrayImgFactory imgFactory = new ArrayImgFactory((NativeType)new FloatType());
        Img img1 = imgFactory.create(new long[]{1L, 512L, 512L, 3L});
        Tensor inpTensor = Tensor.build("input0", "byxc", img1);
        String modelName = "C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\model-runner-java\\models\\StarDist H&E Nuclei Segmentation_06092023_020924\\rdf.yaml";
        StardistInferJdllOp op = StardistInferJdllOp.create(modelName, inpTensor);
        RunMode rm = RunMode.createRunMode(op);
        Map<String, Object> aa = rm.runOP();
        System.out.print(false);
    }

    public static <T extends RealType<T> & NativeType<T>> StardistInferJdllOp create(String modelName, Tensor<T> tensor) throws IllegalArgumentException, InterruptedException {
        StardistInferJdllOp op = new StardistInferJdllOp();
        op.setModel(modelName);
        op.setInputTensor(tensor);
        op.installOp();
        return op;
    }

    public void setModel(String modelName) throws IllegalArgumentException, InterruptedException {
        Objects.requireNonNull(modelName, "The modelName input argument cannot be null.");
        if (new File(modelName).isFile() && !StardistInferJdllOp.isModelFileStardist(modelName)) {
            throw new IllegalArgumentException("The file selected does not correspond to the rdf.yaml file of a Bioiamge.io Stardist model.");
        }
        if (!new File(modelName).isFile() && !StardistInferJdllOp.isModelNameStardist(modelName)) {
            throw new IllegalArgumentException("The model name provided does not correspond to a valid Stardist model present in the Bioimage.io online reposritory.");
        }
        this.modelName = modelName;
    }

    public <T extends RealType<T> & NativeType<T>> void setInputTensor(Tensor<T> tensor) {
        this.inputTensor = tensor;
    }

    @Override
    public String getOpPythonFilename() {
        return STARDIST_OP_FNAME;
    }

    @Override
    public int getNumberOfOutputs() {
        return 2;
    }

    @Override
    public void installOp() {
        this.opFilePath = "C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\model-runner-java\\python\\ops\\stardist_inference";
        this.envPath = "C:\\Users\\angel\\git\\jep\\miniconda\\envs\\stardist";
    }

    @Override
    public LinkedHashMap<String, Object> getOpInputs() {
        Objects.requireNonNull(this.modelName, "The model of interest needs to be defined first.");
        Objects.requireNonNull(this.inputTensor, "The input tensor has not been defined. Please, define it with the method 'setInputTensor(Tensor<T> tensor)'");
        this.inputsMap = new LinkedHashMap();
        this.inputsMap.put(MODEL_KEY, this.modelName);
        this.inputsMap.put(INPUT_TENSOR_KEY, this.inputTensor);
        return this.inputsMap;
    }

    @Override
    public String getCondaEnv() {
        return this.envPath;
    }

    @Override
    public String getMethodName() {
        return OP_METHOD_NAME;
    }

    @Override
    public String getOpDir() {
        return this.opFilePath;
    }

    @Override
    public boolean isOpInstalled() {
        return false;
    }

    public static boolean isModelCompatible(String modelName) throws InterruptedException {
        if (modelName == null) {
            return false;
        }
        if (new File(modelName).isFile()) {
            return StardistInferJdllOp.isModelFileStardist(modelName);
        }
        return StardistInferJdllOp.isModelNameStardist(modelName);
    }

    public static boolean isModelFileStardist(String modelFile) {
        if (!new File(modelFile).getName().equals("rdf.yaml")) {
            return false;
        }
        try {
            ModelDescriptor descriptor = ModelDescriptorFactory.readFromLocalFile(modelFile);
            return descriptor.getConfig().getSpecMap().keySet().contains(STARDIST_FIELD_KEY);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isModelNameStardist(String modelName) throws InterruptedException {
        BioimageioRepo br = BioimageioRepo.connect();
        if (br.selectByName(modelName) != null) {
            return br.selectByName(modelName).getConfig().getSpecMap().keySet().contains(STARDIST_FIELD_KEY);
        }
        if (br.selectByID(modelName) != null) {
            return br.selectByID(modelName).getConfig().getSpecMap().keySet().contains(STARDIST_FIELD_KEY);
        }
        return false;
    }

    public static List<String> fetchStarDistModelNamesFromBioImage() throws InterruptedException {
        BioimageioRepo br = BioimageioRepo.connect();
        List<String> stardistModels = br.listAllModels(false).values().stream().filter(md -> md.getConfig().getSpecMap().keySet().contains(STARDIST_FIELD_KEY)).map(md -> md.getName()).collect(Collectors.toList());
        return stardistModels;
    }

    public static List<String> fetchStarDistModelIdsFromBioImage() throws InterruptedException {
        BioimageioRepo br = BioimageioRepo.connect();
        List<String> stardistModels = br.listAllModels(false).values().stream().filter(md -> md.getConfig().getSpecMap().keySet().contains(STARDIST_FIELD_KEY)).map(md -> md.getModelID()).collect(Collectors.toList());
        return stardistModels;
    }
}

