/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.apposed.appose;

import com.sun.jna.Pointer;
import com.sun.jna.platform.linux.LibRT;
import com.sun.jna.platform.win32.Kernel32;
import io.bioimage.modelrunner.apposed.appose.FilePaths;
import io.bioimage.modelrunner.apposed.appose.Service;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public interface Environment {
    default public String base() {
        return ".";
    }

    default public boolean useSystemPath() {
        return false;
    }

    default public Service python() throws IOException {
        List<String> pythonExes = Arrays.asList("python", "python.exe", "bin/python", "bin/python.exe");
        return this.service(pythonExes, "-c", "import appose.python_worker; appose.python_worker.main()");
    }

    default public Service java(String mainClass, String ... jvmArgs) throws IOException {
        return this.java(mainClass, Collections.emptyList(), jvmArgs);
    }

    default public Service java(String mainClass, List<String> classPath, String ... jvmArgs) throws IOException {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        List<Class> apposeDeps = Arrays.asList(Pointer.class, LibRT.class, Kernel32.class);
        for (Class depClass : apposeDeps) {
            File location = FilePaths.location(depClass);
            if (location == null) continue;
            cp.add(location.getCanonicalPath());
        }
        cp.addAll(classPath);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        args.add(String.join((CharSequence)File.pathSeparator, cp));
        args.addAll(Arrays.asList(jvmArgs));
        args.add(mainClass);
        List<String> javaExes = Arrays.asList("java", "java.exe", "bin/java", "bin/java.exe", "jre/bin/java", "jre/bin/java.exe");
        return this.service(javaExes, args.toArray(new String[0]));
    }

    default public Service service(List<String> exes, String ... args) throws IOException {
        if (args.length == 0) {
            throw new IllegalArgumentException("No executable given");
        }
        List<String> dirs = this.useSystemPath() ? Arrays.asList(System.getenv("PATH").split(File.pathSeparator)) : Arrays.asList(this.base());
        File exeFile = FilePaths.findExe(dirs, exes);
        if (exeFile == null) {
            throw new IllegalArgumentException("No executables found amongst candidates: " + exes);
        }
        String[] allArgs = new String[args.length + 1];
        System.arraycopy(args, 0, allArgs, 1, args.length);
        allArgs[0] = exeFile.getCanonicalPath();
        return new Service(new File(this.base()), allArgs);
    }
}

