/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.apposed.appose;

import com.sun.jna.Platform;
import io.bioimage.modelrunner.apposed.appose.CondaException;
import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import io.bioimage.modelrunner.apposed.appose.MambaInstallerUtils;
import io.bioimage.modelrunner.download.FileDownloader;
import io.bioimage.modelrunner.system.PlatformDetection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveException;

public class Mamba {
    final String mambaCommand;
    private String envName;
    private final String rootdir;
    private final String envsdir;
    private boolean installed = false;
    private Double mambaDnwldProgress = 0.0;
    private Double mambaDecompressProgress = 0.0;
    private Consumer<Double> mambaDnwldProgressConsumer = this::updateMambaDnwldProgress;
    private Consumer<Double> mambaDecompressProgressConsumer = this::updateMambaDecompressProgress;
    private String mambaConsoleOut = "";
    private String mambaConsoleErr = "";
    private Consumer<String> customConsoleConsumer;
    private Consumer<String> customErrorConsumer;
    private Consumer<String> consoleConsumer = this::updateConsoleConsumer;
    private Consumer<String> errConsumer = this::updateErrorConsumer;
    static final String PYTHON_COMMAND = PlatformDetection.isWindows() ? "python.exe" : "bin/python";
    public static final String DEFAULT_ENVIRONMENT_NAME = "base";
    private static final String MICROMAMBA_RELATIVE_PATH = PlatformDetection.isWindows() ? File.separator + "Library" + File.separator + "bin" + File.separator + "micromamba.exe" : File.separator + "bin" + File.separator + "micromamba";
    public static final String BASE_PATH = Paths.get(System.getProperty("user.home"), ".local", "share", "appose", "micromamba").toString();
    public static final String ENVS_NAME = "envs";
    public static final String MICROMAMBA_URL = "https://micro.mamba.pm/api/micromamba/" + Mamba.microMambaPlatform() + "/latest";
    public static final String ERR_STREAM_UUUID = UUID.randomUUID().toString();

    private static String microMambaPlatform() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            osName = "Windows";
        }
        String osArch = System.getProperty("os.arch");
        switch (osName + "|" + osArch) {
            case "Linux|amd64": {
                return "linux-64";
            }
            case "Linux|aarch64": {
                return "linux-aarch64";
            }
            case "Linux|ppc64le": {
                return "linux-ppc64le";
            }
            case "Mac OS X|x86_64": {
                return "osx-64";
            }
            case "Mac OS X|aarch64": {
                return "osx-arm64";
            }
            case "Windows|amd64": {
                return "win-64";
            }
        }
        return null;
    }

    private void updateMambaDnwldProgress(Double pp) {
        double progress = pp != null ? pp : 0.0;
        this.mambaDnwldProgress = progress * 1.0;
    }

    private void updateConsoleConsumer(String str) {
        if (str == null) {
            str = "";
        }
        this.mambaConsoleOut = this.mambaConsoleOut + str;
        if (this.customConsoleConsumer != null) {
            this.customConsoleConsumer.accept(str);
        }
    }

    private void updateErrorConsumer(String str) {
        if (str == null) {
            str = "";
        }
        this.mambaConsoleErr = this.mambaConsoleErr + str;
        if (this.customErrorConsumer != null) {
            this.customErrorConsumer.accept(str);
        }
    }

    private void updateMambaDecompressProgress(Double pp) {
        double progress = pp != null ? pp : 0.0;
        this.mambaDecompressProgress = progress * 1.0;
    }

    private ProcessBuilder getBuilder(boolean isInheritIO) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(new File(this.rootdir));
        if (isInheritIO) {
            builder.inheritIO();
        }
        return builder;
    }

    public Mamba() {
        this(BASE_PATH);
    }

    public Mamba(String rootdir) {
        this.rootdir = rootdir == null ? BASE_PATH : rootdir;
        this.mambaCommand = new File(this.rootdir + MICROMAMBA_RELATIVE_PATH).getAbsolutePath();
        this.envsdir = Paths.get(rootdir, ENVS_NAME).toAbsolutePath().toString();
        boolean filesExist = Files.notExists(Paths.get(this.mambaCommand, new String[0]), new LinkOption[0]);
        if (!filesExist) {
            return;
        }
        try {
            this.getVersion();
        }
        catch (Exception ex) {
            return;
        }
        this.installed = true;
    }

    public boolean checkMambaInstalled() {
        try {
            this.getVersion();
            this.installed = true;
        }
        catch (Exception ex) {
            this.installed = false;
            return false;
        }
        return true;
    }

    public double getMicromambaDownloadProgress() {
        return this.mambaDnwldProgress;
    }

    public double getMicromambaDecompressProgress() {
        return this.mambaDecompressProgress;
    }

    public String getMicromambaConsoleStream() {
        return this.mambaConsoleOut;
    }

    public String getMicromambaErrStream() {
        return this.mambaConsoleErr;
    }

    public void setConsoleOutputConsumer(Consumer<String> custom) {
        this.customConsoleConsumer = custom;
    }

    public void setErrorOutputConsumer(Consumer<String> custom) {
        this.customErrorConsumer = custom;
    }

    private File tempDirMacos() throws IOException, URISyntaxException {
        String filename = "micromamba-" + UUID.randomUUID() + ".tar.bz2";
        File tempFile = new File(BASE_PATH, filename);
        boolean created = tempFile.createNewFile();
        if (!created) {
            throw new IOException("Failed to create temp file: " + tempFile.getAbsolutePath());
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    private File downloadMicromamba() throws IOException, URISyntaxException {
        File tempFile = PlatformDetection.isMacOS() ? this.tempDirMacos() : File.createTempFile("micromamba", ".tar.bz2");
        tempFile.deleteOnExit();
        URL website = FileDownloader.redirectedURL(new URL(MICROMAMBA_URL));
        Consumer<Double> micromambaConsumer = d -> {
            d = Math.round(d * 1000.0) / 10L;
            this.customConsoleConsumer.accept("Installing micromamba: " + d + "%");
        };
        FileDownloader fd = new FileDownloader(website.toString(), tempFile);
        fd.setPartialProgressConsumer(micromambaConsumer);
        long size = fd.getOnlineFileSize();
        try {
            fd.download(Thread.currentThread());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if ((double)tempFile.length() / (double)size < 1.0) {
            throw new IOException("Error downloading micromamba from: " + MICROMAMBA_URL);
        }
        return tempFile;
    }

    private void decompressMicromamba(File tempFile) throws FileNotFoundException, IOException, ArchiveException, InterruptedException {
        File tempTarFile = File.createTempFile("micromamba", ".tar");
        tempTarFile.deleteOnExit();
        MambaInstallerUtils.unBZip2(tempFile, tempTarFile);
        File mambaBaseDir = new File(this.rootdir);
        if (!mambaBaseDir.isDirectory() && !mambaBaseDir.mkdirs()) {
            throw new IOException("Failed to create Micromamba default directory " + mambaBaseDir.getParentFile().getAbsolutePath() + ". Please try installing it in another directory.");
        }
        MambaInstallerUtils.unTar(tempTarFile, mambaBaseDir);
        if (!new File(this.envsdir).isDirectory() && !new File(this.envsdir).mkdirs()) {
            throw new IOException("Failed to create Micromamba default envs directory " + this.envsdir);
        }
        boolean executableSet = new File(this.mambaCommand).setExecutable(true);
        if (!executableSet) {
            throw new IOException("Cannot set file as executable due to missing permissions, please do it manually: " + this.mambaCommand);
        }
    }

    public void installMicromamba() throws IOException, InterruptedException, ArchiveException, URISyntaxException {
        this.checkMambaInstalled();
        if (this.installed) {
            return;
        }
        this.decompressMicromamba(this.downloadMicromamba());
        this.checkMambaInstalled();
    }

    public String getEnvsDir() {
        return this.envsdir;
    }

    private static List<String> getBaseCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (PlatformDetection.isWindows()) {
            cmd.addAll(Arrays.asList("cmd.exe", "/c"));
        }
        return cmd;
    }

    public void update(String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.updateIn(this.envName, args);
    }

    public void updateIn(String envName, String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("update", "-p", this.envsdir + File.separator + envName));
        cmd.addAll(Arrays.asList(args));
        if (!cmd.contains("--yes") && !cmd.contains("-y")) {
            cmd.add("--yes");
        }
        this.runMamba((String[])cmd.stream().toArray(String[]::new));
    }

    public void createWithYaml(String envName, String envYaml) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.createWithYaml(envName, envYaml, false);
    }

    public void createWithYaml(String envName, String envYaml, boolean isForceCreation) throws IOException, InterruptedException, RuntimeException, MambaInstallException {
        if (envName.contains(File.pathSeparator)) {
            throw new IllegalArgumentException("The environment name should not contain the file separator character: '" + File.separator + "'");
        }
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        if (!isForceCreation && this.getEnvironmentNames().contains(envName)) {
            throw new CondaException.EnvironmentExistsException();
        }
        this.runMamba("env", "create", "--prefix", this.envsdir + File.separator + envName, "-f", envYaml, "-y", "-vv");
        if (this.checkDependencyInEnv(this.envsdir + File.separator + envName, "python")) {
            this.installApposeFromSource(this.envsdir + File.separator + envName);
        }
    }

    public void create(String envName) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.create(envName, false);
    }

    public void create(String envName, boolean isForceCreation) throws IOException, InterruptedException, RuntimeException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        if (!isForceCreation && this.getEnvironmentNames().contains(envName)) {
            throw new CondaException.EnvironmentExistsException();
        }
        this.runMamba("create", "-y", "-p", this.envsdir + File.separator + envName);
        if (this.checkDependencyInEnv(this.envsdir + File.separator + envName, "python")) {
            this.installApposeFromSource(this.envsdir + File.separator + envName);
        }
    }

    public void create(String envName, String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.create(envName, false, args);
    }

    public void create(String envName, boolean isForceCreation, String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        if (!isForceCreation && this.getEnvironmentNames().contains(envName)) {
            throw new CondaException.EnvironmentExistsException();
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("create", "-p", this.envsdir + File.separator + envName));
        cmd.addAll(Arrays.asList(args));
        if (!cmd.contains("--yes") && !cmd.contains("-y")) {
            cmd.add("--yes");
        }
        this.runMamba((String[])cmd.stream().toArray(String[]::new));
        if (this.checkDependencyInEnv(this.envsdir + File.separator + envName, "python")) {
            this.installApposeFromSource(this.envsdir + File.separator + envName);
        }
    }

    public void create(String envName, boolean isForceCreation, List<String> channels, List<String> packages) throws IOException, InterruptedException, RuntimeException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        Objects.requireNonNull(envName, "The name of the environment of interest needs to be provided.");
        if (!isForceCreation && this.getEnvironmentNames().contains(envName)) {
            throw new CondaException.EnvironmentExistsException();
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("create", "-p", this.envsdir + File.separator + envName));
        if (channels == null) {
            channels = new ArrayList<String>();
        }
        for (String chan : channels) {
            cmd.add("-c");
            cmd.add(chan);
        }
        if (packages == null) {
            packages = new ArrayList<String>();
        }
        for (String pack : packages) {
            cmd.add(pack);
        }
        if (!cmd.contains("--yes") && !cmd.contains("-y")) {
            cmd.add("--yes");
        }
        this.runMamba((String[])cmd.stream().toArray(String[]::new));
        if (this.checkDependencyInEnv(this.envsdir + File.separator + envName, "python")) {
            this.installApposeFromSource(this.envsdir + File.separator + envName);
        }
    }

    public void activate(String envName) throws IOException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        if (!this.getEnvironmentNames().contains(envName)) {
            throw new IllegalArgumentException("environment: " + envName + " not found.");
        }
        this.setEnvName(envName);
    }

    public void deactivate() throws MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.setEnvName(DEFAULT_ENVIRONMENT_NAME);
    }

    private void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void install(String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.installIn(this.envName, args);
    }

    public void install(List<String> channels, List<String> packages) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.installIn(this.envName, channels, packages);
    }

    public void installIn(String envName, List<String> channels, List<String> packages) throws IOException, InterruptedException, RuntimeException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        Objects.requireNonNull(envName, "The name of the environment of interest needs to be provided.");
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("install", "-y", "-p", this.envsdir + File.separator + envName));
        if (channels == null) {
            channels = new ArrayList<String>();
        }
        for (String chan : channels) {
            cmd.add("-c");
            cmd.add(chan);
        }
        if (packages == null) {
            packages = new ArrayList<String>();
        }
        for (String pack : packages) {
            cmd.add(pack);
        }
        this.runMamba((String[])cmd.stream().toArray(String[]::new));
    }

    public void installIn(String envName, String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("install", "-p", this.envsdir + File.separator + envName));
        cmd.addAll(Arrays.asList(args));
        if (!cmd.contains("--yes") && !cmd.contains("-y")) {
            cmd.add("--yes");
        }
        this.runMamba((String[])cmd.stream().toArray(String[]::new));
    }

    public void pipInstall(String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.pipInstallIn(this.envName, args);
    }

    public void pipInstallIn(String envName, String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("-m", "pip", "install"));
        cmd.addAll(Arrays.asList(args));
        this.runPythonIn(envName, (String[])cmd.stream().toArray(String[]::new));
    }

    public void runPython(String ... args) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.runPythonIn(this.envName, args);
    }

    public void runPythonIn(String envName, String ... args) throws IOException, InterruptedException, MambaInstallException {
        boolean containsSpaces;
        String envDir;
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        List<String> cmd = Mamba.getBaseCommand();
        ArrayList<String> argsList = new ArrayList<String>();
        if (new File(envName, PYTHON_COMMAND).isFile()) {
            argsList.add(Mamba.coverArgWithDoubleQuotes(Paths.get(envName, PYTHON_COMMAND).toAbsolutePath().toString()));
            envDir = Paths.get(envName, new String[0]).toAbsolutePath().toString();
        } else if (Paths.get(this.envsdir, envName, PYTHON_COMMAND).toFile().isFile()) {
            argsList.add(Mamba.coverArgWithDoubleQuotes(Paths.get(this.envsdir, envName, PYTHON_COMMAND).toAbsolutePath().toString()));
            envDir = Paths.get(this.envsdir, envName).toAbsolutePath().toString();
        } else {
            throw new IOException("The environment provided (" + envName + ") does not exist or does not contain a Python executable (" + PYTHON_COMMAND + ").");
        }
        argsList.addAll(Arrays.asList(args).stream().map(aa -> {
            if (aa.contains(" ") && PlatformDetection.isWindows()) {
                return Mamba.coverArgWithDoubleQuotes(aa);
            }
            return aa;
        }).collect(Collectors.toList()));
        boolean bl = containsSpaces = argsList.stream().filter(aa -> aa.contains(" ")).collect(Collectors.toList()).size() > 0;
        if (!containsSpaces || !PlatformDetection.isWindows()) {
            cmd.addAll(argsList);
        } else {
            cmd.add(Mamba.surroundWithQuotes(argsList));
        }
        ProcessBuilder builder = this.getBuilder(false);
        if (PlatformDetection.isWindows()) {
            Map<String, String> envs = builder.environment();
            envs.keySet().removeIf(key -> key.equalsIgnoreCase("PATH") || key.equalsIgnoreCase("PYTHONPATH") || key.equalsIgnoreCase("PYTHONHOME"));
            envs.put("Path", envDir + ";");
            envs.put("Path", Paths.get(envDir, "Scripts").toString() + ";" + envs.get("Path"));
            envs.put("Path", Paths.get(envDir, "Library").toString() + ";" + envs.get("Path"));
            envs.put("Path", Paths.get(envDir, "Library", "Bin").toString() + ";" + envs.get("Path"));
        }
        Mamba.runPythonIn(builder.command(cmd), this.consoleConsumer, this.errConsumer);
    }

    public static void runPythonIn(File envFile, String ... args) throws IOException, InterruptedException {
        boolean containsSpaces;
        if (!Paths.get(envFile.getAbsolutePath(), PYTHON_COMMAND).toFile().isFile()) {
            throw new IOException("No Python found in the environment provided. The following file does not exist: " + Paths.get(envFile.getAbsolutePath(), PYTHON_COMMAND).toAbsolutePath());
        }
        List<String> cmd = Mamba.getBaseCommand();
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(Mamba.coverArgWithDoubleQuotes(Paths.get(envFile.getAbsolutePath(), PYTHON_COMMAND).toAbsolutePath().toString()));
        argsList.addAll(Arrays.asList(args).stream().map(aa -> {
            if (Platform.isWindows() && aa.contains(" ")) {
                return Mamba.coverArgWithDoubleQuotes(aa);
            }
            return aa;
        }).collect(Collectors.toList()));
        boolean bl = containsSpaces = argsList.stream().filter(aa -> aa.contains(" ")).collect(Collectors.toList()).size() > 0;
        if (!containsSpaces || !PlatformDetection.isWindows()) {
            cmd.addAll(argsList);
        } else {
            cmd.add(Mamba.surroundWithQuotes(argsList));
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(envFile);
        if (PlatformDetection.isWindows()) {
            Map<String, String> envs = builder.environment();
            envs.keySet().removeIf(key -> key.equalsIgnoreCase("PATH") || key.equalsIgnoreCase("PYTHONPATH") || key.equalsIgnoreCase("PYTHONHOME"));
            String envDir = envFile.getAbsolutePath();
            envs.put("Path", envDir + ";");
            envs.put("Path", Paths.get(envDir, "Scripts").toString() + ";" + envs.get("Path"));
            envs.put("Path", Paths.get(envDir, "Library").toString() + ";" + envs.get("Path"));
            envs.put("Path", Paths.get(envDir, "Library", "Bin").toString() + ";" + envs.get("Path"));
        }
        Process p = builder.command(cmd).start();
        Thread reader = new Thread(() -> {
            try (BufferedReader or = new BufferedReader(new InputStreamReader(p.getInputStream()));
                 BufferedReader er = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                String line = null;
                String errLine = null;
                while ((line = or.readLine()) != null || (errLine = er.readLine()) != null) {
                    if (line != null) {
                        System.out.println(line);
                    }
                    if (errLine == null) continue;
                    System.out.println(errLine);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "stdout-stderr-reader");
        reader.setDaemon(true);
        reader.start();
        int exitCode = p.waitFor();
        reader.join();
        if (exitCode != 0) {
            throw new RuntimeException("Error executing the following command: " + builder.command());
        }
    }

    private static void runPythonIn(ProcessBuilder builder, Consumer<String> consumerOut, Consumer<String> consumerErr) throws RuntimeException, IOException, InterruptedException, MambaInstallException {
        int processResult;
        Thread mainThread = Thread.currentThread();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Process process = builder.start();
        consumerOut.accept(sdf.format(Calendar.getInstance().getTime()) + " -- STARTING PROCESS: " + builder.command() + System.lineSeparator());
        long updatePeriod = 300L;
        String[] mambaConsoleOut = new String[]{""};
        String[] mambaConsoleErr = new String[]{""};
        Thread outputThread = new Thread(() -> {
            try (InputStream inputStream = process.getInputStream();
                 InputStream errStream = process.getErrorStream();){
                byte[] buffer = new byte[1024];
                StringBuilder processBuff = new StringBuilder();
                StringBuilder errBuff = new StringBuilder();
                String processChunk = "";
                String errChunk = "";
                long t0 = System.currentTimeMillis();
                while (process.isAlive() || Mamba.inputStreamOpen(inputStream)) {
                    int newLineIndex;
                    if (mainThread.isInterrupted() || !mainThread.isAlive()) {
                        process.destroyForcibly();
                        return;
                    }
                    if (Mamba.inputStreamOpen(inputStream)) {
                        processBuff.append(new String(buffer, 0, inputStream.read(buffer)));
                        while ((newLineIndex = processBuff.indexOf(System.lineSeparator())) != -1) {
                            processChunk = processChunk + sdf.format(Calendar.getInstance().getTime()) + " -- " + processBuff.substring(0, newLineIndex + 1).trim() + System.lineSeparator();
                            processBuff.delete(0, newLineIndex + 1);
                        }
                    }
                    if (Mamba.inputStreamOpen(errStream)) {
                        errBuff.append(new String(buffer, 0, errStream.read(buffer)));
                        while ((newLineIndex = errBuff.indexOf(System.lineSeparator())) != -1) {
                            errChunk = errChunk + ERR_STREAM_UUUID + errBuff.substring(0, newLineIndex + 1).trim() + System.lineSeparator();
                            errBuff.delete(0, newLineIndex + 1);
                        }
                    }
                    Thread.sleep(60L);
                    if (System.currentTimeMillis() - t0 <= updatePeriod) continue;
                    consumerOut.accept(processChunk);
                    consumerErr.accept(errChunk);
                    mambaConsoleOut[0] = mambaConsoleOut[0] + processChunk + System.lineSeparator();
                    mambaConsoleErr[0] = mambaConsoleErr[0] + errChunk + System.lineSeparator();
                    processChunk = "";
                    errChunk = "";
                    t0 = System.currentTimeMillis();
                }
                if (Mamba.inputStreamOpen(inputStream)) {
                    processBuff.append(new String(buffer, 0, inputStream.read(buffer)));
                    processChunk = processChunk + sdf.format(Calendar.getInstance().getTime()) + " -- " + processBuff.toString().trim();
                }
                if (Mamba.inputStreamOpen(errStream)) {
                    errBuff.append(new String(buffer, 0, errStream.read(buffer)));
                    errChunk = errChunk + ERR_STREAM_UUUID + errBuff.toString().trim();
                }
                consumerErr.accept(errChunk);
                consumerOut.accept(processChunk + System.lineSeparator() + sdf.format(Calendar.getInstance().getTime()) + " -- TERMINATED PROCESS");
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        });
        outputThread.start();
        try {
            processResult = process.waitFor();
        }
        catch (InterruptedException ex) {
            process.destroyForcibly();
            throw new InterruptedException("Mamba process stopped. The command being executed was: " + builder.command());
        }
        outputThread.join();
        if (processResult != 0) {
            throw new RuntimeException("Error executing the following command: " + builder.command() + System.lineSeparator() + mambaConsoleOut[0] + System.lineSeparator() + mambaConsoleErr[0]);
        }
    }

    public String getVersion() throws IOException, InterruptedException, MambaInstallException {
        List<String> cmd = Mamba.getBaseCommand();
        if (this.mambaCommand.contains(" ") && PlatformDetection.isWindows()) {
            cmd.add(Mamba.surroundWithQuotes(Arrays.asList(Mamba.coverArgWithDoubleQuotes(this.mambaCommand), "--version")));
        } else {
            cmd.addAll(Arrays.asList(Mamba.coverArgWithDoubleQuotes(this.mambaCommand), "--version"));
        }
        Process process = this.getBuilder(false).command(cmd).start();
        if (process.waitFor() != 0) {
            throw new RuntimeException("Error getting Micromamba version");
        }
        return new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
    }

    public void runMamba(boolean isInheritIO, String ... args) throws RuntimeException, IOException, InterruptedException, MambaInstallException {
        int processResult;
        boolean containsSpaces;
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        Thread mainThread = Thread.currentThread();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        List<String> cmd = Mamba.getBaseCommand();
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(Mamba.coverArgWithDoubleQuotes(this.mambaCommand));
        argsList.addAll(Arrays.asList(args).stream().map(aa -> {
            if (aa.contains(" ") && PlatformDetection.isWindows()) {
                return Mamba.coverArgWithDoubleQuotes(aa);
            }
            return aa;
        }).collect(Collectors.toList()));
        boolean bl = containsSpaces = argsList.stream().filter(aa -> aa.contains(" ")).collect(Collectors.toList()).size() > 0;
        if (!containsSpaces || !PlatformDetection.isWindows()) {
            cmd.addAll(argsList);
        } else {
            cmd.add(Mamba.surroundWithQuotes(argsList));
        }
        ProcessBuilder builder = this.getBuilder(isInheritIO).command(cmd);
        Process process = builder.start();
        this.consoleConsumer.accept(sdf.format(Calendar.getInstance().getTime()) + " -- STARTING INSTALLATION" + System.lineSeparator());
        long updatePeriod = 300L;
        Thread outputThread = new Thread(() -> {
            try (InputStream inputStream = process.getInputStream();
                 InputStream errStream = process.getErrorStream();){
                byte[] buffer = new byte[1024];
                StringBuilder processBuff = new StringBuilder();
                StringBuilder errBuff = new StringBuilder();
                String processChunk = "";
                String errChunk = "";
                long t0 = System.currentTimeMillis();
                while (process.isAlive() || Mamba.inputStreamOpen(inputStream)) {
                    int newLineIndex;
                    if (mainThread.isInterrupted() || !mainThread.isAlive()) {
                        process.destroyForcibly();
                        return;
                    }
                    if (Mamba.inputStreamOpen(inputStream)) {
                        processBuff.append(new String(buffer, 0, inputStream.read(buffer)));
                        while ((newLineIndex = processBuff.indexOf(System.lineSeparator())) != -1) {
                            processChunk = processChunk + sdf.format(Calendar.getInstance().getTime()) + " -- " + processBuff.substring(0, newLineIndex + 1).trim() + System.lineSeparator();
                            processBuff.delete(0, newLineIndex + 1);
                        }
                    }
                    if (Mamba.inputStreamOpen(errStream)) {
                        errBuff.append(new String(buffer, 0, errStream.read(buffer)));
                        while ((newLineIndex = errBuff.indexOf(System.lineSeparator())) != -1) {
                            errChunk = errChunk + ERR_STREAM_UUUID + errBuff.substring(0, newLineIndex + 1).trim() + System.lineSeparator();
                            errBuff.delete(0, newLineIndex + 1);
                        }
                    }
                    Thread.sleep(60L);
                    if (System.currentTimeMillis() - t0 <= updatePeriod) continue;
                    this.consoleConsumer.accept(processChunk);
                    this.consoleConsumer.accept(errChunk);
                    processChunk = "";
                    errChunk = "";
                    t0 = System.currentTimeMillis();
                }
                if (Mamba.inputStreamOpen(inputStream)) {
                    processBuff.append(new String(buffer, 0, inputStream.read(buffer)));
                    processChunk = processChunk + sdf.format(Calendar.getInstance().getTime()) + " -- " + processBuff.toString().trim();
                }
                if (Mamba.inputStreamOpen(errStream)) {
                    errBuff.append(new String(buffer, 0, errStream.read(buffer)));
                    errChunk = errChunk + ERR_STREAM_UUUID + errBuff.toString().trim();
                }
                this.errConsumer.accept(errChunk);
                this.consoleConsumer.accept(processChunk + System.lineSeparator() + sdf.format(Calendar.getInstance().getTime()) + " -- TERMINATED PROCESS");
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        });
        outputThread.start();
        try {
            processResult = process.waitFor();
        }
        catch (InterruptedException ex) {
            process.destroyForcibly();
            throw new InterruptedException("Mamba process stopped. The command being executed was: " + cmd);
        }
        outputThread.join();
        if (processResult != 0) {
            throw new RuntimeException("Error executing the following command: " + builder.command() + System.lineSeparator() + this.mambaConsoleOut + System.lineSeparator() + this.mambaConsoleErr);
        }
    }

    private static boolean inputStreamOpen(InputStream inputStream) {
        try {
            return inputStream.available() > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void runMamba(String ... args) throws RuntimeException, IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        this.runMamba(false, args);
    }

    public List<String> getEnvironmentNames() throws IOException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        ArrayList<String> envs = new ArrayList<String>(Arrays.asList(DEFAULT_ENVIRONMENT_NAME));
        envs.addAll(Files.list(Paths.get(this.envsdir, new String[0])).map(p -> p.getFileName().toString()).filter(p -> !p.startsWith(".")).collect(Collectors.toList()));
        return envs;
    }

    public boolean checkAllDependenciesInEnv(String envName, List<String> dependencies) throws MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        return this.checkUninstalledDependenciesInEnv(envName, dependencies).size() == 0;
    }

    public List<String> checkUninstalledDependenciesInEnv(String envName, List<String> dependencies) throws MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        File envFile = new File(this.envsdir, envName);
        File envFile2 = new File(envName);
        if (!envFile.isDirectory() && !envFile2.isDirectory()) {
            return dependencies;
        }
        List<String> uninstalled = dependencies.stream().filter(dep -> {
            try {
                return !this.checkDependencyInEnv(envName, (String)dep);
            }
            catch (Exception ex) {
                return true;
            }
        }).collect(Collectors.toList());
        System.out.println(uninstalled);
        return uninstalled;
    }

    public boolean checkDependencyInEnv(String envName, String dependency) throws MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        if (dependency.contains("=<")) {
            throw new IllegalArgumentException("=< is not valid, use <=");
        }
        if (dependency.contains("=>")) {
            throw new IllegalArgumentException("=> is not valid, use >=");
        }
        if (dependency.contains(">") && dependency.contains("<") && !dependency.contains(",")) {
            throw new IllegalArgumentException("Invalid dependency format. To specify both a minimum and maximum version, separate the conditions with a comma. For example: 'torch>2.0.0, torch<2.5.0'.");
        }
        if (dependency.contains("==")) {
            int ind = dependency.indexOf("==");
            return this.checkDependencyInEnv(envName, dependency.substring(0, ind).trim(), dependency.substring(ind + 2).trim());
        }
        if (dependency.contains(">=") && dependency.contains("<=") && dependency.contains(",")) {
            int commaInd = dependency.indexOf(",");
            int highInd = dependency.indexOf(">=");
            int lowInd = dependency.indexOf("<=");
            int minInd = Math.min(Math.min(commaInd, lowInd), highInd);
            String packName = dependency.substring(0, minInd).trim();
            String maxV = dependency.substring(lowInd + 2, lowInd < highInd ? commaInd : dependency.length());
            String minV = dependency.substring(highInd + 2, lowInd < highInd ? dependency.length() : commaInd);
            if (maxV.equals("") || minV.equals("")) {
                throw new IllegalArgumentException("Conditions must always begin with either '<' or '>' signs and then the version number. For example: 'torch>=2.0.0, torch<=2.5.0'.");
            }
            return this.checkDependencyInEnv(envName, packName, minV, maxV, false);
        }
        if (dependency.contains(">=") && dependency.contains("<") && dependency.contains(",")) {
            int commaInd = dependency.indexOf(",");
            int highInd = dependency.indexOf(">=");
            int lowInd = dependency.indexOf("<");
            int minInd = Math.min(Math.min(commaInd, lowInd), highInd);
            String packName = dependency.substring(0, minInd).trim();
            String maxV = dependency.substring(lowInd + 1, lowInd < highInd ? commaInd : dependency.length());
            String minV = dependency.substring(highInd + 2, lowInd < highInd ? dependency.length() : commaInd);
            if (maxV.equals("") || minV.equals("")) {
                throw new IllegalArgumentException("Conditions must always begin with either '<' or '>' signs and then the version number. For example: 'torch>=2.0.0, torch<2.5.0'.");
            }
            return this.checkDependencyInEnv(envName, packName, minV, null, false) && this.checkDependencyInEnv(envName, packName, null, maxV, true);
        }
        if (dependency.contains(">") && dependency.contains("<=") && dependency.contains(",")) {
            int commaInd = dependency.indexOf(",");
            int highInd = dependency.indexOf(">");
            int lowInd = dependency.indexOf("<=");
            int minInd = Math.min(Math.min(commaInd, lowInd), highInd);
            String packName = dependency.substring(0, minInd).trim();
            String maxV = dependency.substring(lowInd + 2, lowInd < highInd ? commaInd : dependency.length());
            String minV = dependency.substring(highInd + 1, lowInd < highInd ? dependency.length() : commaInd);
            if (maxV.equals("") || minV.equals("")) {
                throw new IllegalArgumentException("Conditions must always begin with either '<' or '>' signs and then the version number. For example: 'torch>2.0.0, torch<=2.5.0'.");
            }
            return this.checkDependencyInEnv(envName, packName, minV, null, true) && this.checkDependencyInEnv(envName, packName, null, maxV, false);
        }
        if (dependency.contains(">") && dependency.contains("<") && dependency.contains(",")) {
            int commaInd = dependency.indexOf(",");
            int highInd = dependency.indexOf(">");
            int lowInd = dependency.indexOf("<");
            int minInd = Math.min(Math.min(commaInd, lowInd), highInd);
            String packName = dependency.substring(0, minInd).trim();
            String maxV = dependency.substring(lowInd + 1, lowInd < highInd ? commaInd : dependency.length());
            String minV = dependency.substring(highInd + 1, lowInd < highInd ? dependency.length() : commaInd);
            if (maxV.equals("") || minV.equals("")) {
                throw new IllegalArgumentException("Conditions must always begin with either '<' or '>' signs and then the version number. For example: 'torch>2.0.0, torch<2.5.0'.");
            }
            return this.checkDependencyInEnv(envName, packName, minV, maxV, true);
        }
        if (dependency.contains(">=")) {
            int ind = dependency.indexOf(">=");
            String maxV = dependency.substring(ind + 2).trim();
            if (maxV.equals("")) {
                throw new IllegalArgumentException("Conditions must always begin with either '<' or '>' signs and then the version number. For example: 'torch>=2.0.0'.");
            }
            return this.checkDependencyInEnv(envName, dependency.substring(0, ind).trim(), maxV, null, false);
        }
        if (dependency.contains(">")) {
            int ind = dependency.indexOf(">");
            String maxV = dependency.substring(ind + 1).trim();
            if (maxV.equals("")) {
                throw new IllegalArgumentException("Conditions must always begin with either '<' or '>' signs and then the version number. For example: 'torch>2.0.0'.");
            }
            return this.checkDependencyInEnv(envName, dependency.substring(0, ind).trim(), maxV, null, true);
        }
        if (dependency.contains("<=")) {
            int ind = dependency.indexOf("<=");
            String maxV = dependency.substring(ind + 2).trim();
            if (maxV.equals("")) {
                throw new IllegalArgumentException("Conditions must always begin with either '<' or '>' signs and then the version number. For example: 'torch<=2.0.0'.");
            }
            return this.checkDependencyInEnv(envName, dependency.substring(0, ind).trim(), null, maxV, false);
        }
        if (dependency.contains("<")) {
            int ind = dependency.indexOf("<");
            String maxV = dependency.substring(ind + 1).trim();
            if (maxV.equals("")) {
                throw new IllegalArgumentException("Conditions must always begin with either '<' or '>' signs and then the version number. For example: 'torch<2.0.0'.");
            }
            return this.checkDependencyInEnv(envName, dependency.substring(0, ind).trim(), null, maxV, true);
        }
        if (dependency.contains("=")) {
            int ind = dependency.indexOf("=");
            return this.checkDependencyInEnv(envName, dependency.substring(0, ind).trim(), dependency.substring(ind + 1).trim());
        }
        return this.checkDependencyInEnv(envName, dependency, null);
    }

    public boolean checkDependencyInEnv(String envDir, String dependency, String version) throws MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        return this.checkDependencyInEnv(envDir, dependency, version, version, true);
    }

    public boolean checkDependencyInEnv(String envDir, String dependency, String minversion, String maxversion) throws MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        return this.checkDependencyInEnv(envDir, dependency, minversion, maxversion, true);
    }

    public boolean checkDependencyInEnv(String envDir, String dependency, String minversion, String maxversion, boolean strictlyBiggerOrSmaller) throws MambaInstallException {
        String checkDepCode;
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        File envFile = new File(this.envsdir, envDir);
        File envFile2 = new File(envDir);
        if (!envFile.isDirectory() && !envFile2.isDirectory()) {
            return false;
        }
        if (!envFile.isDirectory()) {
            envFile = envFile2;
        }
        if ((dependency = Mamba.resolveAliases(dependency)).trim().equals("python")) {
            return this.checkPythonInstallation(envDir, minversion, maxversion, strictlyBiggerOrSmaller);
        }
        if (minversion != null && maxversion != null && minversion.equals(maxversion)) {
            checkDepCode = "import importlib.util, sys; from importlib.metadata import version; from packaging import version as vv; pkg = '%s'; wanted_v = '%s'; spec = importlib.util.find_spec(pkg); vv_og = vv.parse(version(pkg)); vv_nw = vv.parse(wanted_v); sys.exit(1) if spec is None else None; sys.exit(1) if vv_og.major != vv_nw.major else None; sys.exit(1) if vv_og.minor != vv_nw.minor else None; sys.exit(1) if vv_og.micro != vv_nw.micro else None; sys.exit(0);";
            checkDepCode = String.format(checkDepCode, dependency, maxversion);
        } else if (minversion == null && maxversion == null) {
            checkDepCode = "import importlib.util, sys; sys.exit(0) if importlib.util.find_spec('%s') else sys.exit(1)";
            checkDepCode = String.format(checkDepCode, dependency);
        } else if (maxversion == null) {
            checkDepCode = "import importlib.util, sys; from importlib.metadata import version; from packaging import version as vv; pkg = '%s'; desired_version = '%s'; spec = importlib.util.find_spec(pkg); curr_v = vv.parse(version(pkg)); curr_v_str = str(curr_v.major) + '.' + str(curr_v.minor) + '.' + str(curr_v.micro); sys.exit(0) if spec and vv.parse(curr_v_str) %s vv.parse(desired_version) else sys.exit(1)";
            checkDepCode = String.format(checkDepCode, dependency, minversion, strictlyBiggerOrSmaller ? ">" : ">=");
        } else if (minversion == null) {
            checkDepCode = "import importlib.util, sys; from importlib.metadata import version; from packaging import version as vv; pkg = '%s'; desired_version = '%s'; spec = importlib.util.find_spec(pkg); curr_v = vv.parse(version(pkg)); curr_v_str = str(curr_v.major) + '.' + str(curr_v.minor) + '.' + str(curr_v.micro); sys.exit(0) if spec and vv.parse(curr_v_str) %s vv.parse(desired_version) else sys.exit(1)";
            checkDepCode = String.format(checkDepCode, dependency, maxversion, strictlyBiggerOrSmaller ? "<" : "<=");
        } else {
            checkDepCode = "import importlib.util, sys; from importlib.metadata import version; from packaging import version as vv; pkg = '%s'; min_v = '%s'; max_v = '%s'; spec = importlib.util.find_spec(pkg); curr_v = vv.parse(version(pkg)); curr_v_str = str(curr_v.major) + '.' + str(curr_v.minor) + '.' + str(curr_v.micro); sys.exit(0) if spec and vv.parse(curr_v_str) %s vv.parse(min_v) and vv.parse(curr_v_str) %s vv.parse(max_v) else sys.exit(1)";
            checkDepCode = String.format(checkDepCode, dependency, minversion, maxversion, strictlyBiggerOrSmaller ? ">" : ">=", strictlyBiggerOrSmaller ? "<" : "<=");
        }
        try {
            Mamba.runPythonIn(envFile, "-c", checkDepCode);
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            return false;
        }
        return true;
    }

    private static String resolveAliases(String dep) {
        if (dep.equals("pytorch")) {
            return "torch";
        }
        return dep.replace("-", "_");
    }

    private boolean checkPythonInstallation(String envDir, String minversion, String maxversion, boolean strictlyBiggerOrSmaller) throws MambaInstallException {
        String checkDepCode;
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        File envFile = new File(this.envsdir, envDir);
        File envFile2 = new File(envDir);
        if (!envFile.isDirectory() && !envFile2.isDirectory()) {
            return false;
        }
        if (!envFile.isDirectory()) {
            envFile = envFile2;
        }
        if (minversion != null && maxversion != null && minversion.equals(maxversion)) {
            checkDepCode = "import sys; import platform; from packaging import version as vv; desired_version = '%s'; sys.exit(0) if vv.parse(platform.python_version()).major == vv.parse(desired_version).major and vv.parse(platform.python_version()).minor == vv.parse(desired_version).minor else sys.exit(1)";
            checkDepCode = String.format(checkDepCode, maxversion);
        } else if (minversion == null && maxversion == null) {
            checkDepCode = "2 + 2";
        } else if (maxversion == null) {
            checkDepCode = "import sys; import platform; from packaging import version as vv; desired_version = '%s'; sys.exit(0) if vv.parse(platform.python_version()).major == vv.parse(desired_version).major and vv.parse(platform.python_version()).minor %s vv.parse(desired_version).minor else sys.exit(1)";
            checkDepCode = String.format(checkDepCode, minversion, strictlyBiggerOrSmaller ? ">" : ">=");
        } else if (minversion == null) {
            checkDepCode = "import sys; import platform; from packaging import version as vv; desired_version = '%s'; sys.exit(0) if vv.parse(platform.python_version()).major == vv.parse(desired_version).major and vv.parse(platform.python_version()).minor %s vv.parse(desired_version).minor else sys.exit(1)";
            checkDepCode = String.format(checkDepCode, maxversion, strictlyBiggerOrSmaller ? "<" : "<=");
        } else {
            checkDepCode = "import platform; from packaging import version as vv; min_v = '%s'; max_v = '%s'; sys.exit(0) if vv.parse(platform.python_version()).major == vv.parse(desired_version).major and vv.parse(platform.python_version()).minor %s vv.parse(min_v).minor and vv.parse(platform.python_version()).minor %s vv.parse(max_v).minor else sys.exit(1)";
            checkDepCode = String.format(checkDepCode, minversion, maxversion, strictlyBiggerOrSmaller ? ">" : ">=", strictlyBiggerOrSmaller ? "<" : ">=");
        }
        try {
            Mamba.runPythonIn(envFile, "-c", checkDepCode);
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean checkEnvFromYamlExists(String envYaml) throws MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        if (envYaml == null || !new File(envYaml).isFile() || envYaml.endsWith(".yaml") && envYaml.endsWith(".yml")) {
            return false;
        }
        return false;
    }

    private static String coverArgWithDoubleQuotes(String arg) {
        String[] specialChars;
        for (String schar : specialChars = new String[]{" "}) {
            if (arg.startsWith("\"") && arg.endsWith("\"") || !arg.contains(schar) || !PlatformDetection.isWindows()) continue;
            return "\"" + arg + "\"";
        }
        return arg;
    }

    private static String surroundWithQuotes(List<String> args) {
        String arg = "\"";
        for (String aa : args) {
            arg = arg + aa + " ";
        }
        arg = arg.substring(0, arg.length() - 1);
        arg = arg + "\"";
        return arg;
    }

    public static void main(String[] args) throws IOException, InterruptedException, MambaInstallException {
        Mamba m = new Mamba("/home/carlos/git/SAMJ-IJ/appose_x86_64");
        boolean aa = m.checkDependencyInEnv("sam2", "torch >=2.3.9, <=3.0.0");
        System.out.println(aa);
    }

    private void installApposeFromSource(String envName) throws IOException, InterruptedException, MambaInstallException {
        this.checkMambaInstalled();
        if (!this.installed) {
            throw new MambaInstallException("Micromamba is not installed");
        }
        String zipResourcePath = "appose-python.zip";
        String outputDirectory = this.getEnvsDir() + File.separator + envName;
        if (new File(envName).isDirectory()) {
            outputDirectory = new File(envName).getAbsolutePath();
        }
        try (InputStream zipInputStream = Mamba.class.getClassLoader().getResourceAsStream(zipResourcePath);
             ZipInputStream zipInput = new ZipInputStream(zipInputStream);){
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                File entryFile = new File(outputDirectory + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                entryFile.getParentFile().mkdirs();
                try (FileOutputStream entryOutput = new FileOutputStream(entryFile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = zipInput.read(buffer)) != -1) {
                        ((OutputStream)entryOutput).write(buffer, 0, bytesRead);
                    }
                }
            }
        }
        this.pipInstallIn(envName, outputDirectory + File.separator + "appose-python");
    }
}

