/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;

public class LogoPanel
extends JPanel {
    private static final long serialVersionUID = -8109832428317782274L;
    private BufferedImage image;
    private AtomicBoolean isDefault = new AtomicBoolean(true);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    LogoPanel(BufferedImage img) {
        this.image = img;
        this.setOpaque(false);
    }

    LogoPanel() {
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int side = Math.min(this.getWidth(), this.getHeight());
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            g.fillRect(0, 0, side, side);
        }
    }

    public void setImage(BufferedImage image, boolean defaultIm) {
        if (!this.isDefault.get() && defaultIm) {
            return;
        }
        this.isDefault.set(false);
        BufferedImage oldIm = this.image;
        this.image = image;
        this.pcs.firePropertyChange("image", oldIm, image);
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.addPropertyChangeListener(l);
        } else {
            super.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }
}

